<?php
session_start();
require_once 'config.php';
require_once 'includes/functions.php';
require_once 'includes/sms_functions.php';
require_once 'includes/url_helper.php';

// CSRF validation
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    die('Invalid request');
}

$phone = $_POST['phone'] ?? '';
$code = $_POST['code'] ?? '';
$application_id = $_SESSION['pending_application_id'] ?? null;

if (empty($phone) || empty($code)) {
    $_SESSION['error'] = 'Please provide phone number and verification code';
    // Build absolute URL (auto-detects localhost vs production)
    header('Location: ' . generateURL('register_student.php'));
    exit;
}

// Verify the code
$result = verifySMSCode($phone, $code);

if ($result['success']) {
    // Mark application as verified
    $pdo = getDB();
    
    if ($application_id) {
        // Update specific application
        $stmt = $pdo->prepare("
            UPDATE student_applications 
            SET email_verified = 1, verified_at = NOW() 
            WHERE id = ? AND email_verified = 0
        ");
        $stmt->execute([$application_id]);
    } else {
        // Update latest application for this phone
        $stmt = $pdo->prepare("
            UPDATE student_applications 
            SET email_verified = 1, verified_at = NOW() 
            WHERE phone = ? AND email_verified = 0
            ORDER BY created_at DESC 
            LIMIT 1
        ");
        $stmt->execute([$phone]);
    }
    
    $_SESSION['verification_success'] = true;
    $_SESSION['verified_phone'] = $phone;
    
    // Build absolute URL for payment page (auto-detects localhost vs production)
    $payment_url = generateURL('payment_for_application.php');
    
    // Redirect to payment page
    header('Location: ' . $payment_url);
    exit;
} else {
    $_SESSION['error'] = $result['error'] ?? 'Verification failed';
    $_SESSION['show_verification_form'] = true;
    // Build absolute URL (auto-detects localhost vs production)
    header('Location: ' . generateURL('register_student.php'));
    exit;
}

