<?php
require_once __DIR__ . '/includes/functions.php';

$message = '';
$messageType = 'info'; // info, success, danger

if (isset($_GET['token']) && !empty($_GET['token'])) {
    $token = trim($_GET['token']);
    
    // Verify the token
    $student = verifyEmailToken($token);
    
    if ($student) {
        // Mark email as verified
        if (markEmailAsVerified($student['id'])) {
            $message = "Email verified successfully! Welcome to " . APP_NAME . ", " . htmlspecialchars($student['first_name']) . "!";
            $messageType = 'success';
            
            // Get updated student info with credentials
            $studentInfo = getStudentById($student['id']);
            
            // Clear the temporary password after retrieving it for display
            if ($studentInfo && isset($studentInfo['temp_password'])) {
                clearTempPassword($student['id']);
            }
        } else {
            $message = "There was an error verifying your email. Please try again.";
            $messageType = 'danger';
        }
    } else {
        $message = "Invalid or expired verification link. Please request a new verification email.";
        $messageType = 'danger';
    }
} else {
    $message = "No verification token provided.";
    $messageType = 'danger';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification - <?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="images/img-melanesys-logo.svg">
    <link rel="alternate icon" href="images/img-melanesys-logo.svg">
    <link rel="apple-touch-icon" href="images/img-melanesys-logo.svg">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root{
            --brand-primary:#6f42c1; /* purple */
            --brand-accent:#20c997;  /* teal */
            --brand-soft:#f3f0ff;    /* soft bg */
        }
        body{background:linear-gradient(135deg,var(--brand-soft),#e8fff9);} 
        .hero{
            background: radial-gradient(1000px 400px at 10% 0%, rgba(111,66,193,.15), rgba(32,201,151,.1)),
                linear-gradient(135deg, rgba(111,66,193,.12), rgba(32,201,151,.12));
            border-radius: 1rem;
        }
        .brand-badge{background:var(--brand-primary);}
        .brand-underline{position:relative; display:inline-block}
        .brand-underline::after{content:""; position:absolute; left:0; right:0; bottom:-.25rem; height:.35rem; background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border-radius:1rem}
        .card-modern{border:0; box-shadow:0 1rem 2rem rgba(0,0,0,.07);}
        .btn-gradient{background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border:0}
        .btn-gradient:hover{filter:brightness(.95)}
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="row justify-content-center min-vh-100 align-items-center">
            <div class="col-md-6">
                <div class="hero p-4 p-md-5 mb-4 text-dark text-center">
                    <div class="d-flex align-items-center justify-content-center mb-2">
                        <span class="badge brand-badge text-white me-2">Email Verification</span>
                    </div>
                    <h1 class="display-6 fw-bold mb-2 brand-underline"><?php echo APP_NAME; ?></h1>
                    <p class="mb-0">Complete your registration by verifying your email address.</p>
                </div>

                <div class="card card-modern">
                    <div class="card-body p-4 p-md-5 text-center">
                        <?php if ($message): ?>
                            <div class="alert alert-<?php echo $messageType; ?> d-flex align-items-center" role="alert">
                                <?php if ($messageType === 'success'): ?>
                                    <i class="bi bi-check-circle-fill me-2"></i>
                                <?php elseif ($messageType === 'danger'): ?>
                                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                <?php else: ?>
                                    <i class="bi bi-info-circle-fill me-2"></i>
                                <?php endif; ?>
                                <div><?php echo htmlspecialchars($message); ?></div>
                            </div>
                        <?php endif; ?>

                        <?php if ($messageType === 'success'): ?>
                            <div class="mb-4">
                                <i class="bi bi-envelope-check text-success" style="font-size: 4rem;"></i>
                            </div>
                            <p class="text-muted mb-4">Your email has been successfully verified. You can now access all features of your account.</p>
                            
                            <?php if (isset($studentInfo) && $studentInfo): ?>
                            <!-- Login Credentials Section -->
                            <div class="alert alert-info border-0 mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="bi bi-key me-2" style="font-size: 1.5rem;"></i>
                                    <h5 class="mb-0">Your Login Credentials</h5>
                                </div>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-person-circle text-primary me-2"></i>
                                            <div>
                                                <small class="text-muted">Username</small>
                                                <div class="fw-bold"><?php echo htmlspecialchars(formatUsernameForMoodle($studentInfo['username'])); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-shield-lock text-primary me-2"></i>
                                            <div>
                                                <small class="text-muted">Password</small>
                                                <div class="fw-bold"><?php echo htmlspecialchars($studentInfo['temp_password'] ?? 'Password not available'); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Your login credentials have also been sent to your email address.
                                    </small>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- WhatsApp Group Section -->
                            <div class="alert alert-success border-0 mb-4" style="background: linear-gradient(135deg, #25D366, #128C7E); color: white;">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="bi bi-whatsapp me-2" style="font-size: 1.5rem;"></i>
                                    <h5 class="mb-0" style="color: white;">Join Our WhatsApp Group!</h5>
                                </div>
                                <p class="mb-3" style="color: white;">Connect with other students, get course updates, and participate in discussions.</p>
                                <a href="<?php echo WHATSAPP_GROUP_LINK; ?>" class="btn btn-light btn-sm" target="_blank" style="color: #25D366; font-weight: bold;">
                                    <i class="bi bi-whatsapp me-1"></i>Join WhatsApp Group
                                </a>
                            </div>
                            
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <a href="index.php" class="btn btn-gradient text-white px-4">
                                    <i class="bi bi-house me-1"></i>Home
                                </a>
                                <?php if (isset($student) && $student): ?>
                                <a href="payments/pay.php?student_id=<?php echo (int)$student['id']; ?>" class="btn btn-primary px-4">
                                    <i class="bi bi-cash-coin me-1"></i> Proceed to Payment
                                </a>
                                <?php endif; ?>
                                <a href="<?php echo MOODLE_URL; ?>" class="btn btn-outline-secondary px-4" target="_blank">
                                    <i class="bi bi-mortarboard me-1"></i> Access Moodle
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="mb-4">
                                <i class="bi bi-envelope-x text-danger" style="font-size: 4rem;"></i>
                            </div>
                            <p class="text-muted mb-4">There was an issue with your email verification. This could be because:</p>
                            <ul class="text-start text-muted mb-4">
                                <li>The verification link has expired (links expire after 24 hours)</li>
                                <li>The link has already been used</li>
                                <li>The link is invalid or corrupted</li>
                            </ul>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <a href="index.php" class="btn btn-gradient text-white px-4">
                                    <i class="bi bi-arrow-left me-1"></i>Back to Registration
                                </a>
                                <a href="<?php echo MOODLE_URL; ?>" class="btn btn-outline-secondary px-4" target="_blank">
                                    <i class="bi bi-mortarboard me-1"></i> Access Moodle
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
