<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class BrandRegistrationOptions {
    /**
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     * @param bool $mock A boolean that specifies whether brand should be a mock or
     *                   not. If true, brand will be registered as a mock brand.
     *                   Defaults to false if no value is provided.
     * @param bool $skipAutomaticSecVet Skip Automatic Secondary Vetting
     * @return CreateBrandRegistrationOptions Options builder
     */
    public static function create(string $brandType = Values::NONE, bool $mock = Values::NONE, bool $skipAutomaticSecVet = Values::NONE): CreateBrandRegistrationOptions {
        return new CreateBrandRegistrationOptions($brandType, $mock, $skipAutomaticSecVet);
    }
}

class CreateBrandRegistrationOptions extends Options {
    /**
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     * @param bool $mock A boolean that specifies whether brand should be a mock or
     *                   not. If true, brand will be registered as a mock brand.
     *                   Defaults to false if no value is provided.
     * @param bool $skipAutomaticSecVet Skip Automatic Secondary Vetting
     */
    public function __construct(string $brandType = Values::NONE, bool $mock = Values::NONE, bool $skipAutomaticSecVet = Values::NONE) {
        $this->options['brandType'] = $brandType;
        $this->options['mock'] = $mock;
        $this->options['skipAutomaticSecVet'] = $skipAutomaticSecVet;
    }

    /**
     * Type of brand being created. One of: "STANDARD", "STARTER". STARTER is for low volume, starter use cases. STANDARD is for all other use cases.
     *
     * @param string $brandType Type of brand being created. One of: "STANDARD",
     *                          "STARTER".
     * @return $this Fluent Builder
     */
    public function setBrandType(string $brandType): self {
        $this->options['brandType'] = $brandType;
        return $this;
    }

    /**
     * A boolean that specifies whether brand should be a mock or not. If true, brand will be registered as a mock brand. Defaults to false if no value is provided.
     *
     * @param bool $mock A boolean that specifies whether brand should be a mock or
     *                   not. If true, brand will be registered as a mock brand.
     *                   Defaults to false if no value is provided.
     * @return $this Fluent Builder
     */
    public function setMock(bool $mock): self {
        $this->options['mock'] = $mock;
        return $this;
    }

    /**
     * A flag to disable automatic secondary vetting for brands which it would otherwise be done.
     *
     * @param bool $skipAutomaticSecVet Skip Automatic Secondary Vetting
     * @return $this Fluent Builder
     */
    public function setSkipAutomaticSecVet(bool $skipAutomaticSecVet): self {
        $this->options['skipAutomaticSecVet'] = $skipAutomaticSecVet;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Messaging.V1.CreateBrandRegistrationOptions ' . $options . ']';
    }
}