<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';

$ref = uuidv4();
$callbackHost = parse_url(PUBLIC_BASE_URL, PHP_URL_HOST) ?: 'example.com';

[$codeUser, $resUser] = momo_create_api_user($ref, $callbackHost);
echo "CREATE_API_USER_HTTP: $codeUser\n";
echo "CREATE_API_USER_RES: $resUser\n";

if ($codeUser !== 201 && $codeUser !== 409) { // 201=Created, 409=Already exists
    exit(1);
}

[$codeKey, $apiKey, $resKey] = momo_create_api_key($ref);
echo "CREATE_API_KEY_HTTP: $codeKey\n";
echo "CREATE_API_KEY_RES: $resKey\n";
if ($apiKey) {
    echo "API_USER_ID: $ref\nAPI_KEY: $apiKey\n";
} else {
    exit(1);
}

