<?php
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/curriculum_catalog.php';

$academyReference = $argv[1] ?? DEFAULT_ACADEMY_REFERENCE;

if (!$academyReference) {
    fwrite(STDERR, "❌ Could not determine academy reference. Pass it explicitly, e.g. php tools/ensure_curriculum_grades.php KINE\n");
    exit(1);
}

$curriculumMap = getCurriculumSubjectMap();
$gradeNames = array_keys($curriculumMap);

$pdo = getDB();
$pdo->beginTransaction();

try {
    $fetchGradeStmt = $pdo->prepare('SELECT id FROM grades WHERE name = ?');
    $createGradeStmt = $pdo->prepare('INSERT INTO grades (name) VALUES (?)');
    $ensureSchoolGradeStmt = $pdo->prepare('
        INSERT INTO school_grades (academy_reference, grade_id, is_active, display_order)
        VALUES (?, ?, 1, ?)
        ON DUPLICATE KEY UPDATE is_active = VALUES(is_active)
    ');

    $order = 1;
    $report = [];

    foreach ($gradeNames as $gradeName) {
        $fetchGradeStmt->execute([$gradeName]);
        $gradeId = $fetchGradeStmt->fetchColumn();

        if (!$gradeId) {
            $createGradeStmt->execute([$gradeName]);
            $gradeId = $pdo->lastInsertId();
            $report[] = "➕ Created missing grade: {$gradeName}";
        }

        $ensureSchoolGradeStmt->execute([$academyReference, $gradeId, $order++]);
    }

    $pdo->commit();

    echo "✅ Curriculum grades enabled for academy {$academyReference}\n";
    foreach ($report as $line) {
        echo " - {$line}\n";
    }

} catch (Throwable $e) {
    $pdo->rollBack();
    fwrite(STDERR, "❌ Error enabling grades: {$e->getMessage()}\n");
    exit(1);
}


