<?php
/**
 * Test Page Access
 * Diagnose why pages aren't loading
 */

session_start();

echo "<!DOCTYPE html><html><head><title>Access Test</title></head><body>";
echo "<h1>Page Access Diagnostic</h1>";
echo "<hr>";

echo "<h3>Session Information:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Admin Login Status:</h3>";
require_once 'includes/functions.php';
if (function_exists('isAdminLoggedIn')) {
    echo isAdminLoggedIn() ? "✅ Admin is logged in" : "❌ Admin NOT logged in";
} else {
    echo "❌ isAdminLoggedIn function not found";
}

echo "<h3>School Context:</h3>";
require_once 'includes/school_context.php';
echo "Current School: " . (getCurrentSchool() ?? "NONE") . "<br>";
echo "Is Super Admin: " . (isSuperAdmin() ? "YES" : "NO") . "<br>";

echo "<h3>Database Connection:</h3>";
try {
    $pdo = getDB();
    $stmt = $pdo->query("SELECT COUNT(*) FROM academy_references");
    $count = $stmt->fetchColumn();
    echo "✅ Database connected - {$count} schools found<br>";
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage();
}

echo "<h3>Test Links:</h3>";
echo '<a href="select_school.php">Test select_school.php</a><br>';
echo '<a href="admin/dashboard.php">Test admin/dashboard.php</a><br>';
echo '<a href="super_admin/dashboard.php">Test super_admin/dashboard.php</a><br>';
echo '<a href="admin/login.php">Login Page</a><br>';

echo "</body></html>";

