<?php
require_once __DIR__ . '/includes/functions.php';
$id = (int)($_GET['id'] ?? 0);
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title><?php echo htmlspecialchars(APP_NAME); ?> - Success</title>
	
	<!-- Favicon -->
	<link rel="icon" type="image/svg+xml" href="images/img-melanesys-logo.svg">
	<link rel="alternate icon" href="images/img-melanesys-logo.svg">
	<link rel="apple-touch-icon" href="images/img-melanesys-logo.svg">
	
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
	<style>
		:root{
			--brand-primary:#6f42c1; /* purple */
			--brand-accent:#20c997;  /* teal */
			--brand-soft:#f3f0ff;    /* soft bg */
		}
		body{background:linear-gradient(135deg,var(--brand-soft),#e8fff9);} 
		.hero{
			background: radial-gradient(1000px 400px at 10% 0%, rgba(111,66,193,.15), rgba(32,201,151,.1)),
				linear-gradient(135deg, rgba(111,66,193,.12), rgba(32,201,151,.12));
			border-radius: 1rem;
		}
		.brand-underline{position:relative; display:inline-block}
		.brand-underline::after{content:""; position:absolute; left:0; right:0; bottom:-.25rem; height:.35rem; background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border-radius:1rem}
		.card-modern{border:0; box-shadow:0 1rem 2rem rgba(0,0,0,.07);}
		.btn-gradient{background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border:0; color:white}
		.btn-gradient:hover{filter:brightness(.95); color:white}
	</style>
</head>
<body>
	<div class="container py-4">
		<div class="hero p-4 p-md-5 mb-4 text-dark text-center">
			<div class="d-flex align-items-center justify-content-center mb-2">
				<span class="badge bg-success text-white me-2">Registration Complete</span>
			</div>
			<h1 class="display-6 fw-bold mb-2 brand-underline"><?php echo APP_NAME; ?></h1>
			<p class="mb-0">Your registration has been successfully submitted!</p>
		</div>

		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="card card-modern">
					<div class="card-body p-4 p-md-5">
						<div class="text-center mb-4">
							<i class="bi bi-check-circle-fill text-success" style="font-size: 4rem;"></i>
							<h3 class="mt-3 text-success">Registration Successful!</h3>
						</div>
						
						<p class="text-center mb-4">Your registration has been recorded successfully. Here's what happens next:</p>
						
						<div class="row g-3 mb-4">
							<div class="col-md-6">
								<div class="d-flex align-items-start">
									<i class="bi bi-envelope-check text-primary me-3 mt-1"></i>
									<div>
										<h6 class="mb-1">Email Verification</h6>
										<p class="text-muted small mb-0">A verification email has been sent to your email address. Please check your inbox and click the verification link to activate your account.</p>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="d-flex align-items-start">
									<i class="bi bi-key text-primary me-3 mt-1"></i>
									<div>
										<h6 class="mb-1">Login Credentials</h6>
										<p class="text-muted small mb-0">Your login credentials will be sent to you via email after your email is verified. You can then access the learning platform.</p>
									</div>
								</div>
							</div>
						</div>
						
						<div class="alert alert-info">
							<i class="bi bi-info-circle me-2"></i>
							<strong>Important:</strong> You must verify your email address within 24 hours to complete your registration. Check your spam folder if you don't see the email.
						</div>
						
						<!-- WhatsApp Group Section -->
						<div class="alert alert-success border-0 mb-4" style="background: linear-gradient(135deg, #25D366, #128C7E); color: white;">
							<div class="d-flex align-items-center mb-3">
								<i class="bi bi-whatsapp me-2" style="font-size: 1.5rem;"></i>
								<h5 class="mb-0" style="color: white;">Join Our WhatsApp Group!</h5>
							</div>
							<p class="mb-3" style="color: white;">Connect with other students, get course updates, and participate in discussions.</p>
							<a href="<?php echo WHATSAPP_GROUP_LINK; ?>" class="btn btn-light btn-sm" target="_blank" style="color: #25D366; font-weight: bold;">
								<i class="bi bi-whatsapp me-1"></i>Join WhatsApp Group
							</a>
						</div>
						
						<div class="text-center">
							<p class="mb-0">Student ID: <span class="badge bg-secondary fs-6"><?php echo (int)$id; ?></span></p>
						</div>
					</div>
				</div>
				<div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
					<a href="index.php" class="btn btn-gradient">
						<i class="bi bi-person-plus me-1"></i>Register New Student
					</a>
					<a href="<?php echo MOODLE_URL; ?>" class="btn btn-outline-primary" target="_blank">
						<i class="bi bi-mortarboard me-1"></i>Access Portal
					</a>
				</div>
			</div>
		</div>
	</div>
</body>
</html>

