<?php
session_start();
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';

// Check if student is logged in
if (!isset($_SESSION['student_id'])) {
    header('Location: ../login.php');
    exit;
}

$student_id = $_SESSION['student_id'];
$student = getStudentById($student_id);

// Get error message if available
$error_message = $_GET['error'] ?? 'Payment was not completed successfully.';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Failed - Skolo-Kine</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #dc3545 0%, #fd7e14 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .failure-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .failure-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #dc3545, #fd7e14);
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
            margin-bottom: 20px;
        }
        .btn-retry {
            background: linear-gradient(135deg, #dc3545, #fd7e14);
            border: none;
            border-radius: 25px;
            padding: 15px 40px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
        }
        .btn-retry:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
        .btn-dashboard {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border: none;
            border-radius: 25px;
            padding: 15px 40px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
        }
        .btn-dashboard:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="failure-card p-5 text-center">
                    <div class="failure-icon">
                        <i class="fas fa-times"></i>
                    </div>
                    
                    <h2 class="text-danger mb-3">Payment Failed</h2>
                    <p class="text-muted mb-4"><?php echo htmlspecialchars($error_message); ?></p>
                    
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Don't worry!</strong> No charges have been made to your account. You can try again or contact support if the problem persists.
                    </div>
                    
                    <div class="mt-4">
                        <a href="pay.php" class="btn btn-retry text-white me-3">
                            <i class="fas fa-redo me-2"></i>
                            Try Again
                        </a>
                        <a href="../dashboard.php" class="btn btn-dashboard text-white">
                            <i class="fas fa-tachometer-alt me-2"></i>
                            Go to Dashboard
                        </a>
                    </div>
                    
                    <div class="mt-4">
                        <h6 class="text-muted">Need Help?</h6>
                        <p class="small text-muted">
                            If you continue to experience issues, please contact our support team at 
                            <a href="mailto:support@skolo-kine.com">support@skolo-kine.com</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
