<?php
/**
 * Example: Upload Payment Receipt (Updated for Tenant System)
 */

session_start();
require_once '../config.php';
require_once '../includes/tenant_directory_manager.php';
require_once '../includes/tenant_file_upload.php';

// Check authentication
if (!isset($_SESSION['user_id']) || !isset($_SESSION['academy_reference'])) {
    die(json_encode(['success' => false, 'error' => 'Not authenticated']));
}

// Database connection
$conn = new PDO(
    "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
    DB_USER,
    DB_PASS
);

// Initialize upload handler
$dirManager = new TenantDirectoryManager($conn);
$uploader = new TenantFileUpload($conn, $dirManager);

// Handle upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['receipt'])) {
    $payment_id = (int)$_POST['payment_id'];
    
    // Verify payment belongs to this tenant
    $stmt = $conn->prepare("
        SELECT id FROM payments 
        WHERE id = ? AND academy_reference = ?
    ");
    $stmt->execute([$payment_id, $_SESSION['academy_reference']]);
    
    if (!$stmt->fetch()) {
        die(json_encode(['success' => false, 'error' => 'Payment not found']));
    }
    
    // Upload receipt
    $result = $uploader->uploadPaymentReceipt(
        $_SESSION['academy_reference'],
        $payment_id,
        $_FILES['receipt']
    );
    
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Payment Receipt</title>
</head>
<body>
    <h2>Upload Payment Receipt</h2>
    
    <form method="post" enctype="multipart/form-data" id="upload-form">
        <label>Payment ID:</label>
        <input type="number" name="payment_id" required><br><br>
        
        <label>Receipt (PDF or Image):</label>
        <input type="file" name="receipt" accept=".pdf,image/jpeg,image/png" required><br><br>
        
        <button type="submit">Upload Receipt</button>
    </form>
    
    <div id="result"></div>
    
    <script>
    document.getElementById('upload-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const formData = new FormData(e.target);
        const response = await fetch('', {
            method: 'POST',
            body: formData
        });
        
        const result = await response.json();
        const resultDiv = document.getElementById('result');
        
        if (result.success) {
            resultDiv.innerHTML = `
                <p style="color:green;">✓ Receipt uploaded successfully!</p>
                <a href="${result.url}" target="_blank">View Receipt</a>
            `;
        } else {
            resultDiv.innerHTML = `<p style="color:red;">✗ Error: ${result.error}</p>`;
        }
    });
    </script>
</body>
</html>

