<?php
/**
 * Example: Upload Document (Updated for Tenant System)
 */

session_start();
require_once '../config.php';
require_once '../includes/tenant_directory_manager.php';
require_once '../includes/tenant_file_upload.php';

// Check authentication
if (!isset($_SESSION['user_id']) || !isset($_SESSION['academy_reference'])) {
    die(json_encode(['success' => false, 'error' => 'Not authenticated']));
}

// Database connection
$conn = new PDO(
    "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
    DB_USER,
    DB_PASS
);

// Initialize upload handler
$dirManager = new TenantDirectoryManager($conn);
$uploader = new TenantFileUpload($conn, $dirManager);

// Handle upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['document'])) {
    $student_id = isset($_POST['student_id']) ? (int)$_POST['student_id'] : null;
    $description = $_POST['description'] ?? '';
    $tags = $_POST['tags'] ?? '';
    
    // Upload document
    $result = $uploader->uploadDocument(
        $_SESSION['academy_reference'],
        $_FILES['document'],
        [
            'description' => $description,
            'tags' => $tags,
            'related_id' => $student_id,
            'related_type' => $student_id ? 'student' : null
        ]
    );
    
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Document</title>
</head>
<body>
    <h2>Upload Document</h2>
    
    <form method="post" enctype="multipart/form-data" id="upload-form">
        <label>Document:</label>
        <input type="file" name="document" accept=".pdf,.doc,.docx,.xls,.xlsx" required><br><br>
        
        <label>Description:</label>
        <input type="text" name="description" placeholder="e.g., Course syllabus"><br><br>
        
        <label>Tags:</label>
        <input type="text" name="tags" placeholder="e.g., syllabus,math,form1"><br><br>
        
        <label>Related to Student ID (optional):</label>
        <input type="number" name="student_id"><br><br>
        
        <button type="submit">Upload Document</button>
    </form>
    
    <div id="result"></div>
    
    <script>
    document.getElementById('upload-form').addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const formData = new FormData(e.target);
        const response = await fetch('', {
            method: 'POST',
            body: formData
        });
        
        const result = await response.json();
        const resultDiv = document.getElementById('result');
        
        if (result.success) {
            resultDiv.innerHTML = `
                <p style="color:green;">✓ Document uploaded successfully!</p>
                <p>File ID: ${result.file_id}</p>
                <a href="${result.url}" target="_blank">View Document</a>
            `;
        } else {
            resultDiv.innerHTML = `<p style="color:red;">✗ Error: ${result.error}</p>`;
        }
    });
    </script>
</body>
</html>

