<?php
/**
 * Tenant Backup Usage Examples
 * 
 * Shows how to use the TenantBackup class
 */

require_once '../config.php';
require_once '../includes/tenant_directory_manager.php';
require_once '../includes/tenant_backup.php';

// Database connection
$conn = new PDO(
    "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
    DB_USER,
    DB_PASS
);

// Initialize
$dirManager = new TenantDirectoryManager($conn);
$backup = new TenantBackup($conn, $dirManager);

$tenant_id = 'soshigh_demo';

// =====================================================
// EXAMPLE 1: Backup Database
// =====================================================

echo "Example 1: Backup Tenant Database\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->backupTenantDatabase($tenant_id);

if ($result['success']) {
    echo "✓ Database backup created\n";
    echo "  Filename: {$result['filename']}\n";
    echo "  Size: {$result['size_formatted']}\n";
    echo "  Checksum: {$result['checksum']}\n";
} else {
    echo "✗ Backup failed: {$result['error']}\n";
}

echo "\n";

// =====================================================
// EXAMPLE 2: Backup Files
// =====================================================

echo "Example 2: Backup Tenant Files\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->backupTenantFiles($tenant_id);

if ($result['success']) {
    echo "✓ Files backup created\n";
    echo "  Filename: {$result['filename']}\n";
    echo "  Size: {$result['size_formatted']}\n";
    echo "  Files: {$result['file_count']}\n";
} else {
    echo "✗ Backup failed: {$result['error']}\n";
}

echo "\n";

// =====================================================
// EXAMPLE 3: Full Backup
// =====================================================

echo "Example 3: Full Tenant Backup\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->fullTenantBackup($tenant_id);

if ($result['success']) {
    echo "✓ Full backup created\n";
    echo "  Filename: {$result['filename']}\n";
    echo "  Size: {$result['size_formatted']}\n";
} else {
    echo "✗ Backup failed: {$result['error']}\n";
}

echo "\n";

// =====================================================
// EXAMPLE 4: List Backups
// =====================================================

echo "Example 4: List All Backups\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->listTenantBackups($tenant_id);

if ($result['success']) {
    echo "✓ Found {$result['count']} backup(s)\n\n";
    
    foreach ($result['backups'] as $b) {
        echo "  {$b['filename']}\n";
        echo "    Type: {$b['type']}\n";
        echo "    Size: {$b['size_formatted']}\n";
        echo "    Date: {$b['date']}\n\n";
    }
} else {
    echo "✗ Failed: {$result['error']}\n";
}

// =====================================================
// EXAMPLE 5: Schedule Backup
// =====================================================

echo "Example 5: Schedule Automatic Backup\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->scheduleTenantBackup($tenant_id, 'daily');

if ($result['success']) {
    echo "✓ Backup scheduled: {$result['schedule']}\n";
} else {
    echo "✗ Failed: {$result['error']}\n";
}

echo "\n";

// =====================================================
// EXAMPLE 6: Cleanup Old Backups
// =====================================================

echo "Example 6: Cleanup Old Backups (keep last 5)\n";
echo str_repeat("-", 60) . "\n";

$result = $backup->cleanupOldBackups($tenant_id, 5);

if ($result['success']) {
    echo "✓ Cleanup complete\n";
    echo "  Deleted: {$result['deleted']} backup(s)\n";
    echo "  Kept: {$result['kept']} backup(s)\n";
    echo "  Space freed: {$result['space_freed_formatted']}\n";
} else {
    echo "✗ Failed: {$result['error']}\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "Examples complete!\n";

