# 🔧 Troubleshooting Guide

## 🚨 **Common Issues & Solutions**

### **Issue 1: Bot Not Running**
**Symptoms:**
- No new users in Moodle
- No log entries
- Cron job not executing

**Solutions:**
1. **Check file permissions:**
   ```bash
   chmod 755 moodle_sync_bot.php
   chmod 777 temp/ logs/
   ```

2. **Delete lock file:**
   ```bash
   rm bot/temp/sync.lock
   ```

3. **Verify cron job syntax:**
   ```bash
   /usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/bot/moodle_sync_bot.php
   ```

4. **Test manually:**
   - Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
   - Click "Run Bot Now"

---

### **Issue 2: API Key Authentication Failed**
**Symptoms:**
- HTTP 401 errors
- "Unauthorized" messages
- CSV download fails

**Solutions:**
1. **Check API key in `api/export_csv.php`:**
   ```php
   $API_KEY = 'skolo_prod_2024_8f9a2b3c4d5e6f7a8b9c0d1e2f3a4b5c';
   ```

2. **Verify bot configuration:**
   ```php
   'skolo_api_key' => 'skolo_prod_2024_8f9a2b3c4d5e6f7a8b9c0d1e2f3a4b5c'
   ```

3. **Test API endpoint:**
   - Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`

---

### **Issue 3: Moodle Connection Errors**
**Symptoms:**
- "Access control exception"
- "Token not found"
- "Invalid parameter value detected"

**Solutions:**
1. **Check Moodle web service token:**
   ```php
   'moodle_token' => 'edb3c3837e8d5b89ae35b92d1dfc40e2'
   ```

2. **Verify Moodle URL:**
   ```php
   'moodle_url' => 'https://skoloi.melanegroup.com/kine/webservice/rest/server.php'
   ```

3. **Check Moodle web service functions:**
   - `core_user_create_users`
   - `core_user_get_users_by_field`
   - `core_course_get_courses`
   - `enrol_manual_enrol_users`

---

### **Issue 4: Users Not Being Enrolled**
**Symptoms:**
- Users created in Moodle
- No course enrollments
- "No groups" in Moodle

**Solutions:**
1. **Check subject mapping:**
   - Verify all subjects are mapped to courses
   - Check bot logs for mapping warnings

2. **Verify enrollment function:**
   - Ensure `enrol_manual_enrol_users` is enabled in Moodle
   - Check if user has proper permissions

3. **Test enrollment manually:**
   - Use Moodle admin to manually enroll a user
   - Verify the course exists and is active

---

### **Issue 5: CSV Format Issues**
**Symptoms:**
- "Parsed 0 users from CSV"
- "CSV missing subject data"
- Wrong column count

**Solutions:**
1. **Check CSV headers:**
   ```csv
   username,firstname,lastname,password,email,grade_name,subject_ids
   ```

2. **Verify API endpoint:**
   - Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`
   - Should show 7 columns

3. **Check database:**
   - Ensure students have `email_verified = TRUE`
   - Verify subject data exists

---

### **Issue 6: Permission Denied Errors**
**Symptoms:**
- "Permission denied"
- "Cannot create file"
- "Access denied"

**Solutions:**
1. **Set correct permissions:**
   ```bash
   chmod 755 *.php
   chmod 777 temp/ logs/
   ```

2. **Check file ownership:**
   - Files should be owned by your cPanel user
   - Use File Manager to change ownership if needed

3. **Verify folder structure:**
   ```
   bot/
   ├── temp/ (777)
   ├── logs/ (777)
   └── moodle_sync_bot.php (755)
   ```

---

### **Issue 7: Cleanup Not Working**
**Symptoms:**
- Unverified users not being deleted
- Database growing with old records

**Solutions:**
1. **Check cleanup script permissions:**
   ```bash
   chmod 755 cleanup_unverified_users.php
   ```

2. **Verify cron job:**
   ```bash
   /usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/cleanup_unverified_users.php
   ```

3. **Test manually:**
   - Go to admin dashboard
   - Click "Clean Up Now" button

---

## 🔍 **Debugging Steps**

### **Step 1: Check Logs**
1. Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
2. Look for error messages
3. Check timestamps

### **Step 2: Test Components**
1. **API Test**: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`
2. **Bot Test**: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
3. **Admin Test**: `https://kine.melanegroup.com/Skolo-Kine/admin/dashboard.php`

### **Step 3: Verify Configuration**
1. Check all file permissions
2. Verify cron job syntax
3. Confirm API keys match
4. Test Moodle connection

### **Step 4: Check Moodle**
1. Login to Moodle admin
2. Check web service status
3. Verify user creation
4. Check course enrollments

---

## 📞 **Getting Help**

### **Log Files to Check:**
- Bot logs: `bot/logs/`
- cPanel error logs
- Moodle logs

### **Information to Provide:**
1. Error messages
2. Log file contents
3. Steps to reproduce
4. Current configuration

### **Quick Fixes:**
1. **Restart bot**: Delete `bot/temp/sync.lock`
2. **Reset permissions**: Set all files to 755, folders to 777
3. **Test manually**: Use web interface to run bot
4. **Check Moodle**: Verify web service is working

---

**🔧 Most issues can be resolved by checking permissions and verifying configuration!**
