# ⚡ Quick Deployment Checklist

## 🎯 **Essential Files to Upload**

### **1. Core Bot Files**
- [ ] `api/export_csv.php` → Replace existing
- [ ] `bot/moodle_sync_bot.php` → Replace existing  
- [ ] `includes/functions.php` → Replace existing
- [ ] `cleanup_unverified_users.php` → Upload new
- [ ] `bot/fix_subject_configuration.php` → Upload new (run once, then delete)

### **2. Set Permissions**
- [ ] `bot/moodle_sync_bot.php` → 755
- [ ] `cleanup_unverified_users.php` → 755
- [ ] `bot/temp/` folder → 777
- [ ] `bot/logs/` folder → 777

## 🎯 **Cron Jobs Setup**

### **Bot Cron Job (Every 5 minutes)**
```bash
/usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/bot/moodle_sync_bot.php
```

### **Cleanup Cron Job (Every hour)**
```bash
/usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/cleanup_unverified_users.php
```

## 🎯 **Test URLs**

- **Bot Interface**: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
- **API Test**: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`
- **Admin Dashboard**: `https://kine.melanegroup.com/Skolo-Kine/admin/dashboard.php`
- **Fix Subjects**: `https://kine.melanegroup.com/Skolo-Kine/bot/fix_subject_configuration.php` (run once, then delete)

## 🎯 **Quick Verification**

1. [ ] API returns 200 status with 7 columns
2. [ ] Bot runs without errors
3. [ ] Users appear in Moodle
4. [ ] Users are enrolled in courses
5. [ ] Only email-verified students are processed

## 🎯 **Success Indicators**

- ✅ **343 enrollments, 0 errors** (from last test)
- ✅ **46 email-verified students processed**
- ✅ **All subjects mapped to courses**
- ✅ **Automated cleanup working**

---

**🚀 Your bot is ready for production!**
