# Onboarding New School - Step by Step Guide

## 📋 Checklist for Adding a New School

### Pre-Onboarding (Before School Signup)

- [ ] **Collect School Information**
  - School official name
  - School email address
  - School phone number
  - School physical address
  - Preferred reference code (e.g., STMARY, GRACEH, etc.)
  - Admin name and contact details

- [ ] **Business Agreement**
  - Pricing confirmed (E0.30 per subject/student)
  - Platform fee confirmed (E0.50 per student)
  - Payment terms agreed
  - Contract signed (if applicable)

### Step 1: Create School in System (5 minutes)

**Option A: Via Super Admin Panel (Recommended)**
1. Login as super admin
2. Go to Super Admin Dashboard
3. Click "Add New School"
4. Fill in the form:
   - School Name: e.g., "St. Mary's High School"
   - Reference Code: e.g., "STMARY" (2-10 characters, uppercase)
   - Description: Brief description
   - Admin Email: admin@stmarys.com
   - Admin Password: Create secure password
5. Click "Create School"
6. Note the admin username (will be: `stmary_admin`)

**Option B: Via Database (Manual)**
```sql
-- 1. Create admin user
INSERT INTO admins (username, password_hash, academy_reference)
VALUES ('stmary_admin', '<?php echo password_hash("SecurePass123", PASSWORD_DEFAULT); ?>', 'STMARY');

SET @admin_id = LAST_INSERT_ID();

-- 2. Create academy reference
INSERT INTO academy_references (admin_id, academy_name, reference_code, description, is_active)
VALUES (@admin_id, 'St. Mary\'s High School', 'STMARY', 'Catholic School in Mbabane', 1);

-- 3. Create admin wallet
INSERT INTO admin_wallet (admin_id, balance, currency)
VALUES (@admin_id, 0.00, 'SZL');

-- 4. Add default settings
INSERT INTO tenant_settings (academy_reference, setting_key, setting_value) VALUES
('STMARY', 'school_name', 'St. Mary\'s High School'),
('STMARY', 'school_email', 'admin@stmarys.com'),
('STMARY', 'school_phone', '+268 1234 5678'),
('STMARY', 'academic_year', '2024/2025'),
('STMARY', 'primary_color', '#DC2626'),
('STMARY', 'secondary_color', '#059669');
```

### Step 2: Provide Admin Credentials (2 minutes)

Send the school admin:
```
Subject: Welcome to Skolo-Kine - Your School Portal

Dear [School Admin Name],

Your school has been successfully added to Skolo-Kine!

Login Details:
- URL: https://kine.melanegroup.com/admin/login.php
- Username: stmary_admin
- Password: [the password you set]

After logging in, you can:
✓ Add students
✓ Manage enrollments
✓ Track payments
✓ Customize school settings
✓ View reports

Need help? Contact support@melanegroup.com

Best regards,
Skolo-Kine Team
```

### Step 3: School Admin Setup (10 minutes)

**Guide the school admin to:**

1. **Login** using provided credentials
2. **Change Password** (recommended immediately)
3. **Update School Settings**
   - Go to "School Settings"
   - Update school details
   - Upload logo (optional)
   - Set brand colors
   - Configure email settings
4. **Configure Subjects** (if different from default)
   - Go to "Configure Subjects"
   - Set subject prices if different from default

### Step 4: Import Students (Method 1 - Bulk Upload)

If school has existing students:

1. **Prepare CSV File** with format:
```csv
first_name,last_name,email,phone,grade_id,subjects
John,Doe,john@email.com,+268XXXXXXXX,1,"1,2,3,4,5"
Jane,Smith,jane@email.com,+268XXXXXXXX,1,"1,2,3,4"
```

2. **Create Import Script** (tools/import_students.php)
```php
// Reads CSV and creates students with academy_reference = 'STMARY'
```

3. **Run Import**
```bash
php tools/import_students.php --school=STMARY --file=students.csv
```

### Step 4: Add Students (Method 2 - Manual Entry)

1. Login to school admin panel
2. Click "Create Student"
3. Fill in student details
4. Student will automatically be assigned to the current school (STMARY)
5. Student receives email verification
6. After verification, student can login and access Moodle

### Step 5: Configure Moodle Integration (15 minutes)

If school has their own Moodle:

1. **Get Moodle Credentials**
   - Moodle URL
   - Moodle API Token

2. **Add to School Settings**
```php
setSchoolSetting('moodle_url', 'https://moodle.stmarys.com');
setSchoolSetting('moodle_token', 'abc123token');
```

3. **Test Sync**
   - Create a test student
   - Verify they appear in Moodle
   - Verify they can login to Moodle

### Step 6: Configure Payments (10 minutes)

1. **MTN MoMo Setup**
   - School provides their MoMo business number
   - Update admin wallet settings
   
2. **Test Payment Flow**
   - Create test student
   - Make test payment
   - Verify payment appears in wallet
   - Verify platform fee (E0.50) is tracked

### Step 7: Training & Handover (30 minutes)

**Train school admin on:**
- [ ] Creating students
- [ ] Managing enrollments
- [ ] Processing payments
- [ ] Viewing reports
- [ ] Managing subjects and pricing
- [ ] Using school settings
- [ ] Requesting withdrawals

**Provide Documentation:**
- Admin user guide
- Payment processing guide
- Moodle integration guide
- Troubleshooting guide

### Step 8: Go Live! 🎉

- [ ] School admin confirms ready
- [ ] Test student registration works
- [ ] Test payment processing works
- [ ] Email verification working
- [ ] Moodle sync working (if applicable)
- [ ] Support contact shared

---

## 🔧 Post-Onboarding Support

### Daily (First Week)
- Monitor for errors in logs
- Check student registrations
- Verify payment processing
- Respond to school admin questions

### Weekly (First Month)
- Review student enrollment numbers
- Check payment success rates
- Gather feedback from school admin
- Make adjustments as needed

### Monthly
- Review school performance
- Check wallet balance
- Process withdrawal requests
- Plan improvements

---

## 📊 Success Metrics

Track for each new school:
- [ ] Time to first student registered
- [ ] Student enrollment rate
- [ ] Payment success rate
- [ ] Email verification rate
- [ ] Moodle sync success rate
- [ ] Admin satisfaction score

**Target:**
- ✓ First student within 24 hours
- ✓ 90%+ payment success rate
- ✓ 95%+ email verification rate
- ✓ 100% Moodle sync rate (if used)

---

## 🆘 Troubleshooting Common Issues

### Issue: Admin cannot login
**Solution:**
```sql
-- Check admin exists
SELECT * FROM admins WHERE username = 'stmary_admin';

-- Reset password
UPDATE admins SET password_hash = '<?php echo password_hash("NewPassword123", PASSWORD_DEFAULT); ?>' 
WHERE username = 'stmary_admin';
```

### Issue: Students not showing in dashboard
**Solution:**
```sql
-- Check academy_reference
SELECT id, first_name, last_name, academy_reference FROM students 
WHERE academy_reference = 'STMARY';

-- Fix if missing
UPDATE students SET academy_reference = 'STMARY' WHERE id IN (...);
```

### Issue: Payments not tracked
**Solution:**
```sql
-- Check payment records
SELECT * FROM payments WHERE academy_reference = 'STMARY';

-- Verify wallet exists
SELECT * FROM admin_wallet WHERE admin_id = (
    SELECT id FROM admins WHERE academy_reference = 'STMARY'
);
```

### Issue: School settings not saving
**Solution:**
```sql
-- Check tenant_settings
SELECT * FROM tenant_settings WHERE academy_reference = 'STMARY';

-- Manually add if needed
INSERT INTO tenant_settings (academy_reference, setting_key, setting_value)
VALUES ('STMARY', 'school_name', 'St. Mary\'s High School');
```

---

## 📝 Onboarding Template Email

```
Subject: Welcome to Skolo-Kine Multi-Tenant Platform! 🎉

Dear [School Admin Name],

Welcome to Skolo-Kine! We're excited to have [School Name] on board.

🔑 YOUR LOGIN CREDENTIALS
═══════════════════════════
URL: https://kine.melanegroup.com/admin/login.php
Username: [reference_code]_admin
Password: [provided separately for security]

📚 QUICK START GUIDE
═══════════════════════════
1. Login and change your password
2. Update school settings (Settings → School Settings)
3. Add your first student (Dashboard → Create Student)
4. Test the payment flow
5. Configure Moodle (if applicable)

💰 PRICING REMINDER
═══════════════════════════
- Students pay: E0.30 per subject
- Platform fee: E0.50 per student (deducted from your earnings)
- You can withdraw earnings anytime

📞 SUPPORT
═══════════════════════════
Email: info@melanegroup.com
Phone: +268 7687 3207
WhatsApp: [link]

📖 RESOURCES
═══════════════════════════
- Admin Guide: [link]
- Video Tutorials: [link]
- FAQs: [link]

Looking forward to working with you!

Best regards,
The Skolo-Kine Team
```

---

## ✅ Onboarding Completion Checklist

For each new school, mark complete:

- [ ] School created in database
- [ ] Admin account created and tested
- [ ] School settings configured
- [ ] Test student created successfully
- [ ] Test payment processed successfully
- [ ] Email verification working
- [ ] Moodle sync working (if applicable)
- [ ] Admin trained on system
- [ ] Documentation provided
- [ ] Support contact shared
- [ ] School is live!

**Average Onboarding Time: 1-2 hours**  
**Success Rate Target: 100%**

🎊 **Welcome to the Skolo-Kine Family!** 🎊

