# Moodle Setup Guide for Skolo-Kine Integration

This guide will help you configure Moodle to work with the Skolo-Kine sync bot and prevent password changes on first login.

## 1. Enable Web Services

### Step 1: Enable Web Services
1. Log in to your Moodle admin panel
2. Go to **Site administration** → **Advanced features**
3. Check **Enable web services**
4. Click **Save changes**

### Step 2: Enable REST Protocol
1. Go to **Site administration** → **Plugins** → **Web services** → **Manage protocols**
2. Enable **REST protocol**
3. Click **Save changes**

## 2. Create Web Service User

### Step 1: Create a Service User
1. Go to **Site administration** → **Users** → **Add a new user**
2. Create a user with these details:
   - **Username**: `skolo_sync_bot`
   - **First name**: `Skolo`
   - **Last name**: `Sync Bot`
   - **Email**: `bot@yourdomain.com`
   - **Password**: Generate a strong password
3. Click **Create user**

### Step 2: Assign System Role
1. Go to **Site administration** → **Users** → **Permissions** → **Assign system roles**
2. Click **Manager** role
3. Add the `skolo_sync_bot` user to the Manager role

## 3. Create Web Service

### Step 1: Create External Service
1. Go to **Site administration** → **Plugins** → **Web services** → **External services**
2. Click **Add**
3. Fill in the details:
   - **Name**: `Skolo-Kine Sync Service`
   - **Short name**: `skolo_sync`
   - **Enabled**: Yes
   - **Required capability**: Leave empty
4. Click **Save changes**

### Step 2: Add Functions to Service
1. Click on the service you just created
2. Click **Functions** tab
3. Add these functions:
   - `core_user_create_users`
   - `core_user_get_users`
   - `core_user_update_users`
   - `core_user_delete_users`
4. Click **Save changes**

### Step 3: Authorize Users
1. Click **Authorised users** tab
2. Add the `skolo_sync_bot` user
3. Click **Save changes**

## 4. Generate Web Service Token

### Step 1: Create Token
1. Go to **Site administration** → **Plugins** → **Web services** → **Manage tokens**
2. Click **Create token**
3. Fill in the details:
   - **User**: `skolo_sync_bot`
   - **Service**: `Skolo-Kine Sync Service`
   - **IP restriction**: Leave empty (or add your server IP for security)
4. Click **Save changes**
5. **Copy the generated token** - you'll need this for the bot configuration

## 5. Configure Password Policy

### Step 1: Disable Force Password Change
1. Go to **Site administration** → **Plugins** → **Authentication** → **Manage authentication**
2. Click **Settings** next to **Manual accounts**
3. Set **Force password change on first login** to **No**
4. Click **Save changes**

### Step 2: Configure User Defaults
1. Go to **Site administration** → **Users** → **Accounts** → **User default preferences**
2. Set **Force password change** to **No**
3. Click **Save changes**

### Step 3: Configure Site Policies
1. Go to **Site administration** → **Security** → **Site policies**
2. Set **Force users to change password** to **No**
3. Click **Save changes**

## 6. Configure User Creation Settings

### Step 1: Set Default Authentication Method
1. Go to **Site administration** → **Plugins** → **Authentication** → **Manage authentication**
2. Set **Manual accounts** as the default authentication method
3. Click **Save changes**

### Step 2: Configure User Creation
1. Go to **Site administration** → **Users** → **Accounts** → **User default preferences**
2. Set these preferences:
   - **Email display**: Hidden
   - **Email format**: Plain text
   - **Timezone**: Your local timezone
3. Click **Save changes**

## 7. Test the Integration

### Step 1: Test Web Service
You can test the web service using this URL format:
```
https://yourmoodle.com/webservice/rest/server.php?wstoken=YOUR_TOKEN&wsfunction=core_user_get_users&moodlewsrestformat=json
```

### Step 2: Test User Creation
Use the bot script to test user creation:
```bash
php /path/to/moodle_sync_bot.php
```

## 8. Security Considerations

### Step 1: IP Restriction (Recommended)
1. Go to **Site administration** → **Plugins** → **Web services** → **Manage tokens**
2. Edit your token
3. Add your server's IP address to **IP restriction**
4. Click **Save changes**

### Step 2: Regular Token Rotation
- Change the web service token regularly
- Update the bot configuration when you change the token

### Step 3: Monitor Logs
- Check Moodle logs regularly: **Site administration** → **Reports** → **Logs**
- Monitor the bot's log files

## 9. Troubleshooting

### Common Issues:

1. **"Invalid token" error**
   - Check if the token is correct
   - Verify the user has access to the service

2. **"Function not found" error**
   - Make sure the function is added to the external service
   - Check if the service is enabled

3. **"User already exists" error**
   - This is normal for existing users
   - The bot will handle this gracefully

4. **"Permission denied" error**
   - Check if the user has the Manager role
   - Verify the service is properly configured

### Log Locations:
- Moodle logs: **Site administration** → **Reports** → **Logs**
- Bot logs: `/path/to/bot/logs/sync.log`
- Cron logs: `/path/to/bot/logs/cron.log`

## 10. Bot Configuration

Update these values in `moodle_sync_bot.php`:

```php
$CONFIG = [
    'skolo_api_url' => 'https://yourdomain.com/api/export_csv.php',
    'skolo_api_key' => 'your_secure_api_key',
    'moodle_url' => 'https://yourmoodle.com',
    'moodle_token' => 'your_moodle_webservice_token',
    // ... other settings
];
```

## 11. Cron Job Setup

### For Linux/Unix servers:
```bash
# Run every minute
*/1 * * * * /usr/bin/php /path/to/moodle_sync_bot.php >> /path/to/bot/logs/cron.log 2>&1
```

### For Windows servers:
Use Task Scheduler to run the bot every minute.

## 12. Monitoring

### Check Bot Status:
```bash
# View recent logs
tail -f /path/to/bot/logs/sync.log

# Check if bot is running
ps aux | grep moodle_sync_bot

# Test bot manually
php /path/to/moodle_sync_bot.php
```

This setup ensures that:
- Users are automatically created in Moodle
- Passwords are not forced to change on first login
- The sync happens every 60 seconds
- All operations are logged for monitoring
