# 🚀 cPanel Deployment Guide - Moodle Sync Bot

## 📋 **Pre-Deployment Checklist**

Before starting, ensure you have:
- ✅ cPanel access credentials
- ✅ FTP/SFTP client (FileZilla, WinSCP, or cPanel File Manager)
- ✅ Updated bot files ready for upload
- ✅ Moodle web service token ready

---

## 🎯 **Step 1: Access Your cPanel**

1. **Login to cPanel**
   - Go to your hosting provider's cPanel login page
   - Enter your username and password
   - Click "Login"

2. **Navigate to File Manager**
   - Look for "File Manager" in the cPanel dashboard
   - Click to open it

---

## 🎯 **Step 2: Navigate to Your Website Directory**

1. **Find your website folder**
   - In File Manager, navigate to `public_html`
   - Look for your website folder (likely `kine.melanegroup.com` or similar)
   - Enter the folder

2. **Locate the Skolo-Kine folder**
   - Find the `Skolo-Kine` folder
   - This is where your website files are located

---

## 🎯 **Step 3: Upload Updated Files**

### **3.1 Upload API Export File**
1. Navigate to `Skolo-Kine/api/`
2. **Upload** `export_csv.php` (replace existing file)
3. **Verify** the file has the correct API key: `skolo_prod_2024_8f9a2b3c4d5e6f7a8b9c0d1e2f3a4b5c`

### **3.2 Upload Bot Files**
1. Navigate to `Skolo-Kine/bot/`
2. **Upload** `moodle_sync_bot.php` (replace existing file)
3. **Create** the following folders if they don't exist:
   - `temp/`
   - `logs/`

### **3.3 Upload Functions File**
1. Navigate to `Skolo-Kine/includes/`
2. **Upload** `functions.php` (replace existing file)
3. This contains the cleanup functions for unverified users

### **3.4 Upload Cleanup Script**
1. Navigate to `Skolo-Kine/`
2. **Upload** `cleanup_unverified_users.php`
3. This script will run automatically to clean up unverified users

### **3.5 Fix Subject Configuration (IMPORTANT)**
1. Navigate to `Skolo-Kine/bot/`
2. **Upload** `fix_subject_configuration.php`
3. **Run this script once** to fix Grade 7 subject configuration:
   - Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/fix_subject_configuration.php`
   - This will ensure only correct Grade 7 subjects are available for registration
4. **Delete** `fix_subject_configuration.php` after running for security

---

## 🎯 **Step 4: Set File Permissions**

### **4.1 Set Bot Permissions**
1. Right-click on `bot/moodle_sync_bot.php`
2. Select "Permissions" or "Change Permissions"
3. Set to `755` (rwxr-xr-x)
4. Click "Change Permissions"

### **4.2 Set Cleanup Script Permissions**
1. Right-click on `cleanup_unverified_users.php`
2. Select "Permissions" or "Change Permissions"
3. Set to `755` (rwxr-xr-x)
4. Click "Change Permissions"

### **4.3 Set Folder Permissions**
1. Right-click on `bot/temp/` folder
2. Set permissions to `777` (rwxrwxrwx)
3. Right-click on `bot/logs/` folder
4. Set permissions to `777` (rwxrwxrwx)

---

## 🎯 **Step 5: Test the Bot**

### **5.1 Test API Endpoint**
1. Open a new browser tab
2. Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`
3. Verify you see:
   - ✅ HTTP Status: 200
   - ✅ Column Count: 7
   - ✅ Data Rows: 46 (or current number of verified students)
   - ✅ Has Subject Data: Yes

### **5.2 Test Bot Web Interface**
1. Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
2. Click "Run Bot Now"
3. Watch the logs for:
   - ✅ CSV downloaded successfully
   - ✅ Users parsed
   - ✅ Enrollments completed
   - ✅ No errors

---

## 🎯 **Step 6: Set Up Cron Jobs**

### **6.1 Access Cron Jobs in cPanel**
1. In cPanel, find "Cron Jobs"
2. Click to open it

### **6.2 Set Up Bot Cron Job**
1. **Frequency**: Every 5 minutes
2. **Command**: 
   ```bash
   /usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/bot/moodle_sync_bot.php
   ```
   (Replace `yourusername` with your actual cPanel username)

3. **Add the cron job**

### **6.3 Set Up Cleanup Cron Job**
1. **Frequency**: Every hour
2. **Command**:
   ```bash
   /usr/bin/php /home/yourusername/public_html/kine.melanegroup.com/Skolo-Kine/cleanup_unverified_users.php
   ```

3. **Add the cron job**

---

## 🎯 **Step 7: Verify Everything is Working**

### **7.1 Check Bot Logs**
1. Go to: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
2. Look for recent log entries
3. Verify no errors

### **7.2 Check Moodle Users**
1. Login to your Moodle admin panel
2. Go to "Site administration" → "Users" → "Accounts" → "Browse list of users"
3. Verify new users are being created
4. Check that users are enrolled in courses

### **7.3 Test Email Verification**
1. Register a new test user
2. Verify the email
3. Wait 5 minutes
4. Check if the user appears in Moodle

---

## 🎯 **Step 8: Monitor and Maintain**

### **8.1 Regular Monitoring**
- Check bot logs weekly
- Monitor Moodle user creation
- Verify enrollments are working

### **8.2 Troubleshooting**
If issues occur:
1. Check file permissions
2. Verify cron jobs are running
3. Check bot logs for errors
4. Ensure Moodle web service is working

---

## 🔧 **Troubleshooting Common Issues**

### **Issue 1: Bot Not Running**
**Solution:**
- Check file permissions (should be 755)
- Verify cron job syntax
- Check if lock file exists and delete it

### **Issue 2: API Key Errors**
**Solution:**
- Verify API key in `api/export_csv.php`
- Ensure it matches the bot configuration

### **Issue 3: Moodle Connection Errors**
**Solution:**
- Check Moodle web service token
- Verify Moodle URL is correct
- Ensure required functions are enabled in Moodle

### **Issue 4: Permission Denied**
**Solution:**
- Set folder permissions to 777
- Set file permissions to 755
- Check if files are owned by correct user

---

## 📞 **Support Information**

### **File Locations:**
- Bot: `/public_html/kine.melanegroup.com/Skolo-Kine/bot/moodle_sync_bot.php`
- API: `/public_html/kine.melanegroup.com/Skolo-Kine/api/export_csv.php`
- Cleanup: `/public_html/kine.melanegroup.com/Skolo-Kine/cleanup_unverified_users.php`

### **Important URLs:**
- Bot Interface: `https://kine.melanegroup.com/Skolo-Kine/bot/web_interface.php`
- API Test: `https://kine.melanegroup.com/Skolo-Kine/bot/test_api_browser.php`
- Admin Dashboard: `https://kine.melanegroup.com/Skolo-Kine/admin/dashboard.php`

### **Log Files:**
- Bot Logs: `/public_html/kine.melanegroup.com/Skolo-Kine/bot/logs/`
- Error Logs: Check cPanel Error Logs section

---

## ✅ **Deployment Complete!**

Once all steps are completed:
- ✅ Bot will run every 5 minutes
- ✅ Cleanup will run every hour
- ✅ Only email-verified students will be enrolled
- ✅ All subjects will be properly mapped to courses
- ✅ System will be fully automated

**Your Moodle Sync Bot is now live and operational!** 🎉
