-- =====================================================
-- PRIMARY SCHOOL SUBJECTS (GRADE 4 - GRADE 7)
-- =====================================================
-- Based on Eswatini Curriculum for Primary Education
-- =====================================================

-- =====================================================
-- GRADE 4 SUBJECTS
-- =====================================================

INSERT IGNORE INTO subjects (name, code) VALUES
-- Core Subjects
('English Language (Grade 4)', 'G4-ENG-001'),
('SiSwati Language (Grade 4)', 'G4-SIS-002'),
('Mathematics (Grade 4)', 'G4-MAT-003'),

-- General Subjects
('Science (Grade 4)', 'G4-SCI-004'),
('Social Studies (Grade 4)', 'G4-SOC-005'),
('Religious Education (Grade 4)', 'G4-REL-006'),

-- Practical Subjects
('Home Economics (Grade 4)', 'G4-HE-007'),
('Agriculture (Grade 4)', 'G4-AGR-008'),

-- Arts & Physical Education
('Art (Grade 4)', 'G4-ART-009'),
('Music (Grade 4)', 'G4-MUS-010'),
('Physical Education (Grade 4)', 'G4-PE-011');

-- =====================================================
-- GRADE 5 SUBJECTS
-- =====================================================

INSERT IGNORE INTO subjects (name, code) VALUES
-- Core Subjects
('English Language (Grade 5)', 'G5-ENG-001'),
('SiSwati Language (Grade 5)', 'G5-SIS-002'),
('Mathematics (Grade 5)', 'G5-MAT-003'),

-- General Subjects
('Science (Grade 5)', 'G5-SCI-004'),
('Social Studies (Grade 5)', 'G5-SOC-005'),
('Religious Education (Grade 5)', 'G5-REL-006'),

-- Practical Subjects
('Home Economics (Grade 5)', 'G5-HE-007'),
('Basic Consumer Science (Grade 5)', 'G5-BCS-008'),
('Agriculture (Grade 5)', 'G5-AGR-009'),

-- Arts & Technology
('Creative Arts (Grade 5)', 'G5-CA-010'),
('Physical Education (Grade 5)', 'G5-PE-011'),
('ICT (Grade 5)', 'G5-ICT-012');

-- =====================================================
-- GRADE 6 SUBJECTS
-- =====================================================

INSERT IGNORE INTO subjects (name, code) VALUES
-- Core Subjects
('English Language & Literature (Grade 6)', 'G6-ENG-001'),
('SiSwati Language & Literature (Grade 6)', 'G6-SIS-002'),
('Mathematics (Grade 6)', 'G6-MAT-003'),

-- Science & Social Studies
('Science (Grade 6)', 'G6-SCI-004'),
('Social Studies (Grade 6)', 'G6-SOC-005'),
('Geography (Grade 6)', 'G6-GEO-006'),
('History (Grade 6)', 'G6-HIS-007'),
('Civics (Grade 6)', 'G6-CIV-008'),
('Religious Education (Grade 6)', 'G6-REL-009'),

-- Practical Subjects
('Home Economics (Grade 6)', 'G6-HE-010'),
('Agriculture (Grade 6)', 'G6-AGR-011'),

-- Arts & Technology
('Creative & Performing Arts (Grade 6)', 'G6-CA-012'),
('ICT / Digital Literacy (Grade 6)', 'G6-ICT-013');

-- =====================================================
-- GRADE 7 SUBJECTS
-- =====================================================

INSERT IGNORE INTO subjects (name, code) VALUES
-- Core Subjects
('English Language (Grade 7)', 'G7-ENG-001'),
('SiSwati Language (Grade 7)', 'G7-SIS-002'),
('Mathematics (Grade 7)', 'G7-MAT-003'),

-- Integrated Science
('Integrated Science (Grade 7)', 'G7-SCI-004'),

-- Social Studies
('Social Studies (Grade 7)', 'G7-SOC-005'),
('Religious Education (Grade 7)', 'G7-REL-006'),

-- Practical Subjects
('Home Economics (Grade 7)', 'G7-HE-007'),
('Agriculture (Grade 7)', 'G7-AGR-008'),

-- Creative Arts
('Creative Arts (Grade 7)', 'G7-CA-009'),
('Music (Grade 7)', 'G7-MUS-010'),
('Drama (Grade 7)', 'G7-DRA-011'),

-- Technology
('ICT / Computer Studies (Grade 7)', 'G7-ICT-012');

-- =====================================================
-- LINK SUBJECTS TO GRADES
-- =====================================================
-- This assumes grades exist with specific names
-- Adjust grade names if different in your system
-- =====================================================

-- Get Grade IDs (assuming grades table has these names)
SET @grade4_id = (SELECT id FROM grades WHERE name = 'Grade 4' LIMIT 1);
SET @grade5_id = (SELECT id FROM grades WHERE name = 'Grade 5' LIMIT 1);
SET @grade6_id = (SELECT id FROM grades WHERE name = 'Grade 6' LIMIT 1);
SET @grade7_id = (SELECT id FROM grades WHERE name = 'Grade 7' LIMIT 1);

-- Link Grade 4 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade4_id, id FROM subjects WHERE code LIKE 'G4-%';

-- Link Grade 5 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade5_id, id FROM subjects WHERE code LIKE 'G5-%';

-- Link Grade 6 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade6_id, id FROM subjects WHERE code LIKE 'G6-%';

-- Link Grade 7 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade7_id, id FROM subjects WHERE code LIKE 'G7-%';

-- =====================================================
-- VERIFICATION QUERIES
-- =====================================================

-- Count subjects per grade
SELECT 
    g.name as grade_name,
    COUNT(gs.subject_id) as subject_count
FROM grades g
LEFT JOIN grade_subject gs ON g.id = gs.grade_id
WHERE g.name IN ('Grade 4', 'Grade 5', 'Grade 6', 'Grade 7')
GROUP BY g.id, g.name
ORDER BY g.name;

-- List all Grade 4 subjects
SELECT s.name, s.code
FROM subjects s
WHERE s.code LIKE 'G4-%'
ORDER BY s.code;

-- List all Grade 5 subjects
SELECT s.name, s.code
FROM subjects s
WHERE s.code LIKE 'G5-%'
ORDER BY s.code;

-- List all Grade 6 subjects
SELECT s.name, s.code
FROM subjects s
WHERE s.code LIKE 'G6-%'
ORDER BY s.code;

-- List all Grade 7 subjects
SELECT s.name, s.code
FROM subjects s
WHERE s.code LIKE 'G7-%'
ORDER BY s.code;

-- =====================================================
-- SUMMARY
-- =====================================================
-- Grade 4: 11 subjects
-- Grade 5: 12 subjects
-- Grade 6: 13 subjects
-- Grade 7: 12 subjects
-- Total: 48 primary school subjects
-- =====================================================

