-- MySQL schema for Skolo-Kine

-- Optional: create and use database (uncomment if needed)
-- CREATE DATABASE IF NOT EXISTS `skolo_kine` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
-- USE `skolo_kine`;

CREATE TABLE IF NOT EXISTS admins (
	id INT AUTO_INCREMENT PRIMARY KEY,
	username VARCHAR(64) NOT NULL UNIQUE,
	password_hash VARCHAR(255) NOT NULL,
	created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS grades (
	id INT AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(32) NOT NULL UNIQUE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS subjects (
	id INT AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(128) NOT NULL,
	code VARCHAR(32) NOT NULL,
	UNIQUE KEY unique_code (code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS grade_subject (
	grade_id INT NOT NULL,
	subject_id INT NOT NULL,
	PRIMARY KEY (grade_id, subject_id),
	KEY idx_grade_subject_subject_id (subject_id),
	CONSTRAINT fk_grade_subject_grade FOREIGN KEY (grade_id) REFERENCES grades(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fk_grade_subject_subject FOREIGN KEY (subject_id) REFERENCES subjects(id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS students (
	id INT AUTO_INCREMENT PRIMARY KEY,
	first_name VARCHAR(100) NOT NULL,
	last_name VARCHAR(100) NOT NULL,
	email VARCHAR(191) NOT NULL UNIQUE,
	grade_id INT NOT NULL,
	username VARCHAR(64) NOT NULL UNIQUE,
	password_hash VARCHAR(255) NOT NULL,
	email_verified BOOLEAN DEFAULT FALSE,
	email_verification_token VARCHAR(255) NULL,
	email_verification_expires TIMESTAMP NULL,
	created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	KEY idx_students_grade_id (grade_id),
	KEY idx_students_email_verified (email_verified),
	KEY idx_students_verification_token (email_verification_token),
	CONSTRAINT fk_students_grade FOREIGN KEY (grade_id) REFERENCES grades(id) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Student subject selections (many-to-many)
CREATE TABLE IF NOT EXISTS student_subject (
	student_id INT NOT NULL,
	subject_id INT NOT NULL,
	PRIMARY KEY (student_id, subject_id),
	KEY idx_student_subject_subject_id (subject_id),
	CONSTRAINT fk_student_subject_student FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT fk_student_subject_subject FOREIGN KEY (subject_id) REFERENCES subjects(id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
