<?php
/**
 * Quick Migration Script - Add Payment Method Column
 * This adds the missing payment_method column to fix the dashboard error
 */

require_once __DIR__ . '/../config.php';

echo "Adding payment_method column to payments table...\n\n";

try {
    $pdo = getDB();
    
    // Add payment_method column
    try {
        $pdo->exec("ALTER TABLE `payments` ADD COLUMN `payment_method` VARCHAR(20) DEFAULT 'MOMO' AFTER `status`");
        echo "✓ Added column: payment_method\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "⚠ Column already exists: payment_method\n";
        } else {
            throw $e;
        }
    }
    
    // Update existing records
    try {
        $stmt = $pdo->exec("UPDATE `payments` SET `payment_method` = 'MOMO' WHERE `payment_method` IS NULL");
        echo "✓ Updated existing payment records\n";
    } catch (PDOException $e) {
        echo "⚠ Skip update: " . $e->getMessage() . "\n";
    }
    
    // Add index
    try {
        $pdo->exec("ALTER TABLE `payments` ADD INDEX `idx_payments_payment_method` (`payment_method`)");
        echo "✓ Added index: idx_payments_payment_method\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            echo "⚠ Index already exists: idx_payments_payment_method\n";
        } else {
            throw $e;
        }
    }
    
    echo "\n✅ Migration completed successfully!\n";
    echo "   The dashboard payment breakdown should now work.\n\n";
    
} catch (Exception $e) {
    echo "\n✗ Fatal error: " . $e->getMessage() . "\n";
    exit(1);
}

