-- =====================================================
-- DROP TENANT FILES TABLES - CORRECT ORDER
-- =====================================================
-- Purpose: Safely drop all tenant_files related objects
-- Run this before importing the migration if tables exist
-- =====================================================

SELECT '=== DROPPING TENANT FILES TABLES ===' AS status;

-- =====================================================
-- STEP 1: DROP VIEWS
-- =====================================================

DROP VIEW IF EXISTS v_active_tenant_files;
DROP VIEW IF EXISTS v_tenant_file_stats;

SELECT 'Views dropped' AS status;

-- =====================================================
-- STEP 2: DROP TRIGGERS
-- =====================================================

DROP TRIGGER IF EXISTS before_tenant_file_access_insert;

SELECT 'Triggers dropped' AS status;

-- =====================================================
-- STEP 3: DROP CHILD TABLES (WITH FOREIGN KEYS)
-- =====================================================

-- These tables have foreign keys pointing to tenant_files
-- Must be dropped BEFORE the parent table

DROP TABLE IF EXISTS tenant_file_versions;
DROP TABLE IF EXISTS tenant_file_access_log;

SELECT 'Child tables dropped' AS status;

-- =====================================================
-- STEP 4: DROP PARENT TABLE
-- =====================================================

DROP TABLE IF EXISTS tenant_files;

SELECT 'Parent table dropped' AS status;

-- =====================================================
-- STEP 5: DROP BACKUP TABLES (OPTIONAL)
-- =====================================================

-- Uncomment if you want to drop backup tables too
-- DROP TABLE IF EXISTS tenant_files_backup_20250130;
-- DROP TABLE IF EXISTS tenant_files_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_access_log_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_versions_rollback_backup;

-- =====================================================
-- VERIFICATION
-- =====================================================

-- Check what's left
SELECT 
    TABLE_NAME
FROM information_schema.TABLES
WHERE TABLE_SCHEMA = DATABASE()
AND TABLE_NAME LIKE '%tenant_file%'
ORDER BY TABLE_NAME;

-- If result is empty, all tables are dropped

-- =====================================================
-- COMPLETE
-- =====================================================

SELECT '=== DROP COMPLETE ===' AS status;
SELECT 'All tenant_files tables have been dropped' AS message;
SELECT 'You can now import create_tenant_files_table.sql' AS next_step;

-- =====================================================
-- END
-- =====================================================

