-- Migration script to add email verification fields to existing students table
-- Run this script if you have an existing database without email verification fields

-- Add email verification columns to students table
ALTER TABLE students 
ADD COLUMN email_verified BOOLEAN DEFAULT FALSE AFTER password_hash,
ADD COLUMN email_verification_token VARCHAR(255) NULL AFTER email_verified,
ADD COLUMN email_verification_expires TIMESTAMP NULL AFTER email_verification_token;

-- Add indexes for better performance
ALTER TABLE students 
ADD KEY idx_students_email_verified (email_verified),
ADD KEY idx_students_verification_token (email_verification_token);

-- Update existing students to have verified emails (since they were created before verification was required)
-- Uncomment the line below if you want to mark all existing students as verified
-- UPDATE students SET email_verified = TRUE WHERE email_verified = FALSE;
