-- Create student_subject table if it doesn't exist
-- This table links students to their selected subjects (many-to-many relationship)

CREATE TABLE IF NOT EXISTS student_subject (
    student_id INT NOT NULL,
    subject_id INT NOT NULL,
    PRIMARY KEY (student_id, subject_id),
    KEY idx_student_subject_subject_id (subject_id),
    CONSTRAINT fk_student_subject_student FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT fk_student_subject_subject FOREIGN KEY (subject_id) REFERENCES subjects(id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Verify the table was created
SHOW TABLES LIKE 'student_subject';

-- Show table structure
DESCRIBE student_subject;
