-- Add payment_method column to payments table
-- This tracks whether payment was made via MTN MoMo or Card

ALTER TABLE `payments` ADD COLUMN `payment_method` VARCHAR(20) DEFAULT 'MOMO' AFTER `status`;

-- Update existing records to have 'MOMO' as default
UPDATE `payments` SET `payment_method` = 'MOMO' WHERE `payment_method` IS NULL;

-- Add index for better performance
ALTER TABLE `payments` ADD INDEX `idx_payments_payment_method` (`payment_method`);

