-- =====================================================
-- FIX MISSING GRADE-SUBJECT LINKS
-- =====================================================
-- This fixes the missing subject links for Grades 4, 5, and 6

-- First, let's check what subjects we have for these grades
-- SELECT code FROM subjects WHERE code LIKE 'G4-%' OR code LIKE 'G5-%' OR code LIKE 'G6-%';

-- =====================================================
-- GRADE 4 - Manual Link Creation
-- =====================================================

-- Get Grade 4 ID
SET @grade4_id = (SELECT id FROM grades WHERE name = 'Grade 4' LIMIT 1);

-- Link all G4 subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade4_id, id FROM subjects WHERE code IN (
    'G4-ENG-001', 'G4-SIS-002', 'G4-MAT-003', 'G4-SCI-004', 
    'G4-SOC-005', 'G4-REL-006', 'G4-CPA-007', 'G4-ART-008', 
    'G4-MUS-009', 'G4-CRA-010', 'G4-PED-011', 'G4-ICT-012'
);

-- =====================================================
-- GRADE 5 - Manual Link Creation
-- =====================================================

-- Get Grade 5 ID
SET @grade5_id = (SELECT id FROM grades WHERE name = 'Grade 5' LIMIT 1);

-- Link all G5 subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade5_id, id FROM subjects WHERE code IN (
    'G5-ENG-001', 'G5-SIS-002', 'G5-MAT-003', 'G5-SCI-004', 
    'G5-SOC-005', 'G5-REL-006', 'G5-HE-007', 'G5-HE-008', 
    'G5-BCS-009', 'G5-CA-010', 'G5-CA-011', 'G5-PED-012', 'G5-ICT-013'
);

-- =====================================================
-- GRADE 6 - Manual Link Creation
-- =====================================================

-- Get Grade 6 ID
SET @grade6_id = (SELECT id FROM grades WHERE name = 'Grade 6' LIMIT 1);

-- Link all G6 subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT @grade6_id, id FROM subjects WHERE code IN (
    'G6-ENG-001', 'G6-SIS-002', 'G6-MAT-003', 'G6-SCI-004', 
    'G6-SOC-005', 'G6-GEO-006', 'G6-HIS-007', 'G6-CIV-008', 
    'G6-REL-009', 'G6-HE-010', 'G6-HE-011', 'G6-AGR-012', 
    'G6-CA-013', 'G6-ICT-014'
);

-- =====================================================
-- VERIFICATION QUERY
-- =====================================================

-- Check subjects per grade
SELECT 
    g.name AS grade_name, 
    COUNT(gs.subject_id) AS subject_count
FROM grades g
LEFT JOIN grade_subject gs ON g.id = gs.grade_id
GROUP BY g.id, g.name
ORDER BY g.name;

-- Expected output:
-- Grade 4: 12 subjects (or close to it)
-- Grade 5: 13 subjects (or close to it)
-- Grade 6: 14 subjects (or close to it)
-- Grade 7: 11 subjects
-- Form 1: 17 subjects
-- Form 2: 6 subjects
-- Form 3: 13 subjects
-- Form 4: 11 subjects
-- Form 5: 0 subjects (might need fixing too)

-- =====================================================
-- LIST SUBJECTS FOR EACH GRADE
-- =====================================================

-- Grade 4 subjects
SELECT s.name, s.code
FROM subjects s
JOIN grade_subject gs ON s.id = gs.subject_id
JOIN grades g ON gs.grade_id = g.id
WHERE g.name = 'Grade 4'
ORDER BY s.name;

-- Grade 5 subjects
SELECT s.name, s.code
FROM subjects s
JOIN grade_subject gs ON s.id = gs.subject_id
JOIN grades g ON gs.grade_id = g.id
WHERE g.name = 'Grade 5'
ORDER BY s.name;

-- Grade 6 subjects
SELECT s.name, s.code
FROM subjects s
JOIN grade_subject gs ON s.id = gs.subject_id
JOIN grades g ON gs.grade_id = g.id
WHERE g.name = 'Grade 6'
ORDER BY s.name;

-- =====================================================
-- COMPLETE!
-- =====================================================

