-- ===================================================================
-- ADD PRICING SETTINGS TO EXISTING SCHOOLS
-- Run this to add subject_fee, yearly_discount, and currency_symbol
-- to schools that don't have these settings yet
-- ===================================================================

-- Add subject_fee (E350/month) to all schools that don't have it
INSERT INTO tenant_settings (academy_reference, setting_key, setting_value)
SELECT reference_code, 'subject_fee', '350'
FROM academy_references
WHERE is_active = 1
AND reference_code NOT IN (
    SELECT academy_reference 
    FROM tenant_settings 
    WHERE setting_key = 'subject_fee'
);

-- Add yearly_discount (10%) to all schools that don't have it
INSERT INTO tenant_settings (academy_reference, setting_key, setting_value)
SELECT reference_code, 'yearly_discount', '10'
FROM academy_references
WHERE is_active = 1
AND reference_code NOT IN (
    SELECT academy_reference 
    FROM tenant_settings 
    WHERE setting_key = 'yearly_discount'
);

-- Add currency_symbol (E) to all schools that don't have it
INSERT INTO tenant_settings (academy_reference, setting_key, setting_value)
SELECT reference_code, 'currency_symbol', 'E'
FROM academy_references
WHERE is_active = 1
AND reference_code NOT IN (
    SELECT academy_reference 
    FROM tenant_settings 
    WHERE setting_key = 'currency_symbol'
);

-- ===================================================================
-- VERIFY SETTINGS WERE ADDED
-- ===================================================================

-- Show pricing for all schools
SELECT 
    ar.reference_code,
    ar.academy_name,
    MAX(CASE WHEN ts.setting_key = 'subject_fee' THEN ts.setting_value ELSE 'NOT SET' END) as subject_fee,
    MAX(CASE WHEN ts.setting_key = 'yearly_discount' THEN ts.setting_value ELSE 'NOT SET' END) as yearly_discount,
    MAX(CASE WHEN ts.setting_key = 'currency_symbol' THEN ts.setting_value ELSE 'NOT SET' END) as currency_symbol
FROM academy_references ar
LEFT JOIN tenant_settings ts ON ar.reference_code = ts.academy_reference
    AND ts.setting_key IN ('subject_fee', 'yearly_discount', 'currency_symbol')
WHERE ar.is_active = 1
GROUP BY ar.reference_code, ar.academy_name
ORDER BY ar.academy_name;

-- Expected output: All schools should show:
-- subject_fee: 350
-- yearly_discount: 10
-- currency_symbol: E

SELECT '✓ Pricing settings added to all schools!' as status;

