# Create Storage Dashboard Upload Package
# Run: .\create_upload_package.ps1

Write-Host ""
Write-Host "========================================"
Write-Host "  Storage Dashboard Upload Package"
Write-Host "========================================"
Write-Host ""

$sourcePath = $PSScriptRoot
$outputZip = Join-Path $sourcePath "storage_dashboards_upload.zip"

# Remove old zip
if (Test-Path $outputZip) {
    Remove-Item $outputZip -Force
    Write-Host "[1/5] Removed old ZIP file"
}

# Create staging directory
$stagingDir = Join-Path $sourcePath "temp_upload_staging"
if (Test-Path $stagingDir) {
    Remove-Item $stagingDir -Recurse -Force
}
New-Item -ItemType Directory -Path $stagingDir | Out-Null
Write-Host "[2/5] Created staging directory"

# Copy files
Write-Host "[3/5] Copying files..."

# Create directories
$dirs = @(
    "super_admin\storage",
    "admin\storage",
    "admin\partials",
    "api\storage"
)

foreach ($dir in $dirs) {
    $targetDir = Join-Path $stagingDir $dir
    New-Item -ItemType Directory -Path $targetDir -Force | Out-Null
}

# Copy files
$filesToCopy = @{
    "super_admin\storage\overview.php" = "super_admin\storage\overview.php"
    "admin\storage\usage.php" = "admin\storage\usage.php"
    "api\storage\tenant.php" = "api\storage\tenant.php"
    "api\storage\usage.php" = "api\storage\usage.php"
    "api\storage\file.php" = "api\storage\file.php"
    "super_admin\dashboard.php" = "super_admin\dashboard.php"
    "admin\dashboard.php" = "admin\dashboard.php"
    "admin\partials\header.php" = "admin\partials\header.php"
}

$fileCount = 0
foreach ($file in $filesToCopy.Keys) {
    $source = Join-Path $sourcePath $file
    $dest = Join-Path $stagingDir $filesToCopy[$file]
    
    if (Test-Path $source) {
        Copy-Item $source $dest -Force
        $fileCount++
        Write-Host "  OK: $file"
    } else {
        Write-Host "  MISSING: $file"
    }
}

# Create ZIP
Write-Host "[4/5] Creating ZIP archive..."
Compress-Archive -Path "$stagingDir\*" -DestinationPath $outputZip -Force

# Cleanup
Remove-Item $stagingDir -Recurse -Force
Write-Host "[5/5] Cleaned up temporary files"

# Summary
Write-Host ""
Write-Host "========================================"
Write-Host "  Package Created Successfully!"
Write-Host "========================================"
Write-Host ""
Write-Host "Files packaged: $fileCount"
Write-Host "Output file: storage_dashboards_upload.zip"
Write-Host ""
Write-Host "NEXT STEPS:"
Write-Host "1. Login to cPanel File Manager"
Write-Host "2. Navigate to: public_html/test.melanegroup.com/Multi-Tanent/"
Write-Host "3. Upload: storage_dashboards_upload.zip"
Write-Host "4. Right-click ZIP > Extract"
Write-Host "5. Delete the ZIP file"
Write-Host "6. Test the storage pages"
Write-Host ""
Write-Host "Package location:"
Write-Host $outputZip
Write-Host ""

# Open folder
explorer.exe /select,$outputZip
