<?php
/**
 * Diagnostic script to check grades and subjects filtering
 */

require_once 'config.php';
require_once 'includes/functions.php';

$pdo = getDB();

echo "========================================\n";
echo "GRADES STATUS CHECK\n";
echo "========================================\n\n";

// Check all grades
$stmt = $pdo->query("SELECT id, name, is_enabled FROM grades ORDER BY name");
$grades = $stmt->fetchAll();

echo "All Grades in Database:\n";
echo "ID | Name | is_enabled\n";
echo "---|------|------------\n";
foreach ($grades as $grade) {
    echo $grade['id'] . " | " . $grade['name'] . " | " . $grade['is_enabled'] . "\n";
}

echo "\n========================================\n";
echo "ENABLED GRADES ONLY\n";
echo "========================================\n\n";

$stmt = $pdo->query("SELECT id, name FROM grades WHERE is_enabled = 1 ORDER BY name");
$enabled_grades = $stmt->fetchAll();

echo "Count: " . count($enabled_grades) . "\n";
foreach ($enabled_grades as $grade) {
    echo "- " . $grade['name'] . " (ID: " . $grade['id'] . ")\n";
}

echo "\n========================================\n";
echo "SUBJECTS FOR ENABLED GRADES\n";
echo "========================================\n\n";

$stmt = $pdo->query("
    SELECT DISTINCT s.id, s.name, s.code, 
           GROUP_CONCAT(DISTINCT g.name ORDER BY g.name SEPARATOR ', ') as grades
    FROM subjects s
    INNER JOIN grade_subject gs ON s.id = gs.subject_id
    INNER JOIN grades g ON gs.grade_id = g.id
    WHERE g.is_enabled = 1
    GROUP BY s.id, s.name, s.code
    ORDER BY s.name
");
$subjects = $stmt->fetchAll();

echo "Count: " . count($subjects) . "\n\n";
foreach ($subjects as $subject) {
    echo "- " . $subject['name'] . " (" . $subject['code'] . ") - Grades: " . $subject['grades'] . "\n";
}

echo "\n========================================\n";
echo "ALL SUBJECTS (NO FILTER)\n";
echo "========================================\n\n";

$stmt = $pdo->query("
    SELECT DISTINCT s.id, s.name, s.code, 
           GROUP_CONCAT(DISTINCT g.name ORDER BY g.name SEPARATOR ', ') as grades
    FROM subjects s
    INNER JOIN grade_subject gs ON s.id = gs.subject_id
    INNER JOIN grades g ON gs.grade_id = g.id
    GROUP BY s.id, s.name, s.code
    ORDER BY s.name
");
$all_subjects = $stmt->fetchAll();

echo "Count: " . count($all_subjects) . "\n\n";
foreach ($all_subjects as $subject) {
    echo "- " . $subject['name'] . " (" . $subject['code'] . ") - Grades: " . $subject['grades'] . "\n";
}

echo "\n========================================\n";
echo "DONE\n";
echo "========================================\n";
?>

