"""
Production Configuration Template for Python Moodle Sync Bot
Copy this to config.py and update with your production settings
"""

import os
from pathlib import Path

# Database configuration - UPDATE THESE VALUES
DB_CONFIG = {
    'host': 'localhost',  # Usually 'localhost' on shared hosting
    'port': 3306,
    'database': 'melane_kine',  # Your actual database name
    'user': 'melane_admin',      # Your database username
    'password': '1H^+r,zN&yPbv*dJ',  # Your database password
    'charset': 'utf8mb4'
}

# SMTP configuration - UPDATE THESE VALUES
SMTP_CONFIG = {
    'host': 'mail.yourdomain.com',  # Your mail server
    'port': 587,
    'username': 'noreply@yourdomain.com',  # Your email
    'password': 'your_email_password',     # Your email password
    'encryption': 'tls',
    'from_email': 'noreply@yourdomain.com',
    'from_name': 'Your Learning Platform'
}

# Application settings
APP_CONFIG = {
    'name': 'Your Learning Platform',
    'max_students': 500,
    'admin_username': 'admin',
    'admin_password': 'your_secure_password',  # Change this!
    'whatsapp_group_link': 'https://chat.whatsapp.com/your-group-link',
    'debug': False  # Set to False in production
}

# Moodle configuration - UPDATE THESE VALUES
MOODLE_CONFIG = {
    'url': 'https://your-moodle-domain.com/',  # Your Moodle URL
    'api_url': 'https://your-moodle-domain.com/webservice/rest/server.php',
    'api_token': 'your_production_api_token'  # Your actual API token
}

# Bot configuration
BOT_CONFIG = {
    'skolo_api_url': 'https://your-domain.com/api/export_csv.php',  # Your API URL
    'skolo_api_key': 'your_production_api_key',  # Your actual API key
    'moodle_ws_function': 'core_user_create_users',
    'max_retries': 3,
    'retry_delay': 5,  # seconds
    'batch_size': 5,   # Increase for production (was 1 for testing)
    'timeout': 30
}

# File paths
BASE_DIR = Path(__file__).parent.parent
BOT_DIR = Path(__file__).parent
TEMP_DIR = BOT_DIR / 'temp'
LOGS_DIR = BOT_DIR / 'logs'
EXPORTS_DIR = BASE_DIR / 'exports'

# Ensure directories exist
TEMP_DIR.mkdir(exist_ok=True)
LOGS_DIR.mkdir(exist_ok=True)
EXPORTS_DIR.mkdir(exist_ok=True)

# Log file paths
LOG_FILES = {
    'sync': LOGS_DIR / 'sync.log',
    'test_user_creation': LOGS_DIR / 'test_user_creation.log',
    'test_sync': LOGS_DIR / 'test_sync.log'
}

# Lock file for preventing concurrent runs
LOCK_FILE = TEMP_DIR / 'sync.lock'
LOCK_TIMEOUT = 300  # 5 minutes

# Subject to course mapping (subject_id -> course_id)
# UPDATE THESE WITH YOUR ACTUAL MOODLE COURSE IDs
SUBJECT_TO_COURSE_MAPPING = {
    1: None,   # Consumer Science - Replace None with actual course ID
    2: None,   # Mathematics - Replace None with actual course ID
    5: None,   # English - Replace None with actual course ID
    7: None,   # Siswati - Replace None with actual course ID
    18: None,  # Science - Replace None with actual course ID
    21: None,  # Religious Education - Replace None with actual course ID
    24: None,  # ICT - Replace None with actual course ID
    27: None,  # Expressive Arts - Replace None with actual course ID
    31: None,  # Social Studies - Replace None with actual course ID
    32: None,  # Agriculture - Replace None with actual course ID
    33: None,  # HPE - Replace None with actual course ID
}

# Course name patterns for automatic mapping
COURSE_NAME_PATTERNS = {
    'mathematics': 2,
    'math': 2,
    'english': 5,
    'science': 18,
    'consumer': 1,
    'siswati': 7,
    'religious': 21,
    'ict': 24,
    'arts': 27,
    'social': 31,
    'agriculture': 32,
    'hpe': 33
}

# Database connection string for SQLAlchemy
def get_database_url():
    """Get database URL for SQLAlchemy"""
    return f"mysql+pymysql://{DB_CONFIG['user']}:{DB_CONFIG['password']}@{DB_CONFIG['host']}:{DB_CONFIG['port']}/{DB_CONFIG['database']}?charset={DB_CONFIG['charset']}"

# Environment variable overrides
def load_from_env():
    """Load configuration from environment variables if available"""
    # Database
    if os.getenv('DB_HOST'):
        DB_CONFIG['host'] = os.getenv('DB_HOST')
    if os.getenv('DB_PORT'):
        DB_CONFIG['port'] = int(os.getenv('DB_PORT'))
    if os.getenv('DB_NAME'):
        DB_CONFIG['database'] = os.getenv('DB_NAME')
    if os.getenv('DB_USER'):
        DB_CONFIG['user'] = os.getenv('DB_USER')
    if os.getenv('DB_PASS'):
        DB_CONFIG['password'] = os.getenv('DB_PASS')
    
    # Moodle
    if os.getenv('MOODLE_API_URL'):
        MOODLE_CONFIG['api_url'] = os.getenv('MOODLE_API_URL')
    if os.getenv('MOODLE_API_TOKEN'):
        MOODLE_CONFIG['api_token'] = os.getenv('MOODLE_API_TOKEN')
    
    # SMTP
    if os.getenv('SMTP_HOST'):
        SMTP_CONFIG['host'] = os.getenv('SMTP_HOST')
    if os.getenv('SMTP_USERNAME'):
        SMTP_CONFIG['username'] = os.getenv('SMTP_USERNAME')
    if os.getenv('SMTP_PASSWORD'):
        SMTP_CONFIG['password'] = os.getenv('SMTP_PASSWORD')

# Load environment variables
load_from_env()

# Production-specific settings
PRODUCTION_SETTINGS = {
    'log_level': 'INFO',  # INFO, WARNING, ERROR
    'max_log_files': 10,  # Keep last 10 log files
    'log_rotation_size': 10485760,  # 10MB
    'enable_email_notifications': True,
    'notification_email': 'admin@yourdomain.com',
    'backup_enabled': True,
    'backup_retention_days': 30
}
