<?php
/**
 * Admin Withdrawal Request Handler
 * Processes withdrawal requests from admin dashboard
 */

require_once '../includes/functions.php';
require_once '../includes/wallet_functions.php';

requireAdminLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Get request parameters
$amount = floatval($_POST['amount'] ?? 0);
$momo_number = trim($_POST['momo_number'] ?? '');
$admin_id = $_SESSION['admin_id'] ?? 1;

// Validate inputs
if ($amount <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid amount']);
    exit;
}

if (empty($momo_number)) {
    echo json_encode(['success' => false, 'error' => 'MoMo number is required']);
    exit;
}

// Process withdrawal
try {
    $result = requestWithdrawal($admin_id, $amount, $momo_number);
    
    // Log withdrawal request
    error_log("Withdrawal request: Admin {$admin_id}, Amount: SZL {$amount}, MoMo: {$momo_number}, Result: " . json_encode($result));
    
    echo json_encode($result);
    
} catch (Exception $e) {
    error_log("Withdrawal request error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'System error: ' . $e->getMessage()
    ]);
}
?>

