<?php
require_once '../config.php';
require_once '../includes/functions.php';
requireAdminLogin();

ensurePaymentsTables();

$message = '';
$messageType = '';

// Handle mark-paid action
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_paid'])) {
    $pid = (int)($_POST['payment_id'] ?? 0);
    if ($pid && adminMarkPaymentPaid($pid)) {
        $message = 'Payment marked as paid and subjects enrolled.';
        $messageType = 'success';
    } else {
        $message = 'Failed to mark payment as paid.';
        $messageType = 'danger';
    }
}

// Filters
$status = $_GET['status'] ?? '';
$gradeId = isset($_GET['grade_id']) ? (int)$_GET['grade_id'] : 0;
$subjectId = isset($_GET['subject_id']) ? (int)$_GET['subject_id'] : 0;
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$page = max(1, (int)($_GET['page'] ?? 1));
$pageSize = 25;
$total = 0;

$grades = getGrades();
$subjects = getAllSubjects();

$filters = [
    'status' => $status ?: null,
    'from' => $from ?: null,
    'to' => $to ?: null,
    'grade_id' => $gradeId ?: null,
    'subject_id' => $subjectId ?: null,
];

// Export CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $rows = getPaymentsReport($filters, 1, 100000, $total);
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="payments_report.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Date','Student','Email','Grade','Amount','Currency','MSISDN','Status','Subjects']);
    foreach ($rows as $r) {
        $ps = getPaymentSubjects((int)$r['id']);
        $names = implode('; ', array_map(fn($x)=>$x['name'], $ps));
        fputcsv($out, [
            $r['created_at'], $r['first_name'].' '.$r['last_name'], $r['email'], $r['grade_name'],
            number_format((float)$r['amount'],2), $r['currency'], $r['msisdn'], $r['status'], $names
        ]);
    }
    fclose($out);
    exit;
}

$rows = getPaymentsReport($filters, $page, $pageSize, $total);
$pages = max(1, (int)ceil($total / $pageSize));
?>
<?php $pageTitle = 'Payments - '.APP_NAME.' Admin'; $hidePaymentsLink = true; include __DIR__.'/partials/header.php'; ?>
<div class="container-fluid py-3">
    <div class="hero p-4 mb-3 text-dark">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
            <div>
                <h1 class="h4 fw-bold mb-1 brand-underline">Payments</h1>
                <div class="small text-muted">Track per-subject payments, filter and export, reconcile and enroll.</div>
            </div>
            <div>
                <a class="btn btn-outline-secondary" href="dashboard.php"><i class="bi bi-speedometer2 me-1"></i>Dashboard</a>
                <a class="btn btn-gradient" href="?export=csv&status=<?php echo urlencode($status); ?>&grade_id=<?php echo (int)$gradeId; ?>&subject_id=<?php echo (int)$subjectId; ?>&from=<?php echo urlencode($from); ?>&to=<?php echo urlencode($to); ?>">
                    <i class="bi bi-download me-1"></i>Export CSV
                </a>
            </div>
        </div>
    </div>
    <?php if ($message): ?>
        <div class="alert alert-<?php echo $messageType; ?>"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <form class="card card-modern card-body mb-3" method="GET">
        <div class="row g-2 align-items-end">
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All</option>
                    <?php foreach (['PENDING','SUCCESSFUL','FAILED'] as $st): ?>
                        <option value="<?php echo $st; ?>" <?php echo $status===$st?'selected':''; ?>><?php echo $st; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Grade</label>
                <select name="grade_id" class="form-select">
                    <option value="">All</option>
                    <?php foreach ($grades as $g): ?>
                        <option value="<?php echo (int)$g['id']; ?>" <?php echo $gradeId===(int)$g['id']?'selected':''; ?>><?php echo htmlspecialchars($g['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Subject</label>
                <select name="subject_id" class="form-select">
                    <option value="">All</option>
                    <?php foreach ($subjects as $s): ?>
                        <option value="<?php echo (int)$s['id']; ?>" <?php echo $subjectId===(int)$s['id']?'selected':''; ?>><?php echo htmlspecialchars($s['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">From</label>
                <input type="date" class="form-control" name="from" value="<?php echo htmlspecialchars($from); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">To</label>
                <input type="date" class="form-control" name="to" value="<?php echo htmlspecialchars($to); ?>">
            </div>
            <div class="col-md-1">
                <button class="btn btn-primary w-100" type="submit">Filter</button>
            </div>
            <div class="col-md-12 text-end small text-muted">Use filters to refine, then export or reconcile below.</div>
        </div>
    </form>

    <div class="card card-modern">
        <div class="table-responsive">
            <table class="table table-striped table-hover align-middle mb-0">
                <thead>
                <tr>
                    <th>Date</th>
                    <th>Student</th>
                    <th>Grade</th>
                    <th>Amount</th>
                    <th>MSISDN</th>
                    <th>Status</th>
                    <th>Subjects</th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($rows as $r): $ps = getPaymentSubjects((int)$r['id']); ?>
                    <tr>
                        <td><?php echo htmlspecialchars($r['created_at'] ?? $r['payment_date'] ?? date('Y-m-d H:i:s')); ?></td>
                        <td><?php echo htmlspecialchars($r['first_name'].' '.$r['last_name']); ?><br><small class="text-muted"><?php echo htmlspecialchars($r['email']); ?></small></td>
                        <td><?php echo htmlspecialchars($r['grade_name'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars(($r['currency'] ?? 'SZL') ?: 'SZL'); ?> <?php echo number_format((float)$r['amount'],2); ?></td>
                        <td><?php echo htmlspecialchars((($r['msisdn'] ?? $r['momo_number'] ?? '') ?: 'N/A')); ?></td>
                        <td><span class="badge <?php echo $r['status']==='SUCCESSFUL'?'bg-success':($r['status']==='PENDING'?'bg-warning text-dark':'bg-danger'); ?>"><?php echo htmlspecialchars($r['status']); ?></span></td>
                        <td><?php echo htmlspecialchars(implode(', ', array_map(fn($x)=>$x['name'], $ps))); ?></td>
                        <td class="text-end">
                            <?php if ($r['status'] !== 'SUCCESSFUL'): ?>
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="payment_id" value="<?php echo (int)$r['id']; ?>">
                                <button class="btn btn-sm btn-gradient" name="mark_paid" value="1" onclick="return confirm('Mark as paid and enroll subjects?')"><i class="bi bi-check2-circle me-1"></i>Mark Paid</button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="card-body">
            <nav>
                <ul class="pagination mb-0">
                    <?php for ($p=1;$p<=$pages;$p++): ?>
                        <li class="page-item <?php echo $p===$page?'active':''; ?>">
                            <a class="page-link" href="?status=<?php echo urlencode($status); ?>&grade_id=<?php echo (int)$gradeId; ?>&subject_id=<?php echo (int)$subjectId; ?>&from=<?php echo urlencode($from); ?>&to=<?php echo urlencode($to); ?>&page=<?php echo $p; ?>"><?php echo $p; ?></a>
                        </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        </div>
    </div>
<?php include __DIR__.'/partials/footer.php'; ?>


