<?php
require_once __DIR__ . '/../../config.php';

// Determine base path for links
$currentPath = $_SERVER['PHP_SELF'] ?? '';
$adminBase = '';
$selectSchoolPath = '';

if (strpos($currentPath, '/admin/applications/') !== false) {
    // We're in admin/applications/ directory
    $adminBase = '../';
    $selectSchoolPath = '../../select_school.php';
} elseif (strpos($currentPath, '/admin/settings/') !== false) {
    // We're in admin/settings/ directory
    $adminBase = '../';
    $selectSchoolPath = '../../select_school.php';
} elseif (strpos($currentPath, '/admin/storage/') !== false) {
    // We're in admin/storage/ directory
    $adminBase = '../';
    $selectSchoolPath = '../../select_school.php';
} elseif (strpos($currentPath, '/admin/moodle/') !== false) {
    // We're in admin/moodle/ directory
    $adminBase = '../';
    $selectSchoolPath = '../../select_school.php';
} elseif (strpos($currentPath, '/admin/') !== false) {
    // We're in admin/ directory (root level)
    $adminBase = '';
    $selectSchoolPath = '../select_school.php';
} else {
    // We're at root level
    $adminBase = 'admin/';
    $selectSchoolPath = 'select_school.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle)?$pageTitle:APP_NAME.' Admin'; ?></title>
    <meta name="theme-color" content="#0f3460">
    <link rel="icon" href="../images/img-melanesys-logo.svg" type="image/svg+xml">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root { --brand1:#1a1a2e; --brand2:#0f3460; --accent:#20c997; --primary:#6f42c1; }
        body{
            background: radial-gradient(1200px 600px at 10% -10%, rgba(111,66,193,.08), transparent 60%),
                        radial-gradient(1200px 600px at 110% 10%, rgba(32,201,151,.08), transparent 60%),
                        #f6f8fb;
        }
        .top-navbar{background:linear-gradient(135deg, var(--brand1), var(--brand2)); border-bottom:3px solid var(--primary)}
        .top-navbar .navbar-brand{color:#fff; font-weight:700; letter-spacing:.4px}
        .top-navbar .navbar-brand img{height:28px; width:28px; margin-right:.5rem}
        .hero{background: linear-gradient(90deg, rgba(111,66,193,.08), rgba(32,201,151,.08)); border-radius:1rem}
        .brand-underline{position:relative; display:inline-block}
        .brand-underline::after{content:""; position:absolute; left:0; right:0; bottom:-.25rem; height:.3rem; background:linear-gradient(90deg, var(--primary), var(--accent)); border-radius:1rem}
        .card-modern{border:0; border-radius:1rem; box-shadow:0 1rem 2rem rgba(0,0,0,.07);}
        .btn-gradient{background:linear-gradient(90deg, var(--primary), var(--accent)); border:0; color:#fff}
        .btn-gradient:hover{filter:brightness(.95); color:#fff}
        .badge-soft{background-color: rgba(13,110,253,.12); color:#0d6efd; border:1px solid rgba(13,110,253,.2);}
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg top-navbar mb-3">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="<?= $adminBase ?>dashboard.php">
            <img src="<?= $adminBase ?>../images/img-melanesys-logo.svg" alt="Logo"> <?php echo APP_NAME; ?> Admin
        </a>
        <?php if (function_exists('getCurrentSchool') && getCurrentSchool()): ?>
        <div class="navbar-text text-white-50 mx-3">
            <i class="bi bi-building me-1"></i>
            <strong><?php echo function_exists('getSchoolName') ? getSchoolName() : getCurrentSchool(); ?></strong>
        </div>
        <?php endif; ?>
        <div class="navbar-nav ms-auto">
            <a class="nav-link text-white-50" href="<?= $adminBase ?>dashboard.php"><i class="bi bi-speedometer2 me-1"></i>Dashboard</a>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>applications/list.php"><i class="bi bi-file-earmark-text me-1"></i>Applications</a>
            <?php if (empty($hidePaymentsLink)): ?>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>payments.php"><i class="bi bi-cash-coin me-1"></i>Payments</a>
            <?php endif; ?>
            <?php if (empty($hideRestoreLink)): ?>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>restore_student.php"><i class="bi bi-arrow-clockwise me-1"></i>Restore</a>
            <?php endif; ?>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>configure_subjects.php"><i class="bi bi-gear me-1"></i>Configure</a>
            <?php if (function_exists('getCurrentSchool')): ?>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>settings/school_settings.php"><i class="bi bi-gear-fill me-1"></i>School Settings</a>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>storage/usage.php"><i class="bi bi-hdd-stack me-1"></i>Storage</a>
            <?php if (function_exists('isSuperAdmin') && isSuperAdmin()): ?>
            <a class="nav-link text-warning" href="<?= $adminBase ?>../super_admin/dashboard.php"><i class="bi bi-shield-check me-1"></i>Super Admin</a>
            <?php endif; ?>
            <a class="nav-link text-white-50" href="<?= $selectSchoolPath ?>"><i class="bi bi-arrow-left-right me-1"></i>Switch School</a>
            <?php endif; ?>
            <a class="nav-link text-white-50" href="<?= $adminBase ?>logout.php"><i class="bi bi-box-arrow-right me-1"></i>Logout</a>
        </div>
    </div>
</nav>

