<?php
require_once '../includes/functions.php';
requireAdminLogin();

// Get growth data for Chart.js
$pdo = getDB();

// Students registered per month for the last 12 months
$stmt = $pdo->query("
    SELECT 
        DATE_FORMAT(created_at, '%Y-%m') as month,
        COUNT(*) as count
    FROM students 
    WHERE created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
    GROUP BY DATE_FORMAT(created_at, '%Y-%m')
    ORDER BY month
");

$growthData = $stmt->fetchAll();

// Fill in missing months with 0
$months = [];
$currentMonth = date('Y-m');
for ($i = 11; $i >= 0; $i--) {
    $months[] = date('Y-m', strtotime("-$i months"));
}

$chartData = [];
foreach ($months as $month) {
    $found = false;
    foreach ($growthData as $data) {
        if ($data['month'] === $month) {
            $chartData[] = (int)$data['count'];
            $found = true;
            break;
        }
    }
    if (!$found) {
        $chartData[] = 0;
    }
}

header('Content-Type: application/json');
echo json_encode([
    'labels' => array_map(function($month) {
        return date('M Y', strtotime($month . '-01'));
    }, $months),
    'data' => $chartData
]);
?>

