<?php
require_once '../includes/functions.php';
requireAdminLogin();

// Prefer the bot-prepared latest credentials CSV to ensure exact match with emailed data
$preparedLatest = __DIR__ . '/../exports/prepared_user_credentials_latest.csv';

if (file_exists($preparedLatest)) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="moodle_students_import.csv"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Expires: 0');
    readfile($preparedLatest);
    exit;
}

// Fallback: generate from database if the prepared CSV is not available
$filePath = generateMoodleCSV();

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="moodle_students_import.csv"');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Expires: 0');

readfile($filePath);
unlink($filePath);
exit;
?>
