# ⚡ Tenant Files Table - Quick Start

## 🚀 **5-Minute Setup**

### **Step 1: Import Migration (2 min)**

**phpMyAdmin:**
1. Import tab
2. Choose: `database/migrations/create_tenant_files_table.sql`
3. Click Go

**Result:**
```
✅ 3 tables created
✅ 8+ indexes created
✅ 2 views created
✅ 1 trigger created
✅ Sample data inserted
```

---

### **Step 2: Verify (1 min)**

```sql
-- Quick check
SELECT COUNT(*) FROM tenant_files;
DESCRIBE tenant_files;
SHOW INDEXES FROM tenant_files;
```

---

### **Step 3: Test Insert (1 min)**

```sql
INSERT INTO tenant_files (
    tenant_id, file_category, original_filename, stored_filename,
    file_path, file_size, mime_type
) VALUES (
    'test_school', 'document', 'test.pdf', 'test_123.pdf',
    'school_test_school/uploads/documents/test_123.pdf',
    123456, 'application/pdf'
);

-- Check it worked
SELECT * FROM tenant_files WHERE tenant_id = 'test_school';
```

---

### **Step 4: Use in Code (1 min)**

```php
// Log file upload
$stmt = $conn->prepare("
    INSERT INTO tenant_files (
        tenant_id, file_category, original_filename, 
        stored_filename, file_path, file_size, mime_type
    ) VALUES (?, ?, ?, ?, ?, ?, ?)
");

$stmt->execute([
    $_SESSION['academy_reference'],
    'document',
    $_FILES['file']['name'],
    $stored_filename,
    $file_path,
    $_FILES['file']['size'],
    $_FILES['file']['type']
]);
```

---

## 📋 **Table Structure**

```
tenant_files (Main table)
├── id (PK)
├── tenant_id
├── file_category (document/photo/receipt/report/backup/other)
├── original_filename
├── stored_filename (UNIQUE)
├── file_path
├── file_size
├── mime_type
├── uploaded_by
├── related_id
├── related_type
├── upload_date
├── is_deleted
└── deleted_at
```

---

## 🔍 **Common Queries**

### **Get All Files**
```sql
SELECT * FROM v_active_tenant_files 
WHERE tenant_id = 'your_tenant';
```

### **Storage Usage**
```sql
SELECT * FROM v_tenant_file_stats;
```

### **Recent Files**
```sql
SELECT * FROM tenant_files 
WHERE upload_date >= DATE_SUB(NOW(), INTERVAL 7 DAY)
ORDER BY upload_date DESC;
```

### **Soft Delete**
```sql
UPDATE tenant_files 
SET is_deleted = 1, deleted_at = NOW()
WHERE id = 123;
```

---

## 🎯 **Integration Example**

```php
// After successful file upload
require_once 'config.php';

$stmt = $conn->prepare("
    INSERT INTO tenant_files (
        tenant_id, file_category, original_filename,
        stored_filename, file_path, file_size, mime_type,
        uploaded_by, related_id, related_type
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->execute([
    $_SESSION['academy_reference'],
    'document',                    // or photo, receipt, report
    $_FILES['file']['name'],
    $stored_filename,              // sanitized_timestamp.ext
    $full_path,                    // relative path
    $_FILES['file']['size'],
    $_FILES['file']['type'],
    $_SESSION['user_id'],
    $student_id,                   // related entity ID
    'student'                      // related entity type
]);

$file_id = $conn->lastInsertId();
```

---

## 🔄 **Rollback (If Needed)**

```bash
# Import rollback script
mysql -u user -p db < database/migrations/rollback_tenant_files_table.sql
```

---

## ✅ **Files Included**

```
✅ create_tenant_files_table.sql    - Main migration
✅ rollback_tenant_files_table.sql  - Undo script
✅ tenant_files_sample_data.sql     - Test data
✅ tenant_files_verification_queries.sql - 50+ queries
✅ TENANT_FILES_TABLE_MIGRATION_GUIDE.md - Complete guide
✅ TENANT_FILES_TABLE_QUICK_START.md     - This file
```

---

## 📚 **Full Guide**

See `TENANT_FILES_TABLE_MIGRATION_GUIDE.md` for:
- Complete documentation
- Verification queries
- Troubleshooting
- Best practices

---

**Total Setup Time: 5 minutes** ⚡  
**Ready for Production!** 🚀

