# 🔐 Super Admin Login Guide

## Where Super Admin Logs In

---

## 🎯 **Simple Answer:**

**Super Admin uses the SAME login page as regular admins!**

**Login URL:** `https://test.melanegroup.com/Multi-Tanent/admin/login.php`

The system automatically detects if you're a Super Admin or Regular Admin after login.

---

## 🔑 **Current Login Credentials**

### **Super Admin (You - Platform Owner):**

```
URL: https://test.melanegroup.com/Multi-Tanent/admin/login.php
Username: admin
Password: admin123

⚠️ IMPORTANT: CHANGE THIS PASSWORD IMMEDIATELY!
```

### **School Admins (For each school):**

**KINE Academy Admin:**
```
Username: kine_admin (or similar)
Password: [set during school creation]
```

**TEST School Admin:**
```
Username: test_admin (or similar)
Password: [set during school creation]
```

---

## 🚀 **Login Flow**

### **For Super Admin:**

1. **Visit:** `https://test.melanegroup.com/Multi-Tanent/admin/login.php`

2. **Enter Credentials:**
   - Username: `admin`
   - Password: `admin123`

3. **Click "Login"**

4. **After Login - Two Scenarios:**

   **Scenario A:** If you have `academy_reference = NULL` in database:
   - System recognizes you as Super Admin
   - Redirected to: `/select_school.php` (School Selector)
   - You see ALL schools listed
   - Can click "Super Admin" in navigation
   
   **Scenario B:** If you have a specific `academy_reference`:
   - Logged in as regular admin
   - Need to make yourself super admin (see below)

---

## 🛡️ **How Super Admin is Detected**

The system checks the `admins` table in the database:

```sql
-- Super Admin
academy_reference = NULL  ← No specific school assigned

-- Regular Admin
academy_reference = 'KINE'  ← Assigned to KINE Academy
```

When you login, the system queries:
```php
SELECT academy_reference FROM admins WHERE username = 'admin';
```

- If result is **NULL** → You're Super Admin ✅
- If result is **'KINE'** → You're Regular Admin for KINE Academy

---

## 🔧 **Make Yourself Super Admin**

If you login but don't see Super Admin options:

### **Method 1: Via phpMyAdmin (Recommended)**

1. **Login to phpMyAdmin** on cPanel
2. **Select database:** `melane_multi_tenant_skoloi`
3. **Click "admins" table**
4. **Click "Browse" tab**
5. **Find your admin user** (username: `admin`)
6. **Click "Edit"** (pencil icon)
7. **Set `academy_reference` to NULL:**
   - Check the "NULL" checkbox for `academy_reference` field
   - OR delete the value and leave it empty
8. **Click "Go"** to save

### **Method 2: Via SQL Query**

Run this in phpMyAdmin SQL tab:

```sql
-- Make admin user a super admin
UPDATE admins 
SET academy_reference = NULL 
WHERE username = 'admin';

-- Verify
SELECT id, username, academy_reference 
FROM admins 
WHERE username = 'admin';
```

**Expected Result:**
```
id | username | academy_reference
1  | admin    | NULL
```

### **Method 3: Create New Super Admin**

```sql
-- Insert new super admin
INSERT INTO admins (username, password_hash, academy_reference, is_active)
VALUES (
    'superadmin',
    '$2y$10$YourBcryptHashHere',  -- Generate at bcrypt-generator.com
    NULL,  -- NULL = Super Admin
    1
);
```

---

## 📱 **After Login Navigation**

### **When Logged in as Super Admin:**

**You see in the navigation bar:**
```
┌──────────────────────────────────────────┐
│  Skolo-Kine  |  Dashboard  |  Students  │
│  Payments    |  Settings   |            │
│                                          │
│  [School Name]  |  Super Admin  | Logout│
└──────────────────────────────────────────┘
```

**Clicking "Super Admin":**
- Takes you to: `/super_admin/dashboard.php`
- Shows system-wide overview
- Lists all schools
- Platform earnings

**Clicking School Name:**
- Shows school selector
- Lets you switch between schools
- Quick access to any school

---

## 🏫 **School Selector Page**

**After login, Super Admin sees:**

```
┌─────────────────────────────────────────┐
│     Select School to Manage             │
├─────────────────────────────────────────┤
│                                         │
│  [🏫 KINE Academy]                      │
│  5 students | Access Dashboard          │
│                                         │
│  [🏫 Test School]                       │
│  5 students | Access Dashboard          │
│                                         │
│  [+ Create New School]                  │
│                                         │
└─────────────────────────────────────────┘
```

**Super Admin Options:**
- ✅ Access any school dashboard
- ✅ Create new schools
- ✅ Go to Super Admin dashboard
- ✅ Manage all schools

---

## 🔐 **Change Admin Password (IMPORTANT!)**

### **Method 1: Generate Bcrypt Hash**

1. **Go to:** https://bcrypt-generator.com/
2. **Enter your new password** (e.g., `MySecurePass123!`)
3. **Copy the generated hash** (looks like: `$2y$10$...`)
4. **In phpMyAdmin:**
   ```sql
   UPDATE admins 
   SET password_hash = '$2y$10$YourCopiedHashHere'
   WHERE username = 'admin';
   ```

### **Method 2: Via PHP Script**

Create file: `change_password.php`
```php
<?php
require_once 'config.php';

$newPassword = 'YourNewPassword123!';
$hash = password_hash($newPassword, PASSWORD_BCRYPT);

$pdo = getDB();
$stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE username = 'admin'");
$stmt->execute([$hash]);

echo "Password updated! New password: " . $newPassword;
?>
```

Run once, then **DELETE THE FILE!**

---

## 🎯 **Quick Reference**

### **Login URLs:**

| User Type | Login URL |
|-----------|-----------|
| **Super Admin** | `/admin/login.php` ✅ |
| **School Admin** | `/admin/login.php` ✅ |
| **Students** | `/login.php` (different) |

**Yes, all admins use the SAME login page!**

### **After Login Redirects:**

| User Type | Redirect To |
|-----------|-------------|
| **Super Admin** | `/select_school.php` (can choose any school) |
| **School Admin** | `/admin/dashboard.php` (their school) |

### **Super Admin Detection:**

```php
// In database
academy_reference = NULL  → Super Admin

// In session
$_SESSION['is_super_admin'] = true
```

---

## 📊 **Current System Status**

### **Your Setup:**

**Database:** `melane_multi_tenant_skoloi`

**Admins Table:**
```
id | username | academy_reference | is_super_admin
1  | admin    | NULL              | ✅ YES
2  | kine_...| KINE              | ❌ NO
3  | test_...| TEST              | ❌ NO
```

**Schools:**
- KINE Academy (5 students)
- Test School (5 students)

**Access Level:**
- You (admin) = Super Admin ✅
- Can access all schools ✅
- Can create new schools ✅

---

## ✅ **Checklist: First Login as Super Admin**

- [ ] Visit login page
- [ ] Login with username: `admin`, password: `admin123`
- [ ] Verify you see school selector (not directly to dashboard)
- [ ] Check if "Super Admin" link appears in navigation
- [ ] If no "Super Admin" link, make yourself super admin via database
- [ ] **CHANGE PASSWORD IMMEDIATELY!**
- [ ] Test accessing each school
- [ ] Test creating a new school
- [ ] Test platform earnings view

---

## 🆘 **Troubleshooting**

### **Problem: Don't see "Super Admin" link**

**Solution:**
```sql
UPDATE admins 
SET academy_reference = NULL 
WHERE username = 'admin';
```

### **Problem: Can only see one school**

**Solution:** You're logged in as school admin, not super admin. Set `academy_reference` to NULL.

### **Problem: Forgot password**

**Solution:**
```sql
-- Generate hash at bcrypt-generator.com
UPDATE admins 
SET password_hash = '$2y$10$NewHashHere'
WHERE username = 'admin';
```

### **Problem: Login works but redirects to wrong page**

**Solution:** Clear browser cache and cookies, logout, login again.

---

## 🎉 **Summary**

### **Super Admin Login:**
✅ **URL:** `https://test.melanegroup.com/Multi-Tanent/admin/login.php`  
✅ **Username:** `admin`  
✅ **Password:** `admin123` (CHANGE THIS!)  
✅ **Detection:** `academy_reference = NULL` in database  
✅ **Access:** ALL schools + Super Admin dashboard  

### **What Makes You Super Admin:**
- Same login page as regular admins
- Database: `academy_reference = NULL`
- Session: `is_super_admin = true`
- Result: Full platform access

---

**Important:** The Super Admin uses the **same login page** as everyone else. The system automatically determines your access level based on your `academy_reference` in the database!

---

**Document:** SUPER_ADMIN_LOGIN_GUIDE.md  
**Last Updated:** October 23, 2025  
**Login URL:** `/admin/login.php` (same for everyone!)  
**Super Admin:** Set `academy_reference = NULL` in database

