# 🛡️ Super Admin Features & Functions

## Overview

The **Super Admin** is a special administrative role with system-wide access across all schools in your multi-tenant platform. Unlike regular admins who can only manage their assigned school, the Super Admin can manage all schools, view cross-school analytics, and configure platform-wide settings.

---

## 🔑 How Super Admin Works

### **Super Admin Detection:**
A user is identified as a Super Admin when their `academy_reference` is `NULL` in the `admins` table.

```php
// Function: isSuperAdmin()
// Location: includes/school_context.php
return isset($_SESSION['is_super_admin']) && $_SESSION['is_super_admin'] === true;
```

### **Super Admin Login:**
- Username/Email without an assigned school → Gets `is_super_admin` flag
- Can switch between any school
- Bypasses school-specific access restrictions

---

## 📊 Super Admin Dashboard

**Location:** `super_admin/dashboard.php`

### **System-Wide Statistics:**

1. **Total Schools** 
   - Count of all active schools in the system
   
2. **Total Students**
   - Aggregate count across all schools
   
3. **Total Payments**
   - System-wide payment count
   
4. **Total Revenue**
   - Combined revenue from all schools
   
5. **Total Platform Fees**
   - Your earnings from platform fees across all schools

### **Dashboard Features:**

✅ View all schools at a glance  
✅ See recent student registrations across all schools  
✅ Monitor system-wide activity  
✅ Quick access to all school management tools  
✅ Platform earnings overview  

---

## 🏫 School Management Functions

### **1. View All Schools**
**Location:** `super_admin/schools/list.php`

**Features:**
- List all schools (active and inactive)
- See each school's:
  - School name
  - Reference code (e.g., KINE, TEST)
  - Admin username
  - Student count
  - Payment count
  - Total revenue
  - Wallet balance
  - Total earnings
  - Status (Active/Suspended)

**Actions:**
- ✅ Activate school
- ✅ Suspend school
- ✅ View school details
- ✅ Edit school settings

---

### **2. Create New School**
**Location:** `super_admin/schools/create.php`

**What You Can Create:**
- School name
- Reference code (unique identifier)
- Admin account for the school
- Contact information
- Initial settings

**Process:**
1. Fill in school details
2. Create admin credentials
3. Set initial configuration
4. Activate school
5. School admin can now login and manage their school

---

### **3. View School Details**
**Location:** `super_admin/schools/view.php`

**Information Displayed:**
- School profile (name, code, status)
- Admin details (username, contact)
- Wallet information:
  - Current balance
  - Total earned
  - Total withdrawn
- School statistics:
  - Total students
  - Active students
  - Total payments
  - Revenue metrics
- School-specific settings
- Recent activity

**Actions Available:**
- Edit school information
- Manage school settings
- View payment history
- Access school's admin dashboard (impersonate)

---

### **4. Edit School**
**Location:** `super_admin/schools/edit.php`

**Editable Fields:**
- School name
- Contact information
- Admin assignment
- School status (active/inactive)
- Platform fee percentage
- Custom settings

---

## 🎯 Super Admin Privileges

### **Access Control:**

| Feature | Regular Admin | Super Admin |
|---------|--------------|-------------|
| **View own school** | ✅ Yes | ✅ Yes |
| **View all schools** | ❌ No | ✅ Yes |
| **Create schools** | ❌ No | ✅ Yes |
| **Edit any school** | ❌ No | ✅ Yes |
| **Suspend schools** | ❌ No | ✅ Yes |
| **View cross-school analytics** | ❌ No | ✅ Yes |
| **Manage platform fees** | ❌ No | ✅ Yes |
| **System health monitoring** | ❌ No | ✅ Yes |
| **Switch between schools** | ❌ No | ✅ Yes |

---

## 📈 Available Super Admin Functions

### **School Management:**

```php
// Get all schools
function getAllSchools()
// Returns: Array of all active schools

// Get school statistics
function getSchoolStats($academy_ref)
// Returns: Array with student count, payment stats, etc.

// Validate school access
function validateSchoolAccess($academy_ref)
// Returns: true for super admin (always has access)
```

### **Super Admin Checks:**

```php
// Check if user is super admin
function isSuperAdmin()
// Returns: true if user has super admin privileges

// Validate admin login
function requireAdminLogin()
// Ensures user is logged in (works for both regular and super admins)
```

---

## 🚀 Quick Actions (From Dashboard)

### **1. Create New School**
**Purpose:** Onboard a new school to your platform  
**Process:**
1. Click "Create New School"
2. Enter school details
3. Create admin account
4. School goes live immediately

### **2. Manage All Schools**
**Purpose:** View and manage all schools  
**Features:**
- List view of all schools
- Quick activate/suspend
- Edit school details
- View school dashboard

### **3. View Platform Earnings**
**Purpose:** Monitor your platform revenue  
**Shows:**
- Total platform fees collected
- Earnings by school
- Payment method breakdown
- Revenue trends

### **4. System Health**
**Purpose:** Monitor platform performance  
**Metrics:**
- System uptime
- Active schools
- Payment success rate
- Database health
- API response times

---

## 🔐 Security Features

### **Super Admin Protection:**

1. **Session-Based Authentication**
   - Secure session management
   - CSRF token protection
   - Automatic logout on inactivity

2. **Access Validation**
   - Every super admin action is validated
   - Audit trail of all actions
   - IP-based access logging

3. **Data Isolation**
   - Even super admin respects data boundaries
   - All queries filtered by academy_reference
   - Can view but follows access logs

---

## 📋 Common Super Admin Tasks

### **Daily Tasks:**
- ✅ Monitor new student registrations
- ✅ Check payment processing status
- ✅ Review platform fee collections
- ✅ Respond to school admin requests

### **Weekly Tasks:**
- ✅ Review school performance metrics
- ✅ Process withdrawal requests
- ✅ System health check
- ✅ Review and update platform settings

### **Monthly Tasks:**
- ✅ Analyze revenue trends
- ✅ Review school subscriptions
- ✅ Platform updates and maintenance
- ✅ Financial reporting

---

## 🎓 How to Use Super Admin Features

### **Accessing Super Admin Dashboard:**

1. **Login** with super admin credentials
2. If you manage a specific school, you'll see **"Super Admin"** link in the header
3. Click **"Super Admin"** to access system-wide dashboard
4. From there, you can manage all schools

### **Switching Between Schools:**

1. **From Super Admin Dashboard:**
   - Click on any school card
   - Click "Access Dashboard"
   - You're now managing that school

2. **From Regular Dashboard:**
   - If you're a super admin, you'll see "Switch School" in the header
   - Click it to go back to school selector
   - Choose another school

### **Managing Schools:**

1. **Super Admin Dashboard** → **"Manage All Schools"**
2. You'll see a list of all schools
3. Actions available:
   - **View** - See detailed school info
   - **Edit** - Modify school settings
   - **Activate/Suspend** - Control school access
   - **Delete** - Remove school (use cautiously!)

---

## 💰 Platform Fee Management

### **How Platform Fees Work:**

1. **Each payment** processed includes a platform fee
2. **Platform fee** is automatically calculated (e.g., 20% of payment)
3. **Admin earnings** = Payment amount - Platform fee
4. **Platform fees** accumulate in the super admin dashboard

### **Viewing Platform Fees:**

**Super Admin Dashboard** → **"View Platform Earnings"**

Shows:
- Total fees collected
- Fees by school
- Fees by payment method
- Monthly breakdown

---

## 🛠️ Available Reports

### **Super Admin Reports:**

1. **Platform Fees Report**
   - Location: `super_admin/reports/platform_fees.php`
   - Shows all platform fee collections

2. **System Health Report**
   - Location: `super_admin/reports/system_health.php`
   - System performance metrics

3. **Cross-School Analytics**
   - Comparative performance
   - Top performing schools
   - Revenue rankings

---

## 📝 Database Schema (Super Admin Related)

### **Tables:**

```sql
-- Academy References (Schools)
CREATE TABLE academy_references (
    id INT PRIMARY KEY AUTO_INCREMENT,
    reference_code VARCHAR(50) UNIQUE,
    academy_name VARCHAR(255),
    admin_id INT,
    is_active BOOLEAN DEFAULT 1,
    created_at TIMESTAMP
);

-- Admins (Super Admin has academy_reference = NULL)
CREATE TABLE admins (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(100) UNIQUE,
    password_hash VARCHAR(255),
    academy_reference VARCHAR(50) NULL,  -- NULL = Super Admin
    is_active BOOLEAN DEFAULT 1
);

-- Platform Fees (Your Earnings)
CREATE TABLE platform_fees (
    id INT PRIMARY KEY AUTO_INCREMENT,
    payment_id INT,
    student_id INT,
    total_amount DECIMAL(10,2),
    platform_fee DECIMAL(10,2),
    admin_earnings DECIMAL(10,2),
    academy_reference VARCHAR(50),
    created_at TIMESTAMP
);
```

---

## 🎯 Super Admin Workflow Example

### **Onboarding a New School:**

1. **Super Admin Dashboard** → **"Create New School"**
2. Fill in:
   - School Name: "Test Academy"
   - Reference Code: "TEST"
   - Admin Username: "testadmin"
   - Admin Password: (auto-generated or custom)
3. Click **"Create School"**
4. School admin receives credentials
5. School admin logs in and starts managing their school
6. You (super admin) can monitor their activity from your dashboard

---

## ✅ Best Practices

### **For Super Admins:**

1. **Regular Monitoring**
   - Check dashboard daily
   - Monitor new registrations
   - Track payment processing

2. **Security**
   - Use strong passwords
   - Enable 2FA (if implemented)
   - Regularly review access logs

3. **School Management**
   - Respond promptly to school admin requests
   - Monitor school performance
   - Provide support when needed

4. **Financial Management**
   - Review platform fees monthly
   - Process withdrawal requests timely
   - Maintain financial records

---

## 🔧 Configuration

### **Setting Super Admin:**

**In the database:**
```sql
-- Make an admin a super admin
UPDATE admins 
SET academy_reference = NULL 
WHERE username = 'your_username';
```

**Result:** This admin can now access all schools and has super admin privileges.

---

## 📞 Support

**Super Admin Features Available:**
- School management ✅
- Cross-school analytics ✅
- Platform fee tracking ✅
- System health monitoring ✅
- School creation ✅
- School editing ✅
- School suspension ✅

**Coming Soon:**
- Advanced reporting 🚧
- Email notifications 🚧
- API access 🚧
- Automated backups 🚧

---

## 🎉 Summary

As a **Super Admin**, you have complete control over your multi-tenant school management platform:

- ✅ **Manage unlimited schools**
- ✅ **Create and configure new schools**
- ✅ **Monitor system-wide performance**
- ✅ **Track platform earnings**
- ✅ **Activate/suspend schools**
- ✅ **View cross-school analytics**
- ✅ **Access any school's dashboard**
- ✅ **Complete platform oversight**

**Your platform is production-ready with full multi-tenant capabilities!** 🚀

---

**Document:** SUPER_ADMIN_FEATURES.md  
**Last Updated:** October 23, 2025  
**Status:** Complete  
**Version:** 1.0

