# SMTP Configuration Guide - Fix Email Issues

## Problem
Verification emails are not being sent to students registering on mobile devices.

## Root Cause
The SMTP password in `config.php` is not configured with your actual email password.

---

## Solution: Configure SMTP Settings

### Step 1: Open `config.php`

Find lines 10-17:

```php
// SMTP configuration - Configured for melanegroup.com
define('SMTP_HOST', 'mail.melanegroup.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'info@melanegroup.com');
define('SMTP_PASSWORD', 'your-email-password'); // ← CHANGE THIS!
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', 'info@melanegroup.com');
define('SMTP_FROM_NAME', 'Skolo-Kine Learning Platform');
```

### Step 2: Replace with Your Actual Email Password

```php
define('SMTP_PASSWORD', 'YourActualEmailPassword123!'); // Your real password
```

### Step 3: Verify SMTP Settings

Make sure these settings match your email provider:

| Setting | Current Value | Description |
|---------|---------------|-------------|
| **SMTP_HOST** | `mail.melanegroup.com` | Your mail server |
| **SMTP_PORT** | `587` | Port 587 for TLS or 465 for SSL |
| **SMTP_USERNAME** | `info@melanegroup.com` | Your email address |
| **SMTP_PASSWORD** | `your-email-password` | ⚠️ **NEEDS UPDATING** |
| **SMTP_ENCRYPTION** | `tls` | Use `tls` or `ssl` |

---

## How to Get Your SMTP Settings

### Option 1: cPanel Email Account

1. Log into your cPanel
2. Go to **Email Accounts**
3. Find `info@melanegroup.com`
4. Click **Set Up Mail Client**
5. Copy the SMTP settings:
   - **SMTP Server:** `mail.melanegroup.com` or `mail.yourdomain.com`
   - **SMTP Port:** 587 (TLS) or 465 (SSL)
   - **Username:** Full email address
   - **Password:** Your email password

### Option 2: Contact Your Hosting Provider

Ask your hosting provider for:
- SMTP server address
- SMTP port
- Authentication method
- Whether to use TLS or SSL

### Option 3: Use Gmail (Alternative)

If you want to use Gmail instead:

```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'yourname@gmail.com');
define('SMTP_PASSWORD', 'your-app-password'); // Use App Password, not regular password
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', 'yourname@gmail.com');
define('SMTP_FROM_NAME', 'Your School Name');
```

**Important for Gmail:** You need to generate an **App Password**:
1. Go to https://myaccount.google.com/apppasswords
2. Generate a new app password
3. Use that password (not your regular Gmail password)

---

## Testing Email Configuration

### Method 1: From Admin Dashboard

1. Log into admin dashboard
2. Go to **Settings**
3. Find **Email Configuration** section
4. Click **Test Email Configuration**
5. Enter your email address
6. Click **Send Test Email**
7. Check if you receive it

### Method 2: Test Registration

1. Open registration page on mobile: `/school-code/register`
2. Fill in registration form
3. Submit application
4. **Check success page:**
   - ✅ **Green box:** "Email Sent!" → Email is working!
   - ⚠️ **Yellow box:** "Email Delivery Issue" → SMTP not configured
   - If yellow box appears, you can still click the verification button to proceed

---

## Current System Behavior

**Good News:** The system now handles email failures gracefully!

### If Email WORKS:
```
Registration → Email sent → Check inbox → Click link → Continue
```

### If Email FAILS:
```
Registration → Email failed → See verification button → Click button → Continue
```

**No registration is blocked!** Students can always proceed, even if email fails.

---

## Common SMTP Errors and Solutions

### Error 1: "SMTP connect() failed"
**Solution:** Check SMTP_HOST and SMTP_PORT

### Error 2: "SMTP authentication failed"
**Solution:** Verify SMTP_USERNAME and SMTP_PASSWORD are correct

### Error 3: "Could not instantiate mail function"
**Solution:** Make sure PHPMailer is installed in `vendor/` directory

### Error 4: "Connection timed out"
**Solution:** 
- Check if port 587 or 465 is open on your server
- Try switching between port 587 (TLS) and 465 (SSL)
- Change `SMTP_ENCRYPTION` from `tls` to `ssl` or vice versa

---

## Quick Fix Checklist

- [ ] Open `config.php`
- [ ] Find `SMTP_PASSWORD` line
- [ ] Replace `'your-email-password'` with your actual password
- [ ] Save the file
- [ ] Upload to server
- [ ] Test registration on mobile
- [ ] Verify email is received

---

## Alternative: Temporary Workaround

**If you can't configure SMTP right now:**

The system will still work! Students will see a yellow warning box with a direct verification button. They can click it to proceed without needing to check email.

This allows you to:
1. ✅ Accept registrations immediately
2. ✅ Students can verify and pay
3. ✅ Fix SMTP configuration later

---

## Need Help?

1. **Check error logs:** Look in PHP error logs for specific SMTP errors
2. **Contact hosting support:** Ask them for correct SMTP settings
3. **Test with Gmail:** Use Gmail as temporary solution while fixing main email

---

## Files Updated

These files now handle email failures gracefully:

- ✅ `register_student.php` - Shows verification button if email fails
- ✅ Session stores verification link for fallback
- ✅ Better error logging for debugging

---

## Summary

**The Problem:** Email wasn't configured  
**The Solution:** Set SMTP password in config.php  
**The Backup:** Students can still register even if email fails!

**Priority:** Medium (system works without it, but email is better)

