-- ================================================================
-- ADD grade_id COLUMN TO STUDENTS TABLE
-- ================================================================
-- Run this in cPanel → phpMyAdmin → SQL tab
-- Time: 30 seconds
-- ================================================================

-- Step 1: Add the grade_id column
ALTER TABLE `students` 
ADD COLUMN `grade_id` INT(11) NULL 
COMMENT 'Primary grade for student' 
AFTER `guardian_email`,
ADD KEY `idx_grade_id` (`grade_id`);

-- Step 2: Migrate existing data from student_grades table
-- (Sets each student's grade_id to their first assigned grade)
UPDATE students s
INNER JOIN (
    SELECT student_id, MIN(grade_id) as primary_grade
    FROM student_grades
    GROUP BY student_id
) sg ON s.id = sg.student_id
SET s.grade_id = sg.primary_grade;

-- Step 3: Verify the migration worked
SELECT 
    COUNT(*) as total_students,
    COUNT(grade_id) as students_with_grade,
    COUNT(*) - COUNT(grade_id) as students_without_grade
FROM students;

-- Expected result: All 10 students should have grade_id set

-- Step 4: Check sample data
SELECT 
    s.id, 
    s.username, 
    s.full_name, 
    s.grade_id,
    g.name as grade_name
FROM students s
LEFT JOIN grades g ON s.grade_id = g.id
LIMIT 10;

-- Expected: Should show 10 students with their grade names (Form 1)

-- ================================================================
-- DONE! Now refresh your dashboard - it should work!
-- ================================================================

