# 📚 Primary School Subjects & Moodle Mapping Setup

## Overview

This guide will help you:
1. Add Primary School subjects (Grade 4-7) to your system
2. Map them to Moodle courses
3. Test that mappings are working correctly

---

## 📋 Step 1: Add Primary School Subjects

### Subjects Included:

**Grade 4 (11 subjects):**
- English Language, SiSwati Language, Mathematics
- Science, Social Studies, Religious Education
- Home Economics, Agriculture
- Art, Music, Physical Education

**Grade 5 (12 subjects):**
- English Language, SiSwati Language, Mathematics
- Science, Social Studies, Religious Education
- Home Economics, Basic Consumer Science, Agriculture
- Creative Arts, Physical Education, ICT

**Grade 6 (13 subjects):**
- English Language & Literature, SiSwati Language & Literature, Mathematics
- Science, Social Studies, Geography, History, Civics, Religious Education
- Home Economics, Agriculture
- Creative & Performing Arts, ICT / Digital Literacy

**Grade 7 (12 subjects):**
- English Language, SiSwati Language, Mathematics
- Integrated Science, Social Studies, Religious Education
- Home Economics, Agriculture
- Creative Arts, Music, Drama
- ICT / Computer Studies

**Total: 48 subjects**

---

## 🗄️ Step 2: Run SQL Script

### In phpMyAdmin:

1. **Login to phpMyAdmin**
   - Go to: https://yoursite.com:2083/cpsess.../phpMyAdmin
   - Or use XAMPP phpMyAdmin: http://localhost/phpmyadmin

2. **Select Your Database**
   - Click on your database name (e.g., `melane_multi_tenant_skoloi`)

3. **Run SQL Script**
   - Click "SQL" tab at the top
   - Copy the contents of `database/seeds/primary_school_subjects_g4_g7.sql`
   - Paste into the SQL text area
   - Click "Go"

4. **Verify Results**
   - You should see: "48 rows inserted" (or similar)
   - Check verification queries at the bottom of the script

### Alternative: Command Line

```bash
mysql -u root -p your_database < database/seeds/primary_school_subjects_g4_g7.sql
```

---

## ⚙️ Step 3: Configure Moodle Mappings

### Access Mapping Interface:

```
admin/moodle/configure_mapping.php
```

### For Each Subject:

1. **Select Subject**
   - Choose from dropdown (e.g., "English Language (Grade 4)")

2. **Map to Moodle Course**
   
   **Option A: Select from Dropdown**
   - Choose the corresponding Moodle course
   - System auto-fills shortname and ID

   **Option B: Enter Manually**
   - Course Shortname: `G4-ENG` (must match Moodle exactly)
   - Course ID Number: `G4-ENG-001` (optional)

3. **Enable Settings**
   - ✓ Auto-enroll students when subject assigned
   - ✓ Enable sync for this mapping

4. **Click "Save Mapping"**

### Example Mappings:

| Grade | Internal Subject | Moodle Course Shortname | Moodle Course Name |
|-------|------------------|-------------------------|-------------------|
| Grade 4 | English Language (Grade 4) | G4-ENG | Grade 4 English |
| Grade 4 | Mathematics (Grade 4) | G4-MATH | Grade 4 Mathematics |
| Grade 4 | Science (Grade 4) | G4-SCI | Grade 4 Science |
| Grade 5 | English Language (Grade 5) | G5-ENG | Grade 5 English |
| Grade 5 | Mathematics (Grade 5) | G5-MATH | Grade 5 Mathematics |
| ... | ... | ... | ... |

---

## ✅ Step 4: Test Your Mappings

### Access Test Interface:

```
admin/moodle/test_mappings.php
```

### What You'll See:

1. **Connection Status**
   - ✅ Green: Connected to Moodle successfully
   - ❌ Red: Connection failed (check settings)
   - ⚠️ Yellow: Moodle not enabled

2. **Statistics Dashboard**
   ```
   Total Subjects:     48
   Valid Mappings:     12
   Invalid Mappings:   3
   Unmapped Subjects:  33
   ```

3. **Subject Mapping Status Table**
   
   Each subject shows:
   - **Status Indicator** (color-coded dot)
   - **Subject Name & Code**
   - **Grades** (which grades use this subject)
   - **Moodle Course** (mapped course shortname)
   - **Verification** (does the Moodle course exist?)

4. **Available Moodle Courses**
   - Lists all courses from your Moodle
   - Search functionality
   - Shows course shortname and ID

### Status Indicators:

| Color | Status | Meaning |
|-------|--------|---------|
| 🟢 Green | **Valid** | Course exists in Moodle ✅ |
| 🔴 Red | **Invalid** | Course not found in Moodle ❌ |
| 🟡 Yellow | **Incomplete** | Mapping not fully configured ⚠️ |
| ⚪ Gray | **Unmapped** | No Moodle course assigned |

---

## 🔍 Understanding Test Results

### Valid Mapping ✅
```
Status: ✓ Valid
Subject: English Language (Grade 4) [G4-ENG-001]
Moodle Course: G4-ENG
Verification: ✓ Course found in Moodle
              Grade 4 English Language
```
**Action:** None needed - working perfectly!

---

### Invalid Mapping ❌
```
Status: ✗ Invalid
Subject: Mathematics (Grade 4) [G4-MAT-003]
Moodle Course: G4-MATH
Verification: ✗ Course ID not found in Moodle
```
**Action:** 
- Check if course exists in Moodle
- Verify spelling of course shortname
- Update mapping with correct shortname

---

### Incomplete Mapping ⚠️
```
Status: ⚠ Incomplete
Subject: Science (Grade 4) [G4-SCI-004]
Moodle Course: Not configured
Verification: ⚠ No Moodle course configured
```
**Action:**
- Go to "Configure Mappings"
- Add Moodle course for this subject
- Save mapping

---

### Unmapped Subject
```
Status: ○ Unmapped
Subject: Agriculture (Grade 4) [G4-AGR-008]
Moodle Course: —
Verification: Not mapped
```
**Action:**
- Decide if this subject needs Moodle enrollment
- If yes, create mapping
- If no, leave unmapped

---

## 🔧 Troubleshooting

### Issue 1: "Connection failed"

**Cause:** Moodle settings not configured or incorrect

**Solution:**
1. Go to: `admin/settings.php`
2. Scroll to Moodle Integration section
3. Configure:
   - Moodle URL: `https://yourschool.moodle.com`
   - Moodle Token: Your webservice token
   - Enable Moodle: ✓
4. Save settings
5. Refresh test page

---

### Issue 2: "Course not found in Moodle"

**Cause:** Moodle course shortname doesn't match

**Solution:**
1. Login to your Moodle site
2. Go to course settings
3. Note the exact **Course short name**
4. Update mapping with exact shortname (case-sensitive!)

**Example:**
- ❌ Wrong: `g4-eng` (lowercase)
- ✅ Correct: `G4-ENG` (uppercase)

---

### Issue 3: No courses showing in "Available Moodle Courses"

**Cause:** Moodle webservice token doesn't have permission

**Solution:**
1. In Moodle: Site Administration → Plugins → Web services
2. Check "Enable web services" is ON
3. Verify token has permission to:
   - `core_course_get_courses`
   - `enrol_manual_enrol_users`
4. Recreate token if needed

---

### Issue 4: Many subjects unmapped

**Cause:** Haven't created mappings yet (normal for new setup)

**Solution:**
1. Prioritize subjects used by most students
2. Map core subjects first (English, Math, Science)
3. Map additional subjects as needed
4. Not all subjects need Moodle mapping

---

## 📊 Best Practices

### 1. Naming Consistency

Use consistent naming pattern:

```
Internal:      English Language (Grade 4)
Code:          G4-ENG-001
Moodle Short:  G4-ENG
Moodle Full:   Grade 4 English Language
```

### 2. Test Before Production

1. Create mapping for ONE subject
2. Test with ONE student
3. Verify enrollment in Moodle
4. Check enrollment log
5. If successful, proceed with rest

### 3. Regular Verification

- Run test monthly
- Fix invalid mappings immediately
- Update when Moodle courses change
- Keep documentation updated

### 4. Gradual Rollout

```
Week 1: Grade 7 subjects (oldest students)
Week 2: Grade 6 subjects
Week 3: Grade 5 subjects
Week 4: Grade 4 subjects
```

---

## 🎯 Complete Setup Checklist

### Database Setup
- [ ] SQL script run successfully
- [ ] 48 subjects created
- [ ] Subjects linked to grades (Grade 4-7)
- [ ] Verified with SQL queries

### Moodle Configuration
- [ ] Moodle URL configured
- [ ] Moodle token configured
- [ ] Moodle integration enabled
- [ ] Connection test successful

### Subject Mapping
- [ ] Mapped Grade 7 core subjects (English, Math, Science)
- [ ] Mapped Grade 6 core subjects
- [ ] Mapped Grade 5 core subjects
- [ ] Mapped Grade 4 core subjects
- [ ] Mapped elective subjects (as needed)

### Testing & Verification
- [ ] Accessed test interface
- [ ] Connection status shows green
- [ ] All mapped subjects show "Valid"
- [ ] No "Invalid" mappings
- [ ] Test enrollment with one student
- [ ] Verified in Moodle LMS
- [ ] Checked enrollment log

### Production Readiness
- [ ] Trained admins on mapping interface
- [ ] Documented school-specific mappings
- [ ] Set up monitoring/alerts
- [ ] Created support workflow

---

## 📁 Files Reference

### Created Files:

1. **`database/seeds/primary_school_subjects_g4_g7.sql`**
   - SQL script to add 48 primary school subjects
   - Links subjects to Grade 4-7

2. **`admin/moodle/test_mappings.php`**
   - Visual testing interface
   - Shows mapping status
   - Lists available Moodle courses
   - Real-time verification

3. **`admin/moodle/configure_mapping.php`** (updated)
   - Added "Test Mappings" button
   - Links to test interface

---

## 🆘 Support

### Quick Links:

- **Configure Mappings:** `admin/moodle/configure_mapping.php`
- **Test Mappings:** `admin/moodle/test_mappings.php`
- **Enrollment Log:** `admin/moodle/enrollment_log.php`
- **School Settings:** `admin/settings.php`

### Common URLs:

```
Test Interface:
https://yoursite.com/Multi-Tanent/admin/moodle/test_mappings.php

Configure Mappings:
https://yoursite.com/Multi-Tanent/admin/moodle/configure_mapping.php
```

---

## 🎓 Example: Complete Setup for One Grade

Let's set up **Grade 7** as an example:

### Step 1: Verify Subjects Exist

Run SQL:
```sql
SELECT name, code FROM subjects WHERE code LIKE 'G7-%';
```

Expected: 12 subjects

### Step 2: Create Moodle Courses (in Moodle)

Create courses with these shortnames:
- `G7-ENG` - Grade 7 English
- `G7-SIS` - Grade 7 SiSwati
- `G7-MATH` - Grade 7 Mathematics
- `G7-SCI` - Grade 7 Integrated Science
- etc.

### Step 3: Map in Your System

Go to: `admin/moodle/configure_mapping.php`

Create 12 mappings:
1. English Language (Grade 7) → G7-ENG
2. SiSwati Language (Grade 7) → G7-SIS
3. Mathematics (Grade 7) → G7-MATH
4. Integrated Science (Grade 7) → G7-SCI
5. Social Studies (Grade 7) → G7-SOC
6. Religious Education (Grade 7) → G7-REL
7. Home Economics (Grade 7) → G7-HE
8. Agriculture (Grade 7) → G7-AGR
9. Creative Arts (Grade 7) → G7-CA
10. Music (Grade 7) → G7-MUS
11. Drama (Grade 7) → G7-DRA
12. ICT (Grade 7) → G7-ICT

### Step 4: Test

Go to: `admin/moodle/test_mappings.php`

Expected:
- Valid Mappings: 12
- All Grade 7 subjects: Green status
- Verification: "Course found in Moodle" ✓

### Step 5: Test with Student

1. Assign Grade 7 Math to a student
2. Check Moodle - student should be enrolled
3. Repeat for other subjects

---

**Your primary school subjects are now ready for automatic Moodle enrollment!** 🎉

For questions, check the test interface or enrollment log for detailed error messages.

