# ⚡ MOODLE INTEGRATION - QUICK SETUP

## 🎯 **5-Minute Setup Guide**

### **What This Does:**
Parent pays for subject → Student **automatically enrolled** in Moodle course!

---

## 📋 **Quick Setup Steps**

### **1. IN MOODLE (10 minutes)**

```
1. Enable Web Services
   Site Admin → Advanced Features → ✅ Enable web services

2. Enable REST Protocol
   Site Admin → Server → Web Services → Manage Protocols → ✅ REST

3. Create/Use Service
   Site Admin → Server → Web Services → External Services
   → Use "Mobile" service OR create new one

4. Add Functions to Service
   ✅ core_webservice_get_site_info
   ✅ core_user_create_users
   ✅ core_course_get_courses
   ✅ enrol_manual_enrol_users
   ✅ enrol_manual_unenrol_users

5. Create Token
   Site Admin → Server → Web Services → Manage Tokens
   → Add token → COPY IT!
   
   Example token: a1b2c3d4e5f6g7h8i9j0k1l2m3n4o5p6
```

### **2. IN YOUR SYSTEM (5 minutes)**

```
1. Import SQL
   phpMyAdmin → Import → database/ADD_MOODLE_INTEGRATION.sql → Go

2. Configure Settings
   Login as Super Admin → Settings → Moodle Section
   
   Moodle URL: https://your-moodle-site.com
   Moodle Token: [paste token from Moodle]
   ✅ Enable Moodle Integration
   
   → Test Connection → Should say "Success!"
   → Save Settings

3. Sync Courses
   Admin → Map Subjects to Moodle → Sync Courses
   
   Wait 10-30 seconds → Should see: "Synced X courses!"

4. Map Subjects
   For each subject:
   → Edit Mapping
   → Select Moodle course from dropdown
   → ✅ Auto-enroll students when they pay
   → ✅ Enable Moodle sync
   → Save
   
   Example:
   English Language (G4) → Grade 4 English
   Mathematics (G4) → Grade 4 Math
   ...etc
```

### **3. TEST IT (2 minutes)**

```
1. Parent Portal Test
   → Register as parent
   → Select child
   → Make payment for subjects
   → Complete payment
   
2. Verify in System
   SELECT * FROM moodle_enrollments 
   WHERE student_id = [test_student_id];
   
   Status should be: "enrolled"

3. Verify in Moodle
   → Go to course
   → Click Participants
   → Student should be listed!
```

---

## 🎯 **Subject Naming Convention**

To make mapping easier, use same names in both systems:

### **System Subject → Moodle Course**

```
Grade 4:
✅ English Language (G4) → ENG-G4 or "Grade 4 English"
✅ Mathematics (G4) → MAT-G4 or "Grade 4 Math"
✅ SiSwati Language (G4) → SIS-G4 or "Grade 4 SiSwati"

Grade 5:
✅ English Language (G5) → ENG-G5 or "Grade 5 English"
✅ Mathematics (G5) → MAT-G5 or "Grade 5 Math"

...etc for all grades
```

---

## 📊 **Files You Need**

```
✅ database/ADD_MOODLE_INTEGRATION.sql - Import this first
✅ includes/moodle_api.php - Auto-enrollment engine
✅ admin/moodle_mapping.php - Mapping interface
✅ parent/process_payment.php - Updated (already done)
✅ admin/settings.php - Already has Moodle config
```

---

## 🐛 **Common Issues & Fixes**

### **"Connection Failed"**
```
✓ Check Moodle URL (no trailing slash)
✓ Verify token is correct
✓ Ensure web services enabled in Moodle
✓ Check REST protocol enabled
```

### **"Student Not Enrolled"**
```sql
-- Check error:
SELECT error_message FROM moodle_enrollments 
WHERE student_id = [ID] ORDER BY created_at DESC LIMIT 1;

Common fixes:
✓ Add missing function to web service
✓ Regenerate token
✓ Check subject has Moodle mapping
✓ Verify auto-enroll is enabled
```

### **"Invalid Token"**
```
→ Go to Moodle
→ Regenerate token
→ Update in Settings
→ Save
```

---

## ✅ **Verification Queries**

```sql
-- Check Moodle config
SELECT setting_key, setting_value 
FROM tenant_settings 
WHERE setting_key LIKE 'moodle%';

-- Check subject mappings
SELECT name, code, moodle_course_name, auto_enroll, moodle_sync_enabled 
FROM subjects 
WHERE moodle_course_id IS NOT NULL;

-- Check recent enrollments
SELECT s.full_name, sub.name, me.enrollment_status, me.enrolled_at
FROM moodle_enrollments me
JOIN students s ON me.student_id = s.id
JOIN subjects sub ON me.subject_id = sub.id
ORDER BY me.created_at DESC LIMIT 10;

-- Check for errors
SELECT * FROM moodle_enrollments 
WHERE enrollment_status = 'failed'
ORDER BY created_at DESC;
```

---

## 🎉 **Success Checklist**

- [ ] Moodle token generated
- [ ] SQL schema imported
- [ ] Connection test passes
- [ ] Courses synced
- [ ] Subjects mapped
- [ ] Test payment successful
- [ ] Student appears in Moodle
- [ ] Ready for production!

---

## 📖 **Full Documentation**

For complete guide with screenshots and troubleshooting:
→ Read: `MOODLE_INTEGRATION_COMPLETE_GUIDE.md`

---

**Setup time: ~15 minutes**  
**Result: Automatic Moodle enrollment for all students! 🚀**

