# 🎓 Moodle Course Mapping System

## ✨ Features Implemented

### 1️⃣ **Fetch Courses from Moodle**
- Real-time synchronization with your Moodle LMS
- Fetches all available courses with full details
- Shows count of courses loaded
- Click "Fetch Courses" button to refresh

### 2️⃣ **Smart Course Dropdown**
- **Searchable dropdown** - Type to filter courses instantly
- Displays course full name, shortname, and ID number
- Auto-fills course details when selected
- Shows badge with total available courses

### 3️⃣ **Bulk Mapping by Grade**
- Map entire grade's subjects in one click
- Auto-matches subjects to Moodle courses by name
- Intelligent matching algorithm:
  - Matches by subject name
  - Matches by subject code
  - Case-insensitive search
- Option to enable auto-enroll for all mapped subjects

### 4️⃣ **Individual Subject Mapping**
- Map each subject manually for precise control
- Select from dropdown or enter details manually
- Configure per-mapping settings:
  - Auto-enroll students
  - Enable/disable sync
  - Store course ID, shortname, and ID number

---

## 📋 How to Use

### **Method 1: Bulk Mapping (Recommended for New Setup)**

1. **Fetch Courses**
   ```
   Click "Fetch Courses" → System loads all Moodle courses
   ```

2. **Select Grade**
   ```
   Choose grade from "Bulk Map by Grade" section
   ```

3. **Auto-Map**
   ```
   Click "Auto-Map All Subjects in Grade"
   System automatically matches subjects to courses
   ```

4. **Review Results**
   ```
   Success message shows: "Mapped X out of Y subjects"
   ```

---

### **Method 2: Individual Mapping (Precise Control)**

1. **Select Subject**
   ```
   Choose internal subject from dropdown
   ```

2. **Search Moodle Course**
   ```
   Type in search box → Dropdown filters in real-time
   Select matching Moodle course
   ```

3. **Configure Settings**
   ```
   ☑ Auto-enroll students when subject is assigned
   ☑ Enable sync for this mapping
   ```

4. **Save**
   ```
   Click "Save Mapping"
   ```

---

## 🔍 Search Functionality

The course search box filters by:
- Course full name
- Course shortname
- Course ID number

**Example:**
```
Type: "math"
Shows:
- Grade 7 Mathematics (G7-MATH)
- Grade 8 Math Advanced (G8-MATH-ADV)
- Mathematics 101 (MATH101)
```

---

## 🎯 Auto-Matching Logic

When using bulk mapping, the system matches subjects using:

1. **Exact Name Match**
   ```
   Subject: "Mathematics" → Course: "Grade 7 Mathematics"
   ```

2. **Code Match**
   ```
   Subject Code: "G7-MAT" → Course shortname: "G7-MATH"
   ```

3. **Partial Name Match**
   ```
   Subject: "English" → Course: "English Language Arts"
   ```

---

## 📊 What Gets Stored

For each mapping:
```sql
✓ academy_reference     (Your school)
✓ subject_id           (Internal subject)
✓ moodle_course_id     (Moodle course ID)
✓ moodle_course_shortname (For enrollment)
✓ moodle_course_idnumber  (Optional identifier)
✓ auto_enroll          (1 = Yes, 0 = No)
✓ sync_enabled         (1 = Active, 0 = Disabled)
✓ created_by           (Admin who created)
✓ updated_at           (Last modification)
```

---

## 🚀 Enrollment Workflow

Once mapped, here's what happens:

### **Scenario 1: Admin Assigns Subject**
```
1. Admin assigns subject to student
2. System checks mapping
3. If auto_enroll = 1 → Student enrolled in Moodle
4. Email sent to student with course link
```

### **Scenario 2: Parent Pays for Subject**
```
1. Payment confirmed for subject
2. System checks mapping
3. Student auto-enrolled in Moodle
4. Access granted immediately
```

### **Scenario 3: Manual Sync**
```
1. Go to "Sync Students" page
2. Select students to sync
3. System creates Moodle accounts
4. Enrolls in all mapped subjects
```

---

## 🛠️ Admin Actions Available

### **View Mappings**
- See all configured mappings
- Shows subject → course relationships
- Edit or delete existing mappings

### **Bulk Actions**
- Fetch latest courses from Moodle
- Bulk map entire grade
- Test all mappings
- Sync all students
- View enrollment logs

---

## ⚙️ Configuration Options

### **Per-Subject Settings**

| Setting | Description | Default |
|---------|-------------|---------|
| Auto-enroll | Automatically enroll students | ✓ On |
| Sync enabled | Enable this mapping | ✓ On |
| Course shortname | Used for enrollment API | Required |
| Course ID number | Optional identifier | Optional |

---

## 🔗 Integration Points

### **Where Mappings Are Used**

1. **Student Enrollment Handler**
   ```php
   includes/moodle_enrollment_handler.php
   ```

2. **Payment Processing**
   ```php
   process_reminder_payment.php
   webhook_payment_confirmation.php
   ```

3. **Admin Subject Assignment**
   ```php
   admin/assign_subjects.php
   ```

4. **Student Sync**
   ```php
   admin/moodle/sync_students.php
   ```

---

## 📝 Database Schema

```sql
CREATE TABLE subject_moodle_mapping (
    id INT AUTO_INCREMENT PRIMARY KEY,
    academy_reference VARCHAR(50) NOT NULL,
    subject_id INT NOT NULL,
    moodle_course_id VARCHAR(50),
    moodle_course_shortname VARCHAR(100),
    moodle_course_idnumber VARCHAR(100),
    auto_enroll TINYINT(1) DEFAULT 1,
    sync_enabled TINYINT(1) DEFAULT 1,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_subject_mapping (academy_reference, subject_id)
);
```

---

## 🎨 UI Features

### **Visual Indicators**
- 🟢 Green badge: Active mapping
- 🔴 Red badge: Sync disabled
- 📊 Count badges: Show statistics
- 🔍 Search icon: Interactive search

### **Responsive Design**
- Works on desktop, tablet, mobile
- Bootstrap 5 components
- Modern card-based layout
- Hover effects and animations

---

## 🧪 Testing

### **Test Your Mappings**
1. Go to "Test Mappings" page
2. Verify subject-course relationships
3. Check enrollment API calls
4. Review sync logs

### **Test Complete Workflow**
1. Create test student
2. Assign subject with mapping
3. Verify Moodle enrollment
4. Check course access

---

## 📞 Troubleshooting

### **No Courses Showing**
```
Solution: Click "Fetch Courses" button
Ensure Moodle credentials are configured
```

### **Bulk Mapping Found 0 Matches**
```
Reason: Course names don't match subject names
Solution: Use individual mapping for precise control
```

### **Auto-Enroll Not Working**
```
Check:
1. auto_enroll = 1 in mapping
2. Moodle API credentials valid
3. Course shortname is correct
4. Student synced to Moodle
```

---

## 🎯 Best Practices

1. **Fetch courses first** before creating mappings
2. **Use bulk mapping** for initial setup
3. **Review auto-matches** - adjust as needed
4. **Test with one subject** before bulk operations
5. **Enable auto-enroll** for seamless experience
6. **Keep course shortnames** consistent

---

## 📁 Files Modified/Created

### **Enhanced:**
- `admin/moodle/configure_mapping.php`
  - Added fetch courses button
  - Added bulk grade mapping
  - Enhanced course dropdown with search
  - Added favicon support

### **Dependencies:**
- `includes/moodle_api.php` (getCourses method)
- `includes/favicon_helper.php` (Favicon display)
- `includes/school_context.php` (Multi-tenant)

---

## 🚀 Next Steps

1. **Configure Mappings** for all grades
2. **Sync Students** to Moodle
3. **Test Enrollments** with sample students
4. **Monitor Logs** for issues
5. **Train Staff** on mapping system

---

## 📊 Statistics Dashboard

Access via: `admin/moodle/index.php`

Shows:
- Total mappings configured
- Total students synced
- Pending enrollments
- Recent sync activity

---

**System is now ready for production use! 🎉**

For support: Check logs in `logs/moodle_enrollment.log`

