-- ================================================================
-- FIX SCHOOL-ADMIN LINKS
-- Links academy_references to their corresponding admin accounts
-- ================================================================
-- Run this in cPanel → phpMyAdmin → SQL tab
-- ================================================================

-- Show current state (before fixing)
SELECT '=== CURRENT STATE - academy_references ===' as info;
SELECT 
    ar.id,
    ar.academy_name,
    ar.reference_code,
    ar.admin_id,
    a.username as linked_admin
FROM academy_references ar
LEFT JOIN admins a ON ar.admin_id = a.id
ORDER BY ar.id;

SELECT '=== CURRENT STATE - admins ===' as info;
SELECT 
    id,
    username,
    academy_reference,
    created_at
FROM admins
ORDER BY id;

-- ================================================================
-- FIX: Link schools to their admin accounts
-- ================================================================

-- Link KINE academy to its admin
UPDATE academy_references ar
JOIN admins a ON a.academy_reference = ar.reference_code
SET ar.admin_id = a.id
WHERE ar.reference_code = 'KINE' 
AND a.academy_reference = 'KINE'
AND ar.admin_id IS NULL;

-- Link TEST school to its admin
UPDATE academy_references ar
JOIN admins a ON a.academy_reference = ar.reference_code
SET ar.admin_id = a.id
WHERE ar.reference_code = 'TEST' 
AND a.academy_reference = 'TEST'
AND ar.admin_id IS NULL;

-- Link SOSHIGH school to its admin (if exists)
UPDATE academy_references ar
JOIN admins a ON a.academy_reference = ar.reference_code
SET ar.admin_id = a.id
WHERE ar.reference_code = 'SOSHIGH' 
AND a.academy_reference = 'SOSHIGH'
AND ar.admin_id IS NULL;

-- Universal fix: Link all schools to their admins automatically
UPDATE academy_references ar
JOIN admins a ON a.academy_reference = ar.reference_code
SET ar.admin_id = a.id
WHERE ar.admin_id IS NULL;

-- ================================================================
-- VERIFY: Check the links after fixing
-- ================================================================

SELECT '=== FIXED STATE - academy_references with admins ===' as info;
SELECT 
    ar.id,
    ar.academy_name,
    ar.reference_code,
    ar.admin_id,
    a.username as admin_username,
    a.academy_reference as admin_ref
FROM academy_references ar
LEFT JOIN admins a ON ar.admin_id = a.id
ORDER BY ar.id;

-- Check for any schools still without admin links
SELECT '=== Schools WITHOUT admin links (should be empty) ===' as info;
SELECT 
    ar.id,
    ar.academy_name,
    ar.reference_code,
    ar.admin_id
FROM academy_references ar
WHERE ar.admin_id IS NULL;

-- Check for any admins without schools
SELECT '=== Admins WITHOUT schools (might be super admin) ===' as info;
SELECT 
    a.id,
    a.username,
    a.academy_reference,
    ar.id as school_id,
    ar.academy_name
FROM admins a
LEFT JOIN academy_references ar ON ar.admin_id = a.id
WHERE ar.id IS NULL;

-- ================================================================
-- DONE! All schools should now be linked to their admins
-- ================================================================

SELECT '=== SUMMARY ===' as info;
SELECT 
    COUNT(*) as total_schools,
    SUM(CASE WHEN admin_id IS NOT NULL THEN 1 ELSE 0 END) as schools_with_admin,
    SUM(CASE WHEN admin_id IS NULL THEN 1 ELSE 0 END) as schools_without_admin
FROM academy_references;

