# 🔧 Fix "Create School" Error

## ❌ Error

```
Error creating school: SQLSTATE[42S22]: Column not found: 
1054 Unknown column 'admin_id' in 'INSERT INTO'
```

---

## 🔍 Root Cause

The `academy_references` table is missing columns needed for school creation:
- `admin_id` - Links school to admin account
- `academy_name` - School name
- `is_active` - Active status
- `created_at` - Creation timestamp

---

## ✅ Quick Fix (2 Minutes)

### **Run This SQL Script:**

**File:** `FIX_ACADEMY_REFERENCES_TABLE.sql`

**Steps:**
1. **phpMyAdmin → SQL tab**
2. **Copy entire script** from `FIX_ACADEMY_REFERENCES_TABLE.sql`
3. **Paste and click "Go"**
4. **Adds all missing columns** ✅

---

## 📊 What Gets Added

```sql
ALTER TABLE academy_references 
ADD COLUMN admin_id INT(11) NULL;

ALTER TABLE academy_references 
ADD COLUMN academy_name VARCHAR(255) NOT NULL DEFAULT 'New School';

ALTER TABLE academy_references 
ADD COLUMN is_active TINYINT(1) DEFAULT 1;

ALTER TABLE academy_references 
ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
```

---

## ✅ Expected Table Structure (After Fix)

```
Field            | Type          | Null | Key | Default
-----------------|---------------|------|-----|-------------
id               | int(11)       | NO   | PRI | NULL (auto_increment)
reference_code   | varchar(50)   | NO   | UNI | NULL
admin_id         | int(11)       | YES  | MUL | NULL
academy_name     | varchar(255)  | NO   |     | 'New School'
is_active        | tinyint(1)    | YES  |     | 1
created_at       | timestamp     | YES  |     | CURRENT_TIMESTAMP
```

---

## 🚀 Test Creating School

**After running the fix:**

1. **Login as super admin**
   - URL: `/admin/login.php`
   - Use: `superadmin` / `SuperAdmin123!`
   - Or: `admin` / `admin123`

2. **Click "Super Admin"** in navigation

3. **Click "Create New School"**

4. **Fill in form:**
   ```
   School Name: Rainbow Academy
   Reference Code: RAINBOW
   Admin Email: admin@rainbow.com
   Admin Password: Rainbow123!
   ```

5. **Click "Create School"**

6. **Should see:** ✅ "School created successfully!"

---

## 🎯 Troubleshooting

### **If you still get errors about other missing columns:**

**Run this diagnostic:**

```sql
-- Check what columns exist
DESCRIBE academy_references;

-- Check what columns are expected
SHOW CREATE TABLE academy_references;
```

**Compare with expected structure above.**

---

### **If you see "Duplicate column name" errors:**

**That's OK!** It means the column already exists. The script handles this gracefully.

---

## 📝 Complete Setup Checklist

**For full super admin functionality:**

- [ ] Run `CREATE_SUPERADMIN_SIMPLE.sql` - Creates super admin account
- [ ] Run `FIX_ACADEMY_REFERENCES_TABLE.sql` - Fixes school creation ← **Do this now!**
- [ ] Upload `includes/functions.php` - Database authentication
- [ ] Upload `includes/school_context.php` - Session fixes
- [ ] Upload `admin/logout.php` - Logout fixes
- [ ] Clear browser cache
- [ ] Login as super admin
- [ ] Test creating school
- [ ] **Success!** ✅

---

## 🎉 After Fix

**You can:**
- ✅ Create unlimited schools
- ✅ Set school name and reference code
- ✅ Auto-create admin accounts for schools
- ✅ Manage all schools from super admin panel
- ✅ Switch between schools
- ✅ View cross-school analytics

---

**Document:** FIX_CREATE_SCHOOL_ERROR.md  
**Status:** ✅ Solution Ready  
**File:** FIX_ACADEMY_REFERENCES_TABLE.sql  
**Time:** 2 minutes  
**Result:** School creation works! 🎉

