# 📋 cPanel Deployment Checklist

## Quick Reference - Check off as you go!

---

## 🗄️ DATABASE SETUP

- [ ] Export local database (`multi_tenant_skoloi`)
- [ ] File saved: `multi_tenant_database.sql`
- [ ] cPanel → MySQL Databases
- [ ] Create database: `cpanelusername_skolokine_multi`
- [ ] Create user: `cpanelusername_skolokine_admin`
- [ ] Generate strong password
- [ ] Add user to database (ALL PRIVILEGES)
- [ ] Note database name: `_________________`
- [ ] Note username: `_________________`
- [ ] Note password: `_________________`

---

## 📦 FILE UPLOAD

- [ ] Create ZIP: `skolokine-multitenant-v2.zip`
- [ ] cPanel → File Manager
- [ ] Navigate to `public_html/`
- [ ] Create folder: `skolokine` (optional)
- [ ] Upload ZIP file
- [ ] Extract ZIP
- [ ] Verify folders: admin/, includes/, images/, etc.
- [ ] Delete ZIP file

---

## ⚙️ CONFIGURATION

- [ ] Edit `config.php`
- [ ] Update DB_HOST to: `localhost`
- [ ] Update DB_NAME to: `cpanelusername_skolokine_multi`
- [ ] Update DB_USER to: `cpanelusername_skolokine_admin`
- [ ] Update DB_PASS to: `[generated password]`
- [ ] Update PUBLIC_BASE_URL to: `https://yourdomain.com/skolokine`
- [ ] Update SMTP settings (email configuration)
- [ ] Set APP_DEBUG to: `false`
- [ ] Set display_errors to: `0`
- [ ] Save config.php

---

## 🗄️ DATABASE IMPORT

- [ ] cPanel → phpMyAdmin
- [ ] Select database
- [ ] Click "Import"
- [ ] Choose file: `multi_tenant_database.sql`
- [ ] Click "Go"
- [ ] Wait for import (may take 1-2 min)
- [ ] Success message appears
- [ ] Verify tables exist (36 tables)
- [ ] Run: `SELECT COUNT(*) FROM academy_references;` → Should return 2
- [ ] Run: `SELECT COUNT(*) FROM students;` → Should return 10

---

## 🔐 SECURITY

- [ ] Change admin password in database
- [ ] Generate new hash: `password_hash('NewPassword', PASSWORD_DEFAULT)`
- [ ] Update admins table password_hash
- [ ] Create `.htaccess` file (see deployment guide)
- [ ] Protect config.php
- [ ] Protect database/ folder
- [ ] Protect includes/ folder
- [ ] Enable HTTPS redirect
- [ ] Disable directory listing
- [ ] Set folder permissions: 755
- [ ] Set file permissions: 644
- [ ] Secure sensitive folders

---

## 🧪 TESTING

- [ ] Create `test_connection.php` on server
- [ ] Visit: `https://yourdomain.com/skolokine/test_connection.php`
- [ ] Should show: "Database connected successfully!"
- [ ] Delete `test_connection.php`
- [ ] Visit: `https://yourdomain.com/skolokine/admin/login.php`
- [ ] Login with new credentials
- [ ] School selector appears
- [ ] Select KINE Academy
- [ ] Dashboard loads with 5 students
- [ ] Click "School Settings" → Loads
- [ ] Click "Dashboard" → Returns to dashboard
- [ ] Click "Switch School" → Works
- [ ] Select TEST School → Different 5 students visible
- [ ] Click "Logout" → Logs out
- [ ] All navigation links work ✅

---

## 📧 EMAIL SETUP

- [ ] cPanel → Email Accounts
- [ ] Create: `noreply@yourdomain.com`
- [ ] Note password
- [ ] Update config.php SMTP settings
- [ ] Test email sending
- [ ] Verify emails arrive

---

## ⏰ CRON JOBS (Optional)

- [ ] cPanel → Cron Jobs
- [ ] Add: Daily backup (2 AM)
- [ ] Add: Email queue (Every 5 min)
- [ ] Add: System health (Hourly)
- [ ] Add: Payment check (Daily 8 AM)
- [ ] Verify cron path is correct

---

## 🔒 SSL CERTIFICATE

- [ ] cPanel → SSL/TLS Status
- [ ] Run AutoSSL for your domain
- [ ] Wait for installation
- [ ] Test: Visit `http://yourdomain.com`
- [ ] Should redirect to `https://`
- [ ] Green padlock appears in browser

---

## 🎯 FINAL VERIFICATION

- [ ] https:// works (SSL active)
- [ ] Login page loads
- [ ] Can login with new password
- [ ] School selector shows 2 schools
- [ ] Dashboard loads
- [ ] Students visible (5 in KINE, 5 in TEST)
- [ ] Payments visible (2 in each school)
- [ ] Navigation links work from all pages
- [ ] School settings loads and saves
- [ ] Can switch between schools
- [ ] Data perfectly isolated
- [ ] No errors in logs
- [ ] Mobile responsive
- [ ] Fast page loads

---

## 🧹 CLEANUP

- [ ] Delete test files from server:
  - [ ] test_connection.php
  - [ ] test_page_access.php
  - [ ] seed_test_students.php
  - [ ] Any other test_*.php files

- [ ] Remove documentation (optional):
  - [ ] All .md files (or keep for reference)
  
- [ ] Clear logs/:
  - [ ] Remove old log files

---

## 📊 POST-DEPLOYMENT

### **Day 1**
- [ ] Monitor error logs
- [ ] Test all features
- [ ] Fix any issues immediately
- [ ] Verify performance

### **Week 1**
- [ ] Create backup
- [ ] Test student registration flow
- [ ] Test payment processing
- [ ] Verify email delivery
- [ ] Check database performance

### **Month 1**
- [ ] Onboard first real school
- [ ] Monitor revenue
- [ ] Gather feedback
- [ ] Plan improvements

---

## 🎊 SUCCESS INDICATORS

### **Technical Success:**
- ✅ Uptime: 99.9%
- ✅ Page load: < 2 seconds
- ✅ No critical errors
- ✅ Database queries < 100ms

### **Business Success:**
- ✅ Schools onboarded: 1+
- ✅ Revenue generated: E1+
- ✅ User satisfaction: High
- ✅ System stable

---

## 📞 Support

**If you need help during deployment:**
- Email: info@melanegroup.com
- Phone: +268 7687 3207
- Documentation: See CPANEL_DEPLOYMENT_GUIDE_MULTI_TENANT.md

---

## 🎯 Quick Steps Summary

```
1. Export database             ✅
2. ZIP files                   ✅
3. Create cPanel database      ⏳
4. Upload files                ⏳
5. Edit config.php             ⏳
6. Import database             ⏳
7. Test login                  ⏳
8. Verify all features         ⏳
9. Secure system               ⏳
10. Go live!                   🎉
```

---

## 🚀 You're Ready to Deploy!

**Estimated Time:** 45-60 minutes  
**Difficulty:** Medium (with this guide: Easy!)  
**Result:** Live multi-tenant SaaS platform!  

---

**Let's make it happen!** 🚀

**Good luck!** 🍀

---

**Print this checklist and check off items as you complete them!** ✓

