# 🗄️ Database Upload Instructions for cPanel

## ✅ Your Complete Database File is Ready!

**File:** `COMPLETE_DATABASE_FOR_CPANEL.sql`

This file contains **EVERYTHING** you need - no need to export from XAMPP!

---

## 📊 What's Inside This Database

### **Complete Multi-Tenant System:**
- ✅ **36 Tables** (all systems included)
- ✅ **2 Schools** (KINE Academy, TEST School)
- ✅ **10 Students** (5 per school)
- ✅ **7 Sample Payments** (with revenue split)
- ✅ **Default Grades & Subjects** (Form 1-5)
- ✅ **Multi-Tenant Settings** (school configurations)
- ✅ **Super Admin Account** (ready to use)
- ✅ **Production Ready** (all indexes, constraints)

---

## 🚀 How to Upload to cPanel (5 minutes)

### **Step 1: Access cPanel**
```
Login to: https://yourdomain.com:2083
or: https://yourdomain.com/cpanel
```

### **Step 2: Create Database**

1. Click **"MySQL Databases"**
2. **Create Database:**
   - Name: `skolokine_multi` (or your choice)
   - Click "Create Database"
3. **Note the full name:** `cpanelusername_skolokine_multi`
   - ✍️ Write it down: _______________________

### **Step 3: Create Database User**

1. Scroll to **"MySQL Users"**
2. **Create User:**
   - Username: `skolokine_admin`
   - Password: Generate strong password (click generator)
   - Click "Create User"
3. **Copy and save:**
   - ✍️ Username: cpanelusername_skolokine_admin
   - ✍️ Password: _______________________

### **Step 4: Add User to Database**

1. Scroll to **"Add User to Database"**
2. Select:
   - User: `cpanelusername_skolokine_admin`
   - Database: `cpanelusername_skolokine_multi`
3. Click **"Add"**
4. **Check "ALL PRIVILEGES"**
5. Click **"Make Changes"**

### **Step 5: Import Database File**

**Option A: Via phpMyAdmin (Recommended)**

1. Back in cPanel, click **"phpMyAdmin"**
2. In left sidebar, click your database: `cpanelusername_skolokine_multi`
3. Click **"Import"** tab at top
4. Click **"Choose File"**
5. Select: `COMPLETE_DATABASE_FOR_CPANEL.sql`
6. Scroll down, click **"Go"**
7. Wait 30-60 seconds
8. ✅ Success message: "Import has been successfully finished"

**Option B: If File is Too Large**

If phpMyAdmin rejects the file (usually over 50MB):

1. Go to cPanel → **File Manager**
2. Navigate to: `/home/username/` (your home directory)
3. Create folder: `temp_upload`
4. Upload `COMPLETE_DATABASE_FOR_CPANEL.sql` there
5. In phpMyAdmin, use "Import from server" option
6. Or compress to .zip first, then import

---

## ✅ Verify Import Success

### **In phpMyAdmin, check:**

1. **Left sidebar should show 36 tables:**
   ```
   ✅ admins
   ✅ academy_references
   ✅ activity_log
   ✅ admin_wallet
   ✅ api_keys
   ✅ deleted_students
   ✅ email_logs
   ✅ email_queue
   ✅ grade_subjects
   ✅ grades
   ✅ login_attempts
   ✅ moodle_sync_log
   ✅ password_resets
   ✅ payment_cycles
   ✅ payments
   ✅ platform_fees
   ✅ student_grades
   ✅ students
   ✅ subjects
   ✅ system_health_log
   ✅ tenant_settings
   ✅ wallet_transactions
   ✅ withdrawal_requests
   ... and more!
   ```

2. **Run verification queries:**

**Check Schools:**
```sql
SELECT * FROM academy_references;
```
**Expected:** 2 rows (KINE, TEST)

**Check Students:**
```sql
SELECT academy_reference, COUNT(*) as students 
FROM students 
GROUP BY academy_reference;
```
**Expected:** KINE = 5, TEST = 5

**Check Payments:**
```sql
SELECT academy_reference, COUNT(*) as payments, SUM(amount) as total
FROM payments 
GROUP BY academy_reference;
```
**Expected:** KINE = 4 payments (E1,400), TEST = 3 payments (E900)

**Check Admin:**
```sql
SELECT username, academy_reference FROM admins;
```
**Expected:** admin (NULL - super admin)

---

## 📝 Login Credentials After Import

### **Super Admin (Full Access):**
```
Username: admin
Password: admin123

⚠️ CHANGE THIS PASSWORD IMMEDIATELY AFTER FIRST LOGIN!
```

### **Test Students (For Testing):**
```
Usernames: alice2024, bob2024, charlie2024, diana2024, edward2024
           frank2024, grace2024, henry2024, isabel2024, james2024
Password: StudentPass123! (all students)
```

### **Schools Available:**
```
1. KINE Academy (reference: KINE)
   - 5 students
   - 4 payments (E1,400 total)
   
2. TEST School (reference: TEST)
   - 5 students
   - 3 payments (E900 total)
```

---

## 🔐 IMPORTANT: Change Admin Password

**After import, IMMEDIATELY change the admin password!**

### **Method 1: Via phpMyAdmin**

1. In phpMyAdmin, click `admins` table
2. Click "Browse" tab
3. Find row where `username` = 'admin'
4. Click "Edit" (pencil icon)
5. Generate new password hash:
   - Use: https://bcrypt-generator.com/
   - Enter your new secure password
   - Copy the hash
6. Paste in `password_hash` field
7. Click "Go"

### **Method 2: Via SQL**

```sql
-- Generate hash at: https://bcrypt-generator.com/
-- Then run:
UPDATE admins 
SET password_hash = '$2y$10$[YOUR_NEW_HASH_HERE]'
WHERE username = 'admin';
```

✍️ **Write your new password:** _______________________

---

## 🎯 Database Statistics

### **What You're Getting:**

**Tables:** 36 total
- Core: 7 tables (admins, students, grades, subjects, etc.)
- Payments: 4 tables (payments, cycles, fees, wallet)
- Multi-Tenant: 2 tables (academy_references, tenant_settings)
- Email: 3 tables (logs, queue, password_resets)
- Security: 4 tables (activity_log, login_attempts, api_keys, health)
- Supporting: 16 other tables

**Data:**
- 2 schools
- 10 students
- 7 payments
- 5 grades (Form 1-5)
- 10 subjects
- School-specific settings

**Size:**
- File size: ~100-150 KB
- Import time: 30-60 seconds
- Rows: ~100+ total

---

## ✅ Post-Import Checklist

After successful import:

- [ ] 36 tables visible in phpMyAdmin
- [ ] `academy_references` has 2 rows
- [ ] `students` has 10 rows
- [ ] `payments` has 7 rows
- [ ] `admins` has 1 row (super admin)
- [ ] `grades` has 5 rows
- [ ] `subjects` has 10 rows
- [ ] `tenant_settings` has settings for both schools
- [ ] All foreign keys created (no errors)
- [ ] Admin password changed ⚠️

---

## 🚨 Troubleshooting

### **Issue: Import timeout**
**Solution:** 
- Compress file to .zip first
- Or upload via File Manager
- Or increase phpMyAdmin timeout in cPanel

### **Issue: "Table already exists"**
**Solution:**
- Database file includes `DROP TABLE IF EXISTS`
- It will clean and recreate everything
- Safe to re-import

### **Issue: Foreign key errors**
**Solution:**
- Database automatically handles foreign keys
- If issues, the file sets `FOREIGN_KEY_CHECKS = 0` during import

### **Issue: Can't find database in phpMyAdmin**
**Solution:**
- Refresh phpMyAdmin
- Check you selected correct database in left sidebar
- Verify database was created in Step 2

---

## 🎊 Success Indicators

### **Import Successful When:**

✅ phpMyAdmin shows: "Import has been successfully finished, X queries executed."  
✅ Left sidebar shows 36 tables  
✅ No error messages in red  
✅ Can browse tables and see data  
✅ Verification queries return correct counts  

---

## 📞 Next Steps After Import

### **1. Update config.php**
Edit your `config.php` file with database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'cpanelusername_skolokine_multi');
define('DB_USER', 'cpanelusername_skolokine_admin');
define('DB_PASS', 'YourGeneratedPassword');
```

### **2. Test Login**
Visit: `https://yourdomain.com/skolokine/admin/login.php`
```
Username: admin
Password: admin123 (or your new password)
```

### **3. Verify Multi-Tenant**
- Login → School selector should appear
- Shows: KINE Academy (5 students), TEST School (5 students)
- Select KINE → Dashboard shows 5 KINE students
- Switch to TEST → Dashboard shows 5 TEST students

### **4. Test All Features**
- Create new student
- View payments
- Access settings
- Switch schools
- Verify data isolation

---

## 💡 Pro Tips

### **Tip 1: Keep the File**
- Save `COMPLETE_DATABASE_FOR_CPANEL.sql` as backup
- Easy to re-deploy if needed
- Quick database reset option

### **Tip 2: Test Locally First**
If you want to test import locally:
```
1. phpMyAdmin → Create new database: test_import
2. Import COMPLETE_DATABASE_FOR_CPANEL.sql
3. Verify everything works
4. Then import to cPanel
```

### **Tip 3: Clean Import**
- Database file automatically drops existing tables
- Creates fresh structure
- No conflicts with old data

### **Tip 4: Check Size**
```
File size: ~100-150 KB
phpMyAdmin limit: Usually 50MB
✅ No issues with upload size!
```

---

## 🎯 Quick Import Summary

```
1. Login to cPanel                        (1 min)
2. Create database + user                 (2 min)
3. Import COMPLETE_DATABASE_FOR_CPANEL.sql (1 min)
4. Verify 36 tables exist                 (30 sec)
5. Change admin password                  (1 min)
6. Update config.php                      (1 min)
7. Test login                             (30 sec)

Total: 7 minutes to working database! ⚡
```

---

## 🎉 You're Ready!

### **You Have:**
✅ Complete production database  
✅ No XAMPP export needed  
✅ Multi-tenant ready  
✅ Test data included  
✅ All systems configured  
✅ Ready to import!  

### **Just:**
1. Open cPanel
2. Create database
3. Import this file
4. Done!

---

**File to upload:** `COMPLETE_DATABASE_FOR_CPANEL.sql`

**Next step:** Open `CPANEL_DEPLOYMENT_GUIDE_MULTI_TENANT.md` for complete deployment instructions!

---

🚀 **Let's get your database live!** 🚀

---

**Document:** DATABASE_UPLOAD_INSTRUCTIONS.md  
**Database File:** COMPLETE_DATABASE_FOR_CPANEL.sql  
**Version:** 2.0 Multi-Tenant  
**Status:** ✅ Ready for cPanel Import  
**Size:** ~100-150 KB  
**Tables:** 36  
**Data:** Production ready with test data  

