# cPanel Installation Guide (All Modules) — `/Multi-Tanent/`

This document is the **single source of truth** for installing the full system to **cPanel shared hosting** under the folder **`/Multi-Tanent/`**, including:

- Core school management (multi-tenant)
- Moodle integration
- Payments (MTN MoMo; card payments are present but PayGate is currently disabled until credentials are correct)
- Email (SMTP)
- SMS (Africa’s Talking or Twilio)
- Wallet + withdrawals (MTN MoMo Disbursement API)
- Payment reminders + suspension (cron-driven, with Moodle suspension)

If you want “everything to work”, you must have **real production credentials** for each external provider and your host must allow outbound HTTPS requests.

---

## 1) Hard truth prerequisites (avoid predictable failures)

### Server requirements
- **Apache + `.htaccess` enabled** (AllowOverride ON), **`mod_rewrite` enabled**
- PHP **7.4+** (you are on **8.2**, which is fine for the app)
- MySQL **5.7+** (8.0+ recommended)
- PHP extensions: **pdo_mysql, openssl, curl, mbstring, fileinfo, zip**
- HTTPS certificate installed (cPanel AutoSSL is fine)

### PHP 8.2 note (important)
- The app codebase is compatible with modern PHP patterns, but **PHP 8.2 can surface deprecation notices**.
- Your repo `config.php` currently enables `display_errors=1` (development mode). On production, keep errors **logged** but **not displayed**.
- Dev tooling note: `phpunit/phpunit` is a dev dependency; you typically **won’t run PHPUnit on shared hosting**. If you do, ensure the PHPUnit version supports PHP 8.2.

### Outbound network requirements (often overlooked)
Your cPanel host must allow outbound HTTPS to:
- MTN MoMo API endpoints (Collection + Disbursement)
- Moodle site (REST web services endpoint)
- SMTP server (ports **587 TLS** or **465 SSL**)
- SMS provider APIs (Africa’s Talking / Twilio)

If outbound connections are blocked, modules will “install” but fail at runtime.

### Secrets & security
Your `config.php` contains sensitive values. In production:
- Ensure **`/Multi-Tanent/config.php` is NOT web-accessible** (should return 403; `.htaccess` already blocks it).
- Prefer **rotating** credentials before go-live if they’ve ever been shared.

---

## 1.1) Recommended PHP settings in cPanel (before upload)

Set these via cPanel **MultiPHP INI Editor** (or **Select PHP Version → Options**), for the domain/subdomain hosting `/Multi-Tanent/`:

### Production error handling (safe defaults)
- `display_errors = Off`
- `log_errors = On`
- `error_reporting = E_ALL` (or `E_ALL & ~E_DEPRECATED` if logs get too noisy on PHP 8.2)
- `date.timezone = Africa/Mbabane` (or your correct timezone)

### Runtime limits (reduce timeouts during imports/sync)
- `memory_limit = 256M`
- `max_execution_time = 120`
- `max_input_time = 120`

### Upload limits (adjust to your needs)
- `upload_max_filesize = 20M` (or more)
- `post_max_size = 25M` (must be ≥ upload_max_filesize)
- `max_file_uploads = 20`

### Form input size (helps large admin forms)
- `max_input_vars = 3000`

### TLS/CA certificates (avoids random cURL SSL failures)
- Ensure your host has a valid CA bundle configured (common on cPanel). If you see cURL SSL verify errors, ask hosting support to confirm `curl.cainfo` / system CA certificates are configured.

---

## 2) Create the database in cPanel

1. cPanel → **MySQL Databases**
2. Create a database (example): `cpaneluser_skolokine_multi`
3. Create a user (example): `cpaneluser_skolokine_admin`
4. Add user to database with **ALL PRIVILEGES**
5. Write down:
   - DB Name (full prefixed name)
   - DB User (full prefixed name)
   - DB Password

---

## 3) Upload files to `/public_html/Multi-Tanent/`

### Recommended approach (fastest on shared hosting)
1. cPanel → **File Manager** → `public_html/`
2. Create folder: `Multi-Tanent`
3. Upload your project ZIP (or upload folders/files directly) and **Extract**
4. Upload **dependencies**:
   - If your host cannot run Composer: upload `vendor.zip` and extract into `/public_html/Multi-Tanent/vendor/`
   - Verify: `/public_html/Multi-Tanent/vendor/autoload.php` exists

### Critical: show hidden files
Enable **Show Hidden Files** in File Manager and confirm:
- `/public_html/Multi-Tanent/.htaccess` exists
- Directory protection files exist (recommended):
  - `/Multi-Tanent/includes/.htaccess`
  - `/Multi-Tanent/vendor/.htaccess`
  - `/Multi-Tanent/uploads/.htaccess`
  - `/Multi-Tanent/database/.htaccess`
  - `/Multi-Tanent/logs/.htaccess`

---

## 4) Configure `config.php` for production (must-do)

Edit `/public_html/Multi-Tanent/config.php`:

### Database
- Set:
  - `DB_HOST` = `localhost`
  - `DB_NAME` = your prefixed DB name
  - `DB_USER` = your prefixed DB user
  - `DB_PASS` = your DB password

### Base URL
- Set:
  - `PUBLIC_BASE_URL` = `https://YOURDOMAIN/Multi-Tanent`

### Disable debug output (production hygiene)
- Set:
  - `APP_DEBUG` = `false`
  - `ini_set('display_errors', 0)`
  - keep `ini_set('log_errors', 1)` enabled

### MTN MoMo callback path (important)
The MoMo request flow in `includes/functions.php` sends `X-Callback-Url` using `MOMO_CALLBACK_PATH`.

Because your `.htaccess` does **not** rewrite `/payments/...` to `.php`, set:
- `MOMO_CALLBACK_PATH` = `/payments/mtn/callback.php`

This ensures MoMo callbacks reach the real file:
- `https://YOURDOMAIN/Multi-Tanent/payments/mtn/callback.php`

---

## 5) Import the database schema (core + modules)

### Option A (recommended): import a known-good full DB
If your local system is correct, export from local and import into cPanel phpMyAdmin.

### Option B: build the DB from repo SQL (core first, then modules)
1. Import core schema:
   - `database/schema.sql`

2. Import module schemas (only if you are enabling that module):
   - **SMS**: `database/migrations/create_sms_tables.sql`
   - **Wallet + withdrawals**: `database/create_wallet_system.sql`
   - **Moodle integration**: `database/ADD_MOODLE_INTEGRATION.sql`
   - **Payment reminders + views**:
     - `database/migrations/create_payment_reminder_system_FIXED.sql`
     - `database/migrations/create_payment_views.sql`
   - **Grades/subjects (if using primary grades)**:
     - `database/seeds/add_primary_grades.sql`
     - `database/seeds/primary_school_subjects_g4_g7.sql`
   - **School grade selection**:
     - `database/migrations/create_school_grades_table.sql`

After imports, verify required tables exist (examples):
- Wallet tables: run `/Multi-Tanent/verify_wallet_tables.php`
- SMS tables: query `sms_logs`, `sms_verifications`
- Moodle tables: query `moodle_enrollments`, `moodle_sync_log`

---

## 6) Create writable directories + set permissions

In File Manager, ensure these exist and are writable:
- `/Multi-Tanent/logs/`
- `/Multi-Tanent/uploads/`
- `/Multi-Tanent/cache/` (if used)
- `/Multi-Tanent/exports/`
- `/Multi-Tanent/backups/`

Typical permissions:
- Folders: **755** (use **775** if writes fail on your host)
- Files: **644**

---

## 7) Configure each module (credentials + switches)

### 7.1 Email (SMTP)
1. cPanel → **Email Accounts** → create an email (recommended): `noreply@YOURDOMAIN`
2. In `config.php`, set:
   - `SMTP_HOST`, `SMTP_PORT`, `SMTP_USERNAME`, `SMTP_PASSWORD`, `SMTP_ENCRYPTION`
3. Verify:
   - If you have a test page/button in admin settings, use it
   - Or confirm during a real flow (registration email / payment email)

Reference: `SMTP_CONFIGURATION_GUIDE.md`

### 7.2 SMS (Africa’s Talking / Twilio)
1. In `config.php`:
   - `SMS_ENABLED = true`
   - Choose provider: `SMS_PROVIDER = 'africastalking'` or `twilio`
   - Fill provider credentials (AT_* or TWILIO_*)
2. Ensure DB tables exist:
   - `database/migrations/create_sms_tables.sql`
3. Verify:
   - Visit: `/Multi-Tanent/check_sms_config.php` and send a test SMS

Reference: `SMS_SETUP_GUIDE.md`

### 7.3 Payments (MTN MoMo Collection)
1. In `config.php`, confirm Collection credentials:
   - `MOMO_ENV` (sandbox vs production)
   - `MOMO_COLLECTION_SUBSCRIPTION_KEY`
   - `MOMO_API_USER_ID`
   - `MOMO_API_KEY`
   - `MOMO_COLLECTION_BASE_URL`
2. Set callback path correctly (see Step 4):
   - `MOMO_CALLBACK_PATH = '/payments/mtn/callback.php'`
3. Verify endpoints exist:
   - `/Multi-Tanent/payments/mtn/request.php`
   - `/Multi-Tanent/payments/mtn/status.php`
   - `/Multi-Tanent/payments/mtn/callback.php`

Verification:
- Run: `/Multi-Tanent/tools/test_momo_payments.php` (temporary)
- Confirm `logs/momo_callback.log` updates after a payment callback

### 7.4 Card payments (PayGate) — currently not production-ready by default
In `config.php`:
- `PAYGATE_ENABLED` is **false** and the repo notes current credentials are not the correct PayWeb 3 ID format.

To enable card payments you must:
- Obtain correct PayGate PayWeb3 credentials
- Set `PAYGATE_ENABLED = true`
- Set `PAYGATE_TEST_MODE` appropriately

Reference: `PAYGATE_CREDENTIALS_ISSUE.md` and `PAYMENT_SYSTEM_COMPLETE_SUMMARY.md`

### 7.5 Wallet + withdrawals (MoMo Disbursement)
Reality-check: Withdrawals require **MTN MoMo Disbursement API** credentials (separate subscription from Collection).

1. Import DB schema:
   - `database/create_wallet_system.sql`
2. In `config.php`, set:
   - `PLATFORM_FEE_FIXED`, `PLATFORM_MOMO_NUMBER`, `PLATFORM_ADMIN_ID`
   - `MOMO_DISBURSEMENT_SUBSCRIPTION_KEY`
   - `MOMO_DISBURSEMENT_BASE_URL`
   - `MOMO_DISBURSEMENT_USER_ID`
   - `MOMO_DISBURSEMENT_API_KEY`
3. Verify:
   - `/Multi-Tanent/verify_wallet_tables.php`
   - Admin withdrawal endpoint: `/Multi-Tanent/admin/request_withdrawal.php` (called from UI)

Important: Without valid Disbursement credentials, withdrawals will fail (and the code will attempt to refund).

### 7.6 Moodle integration (auto-enrollment + suspension)
1. In Moodle (as Moodle admin):
   - Enable Web Services
   - Enable REST protocol
   - Create an external service and token
   - Add required functions (see `MOODLE_INTEGRATION_COMPLETE_GUIDE.md`)
2. In your system:
   - Import `database/ADD_MOODLE_INTEGRATION.sql`
   - Configure Moodle URL + token in the system settings (or DB, depending on your admin UI)
3. Verify:
   - `/Multi-Tanent/admin/moodle/test_connection.php`
   - `/Multi-Tanent/test_moodle_functions.php`

### 7.7 Payment reminders + Moodle suspension (cron-driven)
1. Import:
   - `database/migrations/create_payment_reminder_system_FIXED.sql`
   - `database/migrations/create_payment_views.sql`
2. Run once:
   - `/Multi-Tanent/initialize_payment_system.php` (if present/used in your environment)
3. Add cPanel cron (daily, example 08:00):
   - `/usr/bin/php /home/CPANELUSER/public_html/Multi-Tanent/cron/payment_reminder_cron.php`
4. Verify:
   - `/Multi-Tanent/test_payment_reminder.php`
   - DB tables: `payment_reminders`, `student_payment_schedules`, `tenant_payment_settings`

---

## 8) Post-install verification (PASS/FAIL checklist)

### Core school management (multi-tenant)
- [ ] Admin login works: `/Multi-Tanent/admin/login.php`
- [ ] Super admin area works (if enabled): `/Multi-Tanent/super_admin/...`
- [ ] School creation works (creates default settings + wallet)
- [ ] Tenant isolation: School A cannot see School B students/payments/settings
- [ ] Clean URLs work for admin/super_admin/parent/student pages (no `.php` required)

### Email
- [ ] Registration/verification emails deliver
- [ ] Payment success/failure emails deliver
- [ ] No SMTP auth errors in cPanel error logs

### SMS
- [ ] `/Multi-Tanent/check_sms_config.php` shows configured and can send test SMS
- [ ] `sms_logs` records success

### Payments (MoMo)
- [ ] Payment request triggers prompt on phone
- [ ] Callback hits `/payments/mtn/callback.php` (log file updated)
- [ ] Payment record status becomes SUCCESSFUL
- [ ] Student payment status updates

### Wallet + withdrawals
- [ ] Wallet tables exist (`verify_wallet_tables.php` passes)
- [ ] After successful payment: admin wallet is credited (via stored procedure)
- [ ] Withdrawal request processes (requires Disbursement credentials)
- [ ] Failed withdrawal refunds funds (check wallet balance + logs)

### Moodle
- [ ] Moodle connection test passes
- [ ] Subject-to-course mapping completed
- [ ] Payment triggers Moodle enrollment (for mapped subjects)
- [ ] Suspension/unsuspension actions work (if using reminders)

### Payment reminders
- [ ] Cron runs successfully (check cron email output)
- [ ] Reminders are logged in DB
- [ ] Test reminder can be sent

---

## 9) Production cleanup (don’t leave test surfaces)

After verification, delete or restrict access to:
- `/Multi-Tanent/test_*.php`
- `/Multi-Tanent/tools/test_*.php`
- `/Multi-Tanent/verify_wallet_tables.php`
- Any ad-hoc test scripts you created

Leaving these accessible in production increases your attack surface.

---

## 10) Known “gotchas” (common root causes)

- **Clean URLs 404**: host has `mod_rewrite` disabled or AllowOverride off (host-side setting).
- **MoMo callbacks never arrive**: callback URL points to `/payments/mtn/callback` but real file is `callback.php`. Fix by setting `MOMO_CALLBACK_PATH` to `/payments/mtn/callback.php`.
- **Withdrawals fail**: Disbursement credentials missing/invalid (separate product subscription).
- **Email fails**: SMTP credentials wrong or outbound port blocked.
- **Moodle fails**: token missing permissions or outbound HTTPS blocked.

---

## 11) Quick “install in order” summary

1. Create DB + user in cPanel (ALL PRIVILEGES)
2. Upload files to `/public_html/Multi-Tanent/` (+ ensure `vendor/` exists)
3. Edit `config.php` (DB, `PUBLIC_BASE_URL`, disable debug, set MoMo callback path)
4. Import `database/schema.sql` (or your full DB export)
5. Import module SQL scripts you are enabling (SMS, wallet, Moodle, reminders, etc.)
6. Fix permissions for writable folders
7. Configure SMTP/SMS/MoMo/Moodle credentials
8. Add cron job(s) for reminders (and any additional operational cron you use)
9. Run verification checklist; only then remove test scripts


