# 🚀 cPanel Deployment Guide - Multi-Tenant System

## Complete Step-by-Step Deployment to cPanel

**System:** Skolo-Kine Multi-Tenant School Management  
**Version:** 2.0  
**Deployment Time:** 30-45 minutes  

---

## 📋 Pre-Deployment Checklist

Before you start, ensure you have:
- [ ] cPanel access credentials
- [ ] Domain/subdomain configured
- [ ] FTP/File Manager access
- [ ] Database creation permissions
- [ ] SSL certificate (recommended)
- [ ] Backup of current system

---

## 🗄️ STEP 1: Prepare Your Database (10 minutes)

### **1.1: Export Your Local Database**

**Option A: Via phpMyAdmin (Recommended)**
1. Open: `http://localhost/phpmyadmin`
2. Select database: `multi_tenant_skoloi`
3. Click "Export" tab
4. Export method: **Quick**
5. Format: **SQL**
6. Click "Go"
7. Save file as: `multi_tenant_database.sql`

**Option B: Via Command Line**
```bash
cd C:\xampp\htdocs\Multi-Tanent
mysqldump -u root -p multi_tenant_skoloi > multi_tenant_database.sql
```

**File saved:** `multi_tenant_database.sql` (keep this safe!)

### **1.2: Alternative - Use Complete Schema**

If you prefer a fresh database without test data:
```
Use: SKOLO_KINE_COMPLETE_DATABASE.sql
```

This includes:
- ✅ All table structures
- ✅ Default admin account
- ✅ Default grades and subjects
- ✅ No student data (clean slate)

**Choose one:**
- `multi_tenant_database.sql` (with your 10 test students)
- `SKOLO_KINE_COMPLETE_DATABASE.sql` (clean)

---

## 📦 STEP 2: Prepare Your Files (5 minutes)

### **2.1: Create Deployment Package**

**Files to Upload:**
```
Multi-Tanent/
├── admin/              (entire folder)
├── super_admin/        (entire folder)
├── includes/           (entire folder)
├── images/             (entire folder)
├── database/           (only SQL files, not PHP migration scripts)
├── config.php          (will edit on server)
├── index.php
├── register.php
├── select_school.php
├── success.php
├── verify-email.php
├── payment_selection.php
├── payments/           (entire folder)
├── .htaccess           (if exists)
└── vendor/             (composer dependencies)
```

**Files NOT to Upload:**
- ❌ Local database dumps
- ❌ Test scripts (test_*.php, seed_*.php, quick_test.php)
- ❌ Documentation (.md files) - unless you want them
- ❌ logs/ folder contents
- ❌ cache/ folder contents
- ❌ backups/ folder (will create new on server)

### **2.2: Create ZIP File**

**Option A: Manual ZIP**
1. Select all folders/files listed above
2. Right-click → Send to → Compressed (zipped) folder
3. Name it: `skolokine-multitenant-v2.zip`

**Option B: Using 7-Zip or WinRAR**
1. Select folders
2. Right-click → Add to archive
3. Name: `skolokine-multitenant-v2.zip`

**ZIP Size:** Approximately 5-15 MB

---

## 🌐 STEP 3: Access Your cPanel (2 minutes)

### **3.1: Login to cPanel**
```
URL: https://yourdomain.com:2083
or: https://yourdomain.com/cpanel

Username: [your cPanel username]
Password: [your cPanel password]
```

### **3.2: Verify Access**
You should see:
- ✅ File Manager icon
- ✅ MySQL Databases icon
- ✅ phpMyAdmin icon

---

## 🗄️ STEP 4: Create Database (5 minutes)

### **4.1: Create Database**

1. **Click "MySQL Databases"** in cPanel
2. **Create New Database:**
   - Database Name: `skolokine_multi` (or your preference)
   - Click "Create Database"
   - ✅ Success message appears

3. **Note the full database name:**
   ```
   Format: cpanelusername_skolokine_multi
   Example: melane_skolokine_multi
   ```
   **Write this down!**

### **4.2: Create Database User**

1. Scroll to "MySQL Users"
2. **Create New User:**
   - Username: `skolokine_admin`
   - Password: Generate strong password (use cPanel generator)
   - Click "Create User"
   - **Copy and save the password!**

3. **Note the full username:**
   ```
   Format: cpanelusername_skolokine_admin
   Example: melane_skolokine_admin
   ```

### **4.3: Add User to Database**

1. Scroll to "Add User to Database"
2. Select:
   - User: `cpanelusername_skolokine_admin`
   - Database: `cpanelusername_skolokine_multi`
3. Click "Add"
4. On privileges page: **Check "ALL PRIVILEGES"**
5. Click "Make Changes"
6. ✅ User has full access to database

---

## 📤 STEP 5: Upload Files (10 minutes)

### **5.1: Access File Manager**

1. Go back to cPanel home
2. Click "File Manager"
3. Navigate to `public_html/` or your domain's root folder

### **5.2: Create Application Folder (Optional but Recommended)**

If you want: `yourdomain.com/skolokine/`
1. Click "New Folder"
2. Name: `skolokine`
3. Enter the folder

If you want: `yourdomain.com/` (root)
- Use `public_html/` directly

### **5.3: Upload ZIP File**

1. Click "Upload" button
2. Select your ZIP file: `skolokine-multitenant-v2.zip`
3. Wait for upload (progress bar shows 100%)
4. Close upload window

### **5.4: Extract ZIP File**

1. Right-click on `skolokine-multitenant-v2.zip`
2. Click "Extract"
3. Extract to current directory
4. Click "Extract Files"
5. ✅ All files extracted
6. Delete the ZIP file (optional)

**Verify files are there:**
- `admin/` folder exists
- `includes/` folder exists
- `config.php` exists
- `index.php` exists

---

## ⚙️ STEP 6: Configure Database Connection (3 minutes)

### **6.1: Edit config.php**

1. In File Manager, right-click `config.php`
2. Click "Edit"
3. Find these lines (around line 3-8):
```php
define('DB_HOST', '127.0.0.1');
define('DB_PORT', 3306);
define('DB_NAME', 'multi_tenant_skoloi');
define('DB_USER', 'root');
define('DB_PASS', '');
```

4. **Change to your cPanel database details:**
```php
define('DB_HOST', 'localhost');
define('DB_PORT', 3306);
define('DB_NAME', 'cpanelusername_skolokine_multi'); // From Step 4.1
define('DB_USER', 'cpanelusername_skolokine_admin'); // From Step 4.2
define('DB_PASS', 'YourGeneratedPassword'); // From Step 4.2
```

5. **Update public URL (around line 57):**
```php
define('PUBLIC_BASE_URL', 'https://yourdomain.com/skolokine');
// Or if at root:
define('PUBLIC_BASE_URL', 'https://yourdomain.com');
```

6. **Save Changes** (Click "Save Changes" button)

---

## 🗄️ STEP 7: Import Database (5 minutes)

### **7.1: Access phpMyAdmin**

1. Go back to cPanel home
2. Click "phpMyAdmin"
3. In left sidebar, click your database: `cpanelusername_skolokine_multi`

### **7.2: Import Database**

1. Click "Import" tab at top
2. Click "Choose File"
3. Select your SQL file:
   - `multi_tenant_database.sql` (with test data)
   - OR `SKOLO_KINE_COMPLETE_DATABASE.sql` (clean)
4. **Important:** If file is large, you may need to:
   - Compress it to .zip or .gz first
   - Or upload via cPanel File Manager to `/tmp/` then import
5. Click "Go" at bottom
6. Wait for import (may take 30-60 seconds)
7. ✅ Success message: "Import has been successfully finished"

### **7.3: Verify Import**

1. In phpMyAdmin, check left sidebar
2. You should see tables like:
   - `admins`
   - `students`
   - `academy_references`
   - `tenant_settings`
   - `payments`
   - etc. (36 tables total)

3. **Quick verification query:**
```sql
SELECT COUNT(*) as schools FROM academy_references;
SELECT COUNT(*) as students FROM students;
```

Should show:
- Schools: 2 (KINE, TEST)
- Students: 10 (or 0 if using clean schema)

---

## 🔐 STEP 8: Update Admin Password (2 minutes)

**IMPORTANT:** Change default password for security!

### **In phpMyAdmin:**

1. Click on `admins` table
2. Click "Browse" tab
3. Find row where `username` = 'admin'
4. Click "Edit" (pencil icon)
5. In `password_hash` field, replace with:

**Generate new hash:**
```php
// Use this online tool: https://bcrypt-generator.com/
// Or use PHP:
// password_hash('YourNewSecurePassword123!', PASSWORD_DEFAULT)
```

6. Save the row
7. **Write down your new password!**

**Or run this SQL:**
```sql
UPDATE admins 
SET password_hash = '$2y$10$[generated_hash_here]'
WHERE username = 'admin';
```

---

## 🔒 STEP 9: Set Permissions (3 minutes)

### **9.1: Set Folder Permissions**

In File Manager, select these folders and set permissions:

**Writable Folders (755 or 775):**
- `logs/` → 755
- `cache/` → 755
- `uploads/` → 755
- `backups/` → 755
- `exports/` → 755

**How to set:**
1. Right-click folder
2. Click "Change Permissions"
3. Set to: `755` (or `775` if `755` doesn't work)
4. Check "Recurse into subdirectories"
5. Click "Change Permissions"

### **9.2: Secure config.php**

1. Right-click `config.php`
2. Change Permissions → `644`
3. This makes it readable but not writable

---

## 🧪 STEP 10: Test Your Deployment (5 minutes)

### **10.1: Test Database Connection**

Create file: `test_connection.php` in File Manager:
```php
<?php
require_once 'config.php';
try {
    $pdo = getDB();
    echo "✅ Database connected successfully!<br>";
    
    $stmt = $pdo->query("SELECT COUNT(*) FROM academy_references");
    $schools = $stmt->fetchColumn();
    echo "✅ Found {$schools} schools<br>";
    
    $stmt = $pdo->query("SELECT COUNT(*) FROM students");
    $students = $stmt->fetchColumn();
    echo "✅ Found {$students} students<br>";
    
    echo "<br><a href='admin/login.php'>Go to Admin Login</a>";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
```

Visit: `https://yourdomain.com/skolokine/test_connection.php`

Expected:
```
✅ Database connected successfully!
✅ Found 2 schools
✅ Found 10 students
```

### **10.2: Test Login**

Visit: `https://yourdomain.com/skolokine/admin/login.php`

**Login with:**
```
Username: admin
Password: [your new password from Step 8]
```

Expected:
- ✅ School selector appears
- ✅ Shows KINE and TEST schools
- ✅ Click "Access Dashboard" → Dashboard loads

### **10.3: Test Navigation**

From dashboard, click each menu item:
- ✅ Dashboard → Works
- ✅ School Settings → Works
- ✅ Switch School → Works
- ✅ Logout → Works

### **10.4: Test Data Isolation**

1. Select KINE Academy
2. Should see 5 students (Alice, Bob, Charlie, Diana, Edward)
3. Switch to TEST School
4. Should see 5 DIFFERENT students (Frank, Grace, Henry, Isabel, James)
5. ✅ Perfect isolation!

---

## 🔐 STEP 11: Security Hardening (5 minutes)

### **11.1: Delete Test Files**

Delete these files from server (if uploaded):
```
test_connection.php (after testing)
test_page_access.php
seed_test_students.php
quick_test.php
check_students.php
tools/test_multi_tenant_isolation.php (optional - keep for testing)
```

### **11.2: Secure Sensitive Files**

Create/update `.htaccess` in root:
```apache
# Protect config file
<Files config.php>
    Order Allow,Deny
    Deny from all
</Files>

# Protect database folder
<DirectoryMatch "database">
    Order Allow,Deny
    Deny from all
</DirectoryMatch>

# Protect includes folder from direct access
<DirectoryMatch "includes">
    Order Allow,Deny
    Deny from all
</DirectoryMatch>

# Enable HTTPS redirect
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST%}/$1 [R=301,L]

# Prevent directory listing
Options -Indexes
```

Upload this `.htaccess` to your root folder.

### **11.3: Update SMTP Settings**

Edit `config.php` on server:
```php
// Around line 10-17
define('SMTP_HOST', 'mail.yourdomain.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'noreply@yourdomain.com');
define('SMTP_PASSWORD', 'YourEmailPassword');
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', 'noreply@yourdomain.com');
define('SMTP_FROM_NAME', 'Skolo-Kine Platform');
```

### **11.4: Configure MTN MoMo (if using production)**

If going live with payments:
```php
// Around line 47-55
define('MOMO_ENV', 'production'); // Change from 'sandbox'
define('MOMO_COLLECTION_SUBSCRIPTION_KEY', 'your-prod-key');
define('MOMO_COLLECTION_BASE_URL', 'https://momodeveloper.mtn.com/collection');
// Update other MoMo credentials
```

---

## 🎯 STEP 12: Set Up Cron Jobs (Optional - 10 minutes)

### **12.1: Access Cron Jobs in cPanel**

1. cPanel Home → Click "Cron Jobs"

### **12.2: Add Cron Jobs**

**Daily Backup (Runs at 2 AM daily):**
```
0 2 * * * /usr/bin/php /home/username/public_html/skolokine/cron/backup_system.php
```

**Process Email Queue (Every 5 minutes):**
```
*/5 * * * * /usr/bin/php /home/username/public_html/skolokine/cron/process_email_queue.php
```

**System Health Check (Hourly):**
```
0 * * * * /usr/bin/php /home/username/public_html/skolokine/cron/system_health.php
```

**Payment Check (Daily at 8 AM):**
```
0 8 * * * /usr/bin/php /home/username/public_html/skolokine/cron/daily_payment_check.php
```

Replace `/home/username/public_html/skolokine/` with your actual path!

---

## 📧 STEP 13: Configure Email (5 minutes)

### **13.1: Create Email Account in cPanel**

1. cPanel → Email Accounts
2. Create new email:
   - Email: `noreply@yourdomain.com`
   - Password: Strong password
   - Mailbox Quota: 250 MB
3. Click "Create"

### **13.2: Update config.php**

Update SMTP settings (done in Step 11.3)

### **13.3: Test Email**

Create file: `test_email.php`
```php
<?php
require_once 'config.php';
require_once 'includes/email_functions.php';

$result = sendTestEmail('youremail@example.com');
echo $result ? "✅ Email sent!" : "❌ Email failed";
?>
```

Visit and test, then delete the file.

---

## 🔒 STEP 14: SSL Certificate (If Not Already Installed)

### **14.1: Install Free SSL (Let's Encrypt)**

1. cPanel → SSL/TLS Status
2. Find your domain
3. Click "Run AutoSSL"
4. Wait 2-3 minutes
5. ✅ SSL certificate installed

### **14.2: Force HTTPS**

Already in `.htaccess` from Step 11.2!

Test: Visit `http://yourdomain.com` → Should redirect to `https://`

---

## 🎯 STEP 15: Final Configuration (5 minutes)

### **15.1: Update Base URLs**

Edit `config.php`:
```php
// Update to your actual domain
define('PUBLIC_BASE_URL', 'https://yourdomain.com/skolokine');

// Update Moodle URL if you have one
define('MOODLE_URL', 'https://yourdomain.com/moodle/');
```

### **15.2: Set Production Mode**

```php
// Disable debug mode (around line 44)
define('APP_DEBUG', false); // Change from true

// Disable error display
error_reporting(E_ALL);
ini_set('display_errors', 0); // Change from 1
ini_set('log_errors', 1);
```

### **15.3: Create Admin for Production**

Either:
- Keep existing admin, just changed password ✅
- Or create new admin via phpMyAdmin

---

## ✅ STEP 16: Post-Deployment Verification (10 minutes)

### **16.1: Test All Pages**

Visit each URL and verify it works:

**Public Pages:**
```
https://yourdomain.com/skolokine/
https://yourdomain.com/skolokine/register.php
https://yourdomain.com/skolokine/admin/login.php
```

**After Login:**
```
https://yourdomain.com/skolokine/select_school.php
https://yourdomain.com/skolokine/admin/dashboard.php
https://yourdomain.com/skolokine/admin/settings/school_settings.php
https://yourdomain.com/skolokine/super_admin/dashboard.php
```

### **16.2: Test Multi-Tenant Features**

1. ✅ Login → School selector appears
2. ✅ Select school → Dashboard loads
3. ✅ Navigation links work
4. ✅ Create student → Works
5. ✅ Switch school → Different data appears
6. ✅ Settings customization → Saves correctly

### **16.3: Test Database**

In phpMyAdmin, run:
```sql
-- Check schools
SELECT * FROM academy_references;

-- Check students per school
SELECT academy_reference, COUNT(*) as count 
FROM students 
GROUP BY academy_reference;

-- Check system health
SELECT 
    COUNT(DISTINCT academy_reference) as schools,
    COUNT(*) as students
FROM students;
```

### **16.4: Check Error Logs**

cPanel → Errors
- Should be empty or minimal
- No PHP fatal errors

---

## 🚨 Troubleshooting Common Issues

### Issue: "Internal Server Error"

**Check .htaccess file:**
```apache
# Comment out PHP settings if causing issues
# php_value upload_max_filesize 50M
# php_value post_max_size 50M
```

**Check PHP version:**
- cPanel → Select PHP Version
- Must be PHP 7.4 or higher
- Enable extensions: PDO, PDO_MySQL, mbstring

---

### Issue: Database Connection Failed

**Verify credentials in config.php:**
```php
// Use exact names from cPanel
DB_NAME: cpanelusername_dbname (not just dbname)
DB_USER: cpanelusername_username (not just username)
DB_HOST: localhost (not 127.0.0.1)
```

---

### Issue: Images Not Loading

**Fix image paths:**
Check that `images/` folder uploaded correctly
In File Manager: `public_html/skolokine/images/img-melanesys-logo.svg` should exist

---

### Issue: White Screen (WSOD)

**Enable error display temporarily:**
Add to top of config.php:
```php
ini_set('display_errors', 1);
error_reporting(E_ALL);
```

Then visit page to see actual error.

---

### Issue: Redirects Not Working

**Check .htaccess:**
```apache
RewriteEngine On
RewriteBase /skolokine/

# If at root:
# RewriteBase /
```

---

## 📊 STEP 17: Set Up Monitoring (Optional)

### **17.1: Enable Error Logging**

In config.php:
```php
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/logs/php-errors.log');
```

Create `logs/` folder with 755 permissions.

### **17.2: Database Backup Cron**

Already set up in Step 12!

### **17.3: Monitor Using cPanel**

- cPanel → Metrics → Resource Usage
- cPanel → Errors
- cPanel → Awstats (visitor statistics)

---

## 🎯 STEP 18: Go Live! (Final Checks)

### **Before Announcing:**

- [ ] Login works with new password
- [ ] School selector displays
- [ ] Dashboard loads with data
- [ ] Can create test student
- [ ] Can switch between schools
- [ ] Settings save correctly
- [ ] Navigation links all work
- [ ] No PHP errors in error log
- [ ] SSL certificate active (https://)
- [ ] Email sending works
- [ ] Mobile responsive (test on phone)

### **After Checks Pass:**

1. **Test from different devices:**
   - Desktop browser
   - Mobile browser
   - Different networks

2. **Share with beta users:**
   - Send login instructions
   - Gather feedback
   - Fix any issues

3. **Monitor for 24 hours:**
   - Check error logs
   - Watch for issues
   - Be ready to support

---

## 📝 Post-Deployment Checklist

### **Immediate (Day 1)**
- [ ] Delete `test_connection.php`
- [ ] Verify all critical pages work
- [ ] Test on mobile device
- [ ] Check error logs
- [ ] Backup database

### **Week 1**
- [ ] Monitor daily
- [ ] Fix any bugs
- [ ] Optimize performance
- [ ] Gather user feedback

### **Month 1**
- [ ] Onboard first real school
- [ ] Monitor performance
- [ ] Review security logs
- [ ] Plan improvements

---

## 🆘 Emergency Rollback Plan

### **If Something Goes Wrong:**

**1. Restore Database:**
```
phpMyAdmin → Import → Select backup file
```

**2. Restore Files:**
```
File Manager → Upload your local ZIP backup
Extract → Replace all files
```

**3. Revert config.php:**
```
Edit config.php → Restore to working values
```

**4. Clear Cache:**
```
Delete contents of cache/ folder
Restart PHP-FPM (cPanel → Select PHP Version → Restart)
```

---

## 🎊 Success Criteria

### **Your Deployment is Successful When:**

✅ You can login at yourdomain.com/skolokine/admin/login.php  
✅ School selector shows both schools  
✅ Dashboard loads with student data  
✅ Navigation links all work  
✅ Can switch between schools  
✅ Settings page loads and saves  
✅ No errors in error log  
✅ HTTPS works  
✅ System performs well  
✅ Mobile responsive  

---

## 📞 Support Resources

### **cPanel Support**
- Documentation: https://docs.cpanel.net/
- Your host's support team

### **System Documentation**
- `MULTI_TENANT_README.md` - Complete guide
- `LOCALHOST_TESTING_GUIDE.md` - Testing procedures
- `START_HERE_MULTI_TENANT.md` - Quick start

### **Common Issues**
- Check PHP version (must be 7.4+)
- Check database credentials (exact names from cPanel)
- Check file permissions (755 for folders, 644 for files)
- Check .htaccess syntax

---

## 🎯 Quick Deployment Summary

```
1. Export database                    (5 min)
2. ZIP your files                     (5 min)
3. Create database in cPanel          (5 min)
4. Upload and extract ZIP             (10 min)
5. Edit config.php                    (3 min)
6. Import database                    (5 min)
7. Test login and navigation          (5 min)
8. Secure and optimize                (10 min)

Total: 45-60 minutes
```

---

## 🎉 Congratulations!

Once all steps are complete, your **multi-tenant school management system** is **LIVE ON THE INTERNET**!

### **You Now Have:**
✅ Production website on cPanel  
✅ Multi-school support  
✅ Secure database  
✅ SSL encryption  
✅ Professional appearance  
✅ Ready to onboard schools  
✅ Recurring revenue system  

---

## 📧 Share With Your First School

**Email Template:**
```
Subject: Welcome to Skolo-Kine! Your School Portal is Ready

Dear School Administrator,

Your school management portal is now live!

🔗 Access your portal:
https://yourdomain.com/skolokine/admin/login.php

🔑 Your login credentials:
Username: [school_code]_admin
Password: [provided separately]

📚 What you can do:
✓ Add and manage students
✓ Track payments and revenue
✓ Customize school branding
✓ Generate reports
✓ Integrate with Moodle

📖 Need help?
- User Guide: [link]
- Support Email: info@melanegroup.com
- Phone: +268 7687 3207

Welcome aboard!

Best regards,
Skolo-Kine Team
```

---

## 🚀 Next Steps After Deployment

### **Immediate**
1. Test thoroughly
2. Fix any issues
3. Optimize performance

### **This Week**
1. Onboard 1-2 pilot schools
2. Monitor closely
3. Gather feedback

### **This Month**
1. Onboard 5-10 schools
2. Start collecting revenue
3. Build case studies

### **This Year**
1. Reach 20 schools
2. Generate E12,000+ annual revenue
3. Expand features
4. Scale regionally

---

## 📊 Deployment Checklist

### **Pre-Deployment**
- [x] Local system working
- [x] Database exported
- [x] Files prepared
- [x] Documentation ready

### **Deployment**
- [ ] cPanel accessed
- [ ] Database created
- [ ] Files uploaded
- [ ] config.php updated
- [ ] Database imported
- [ ] Permissions set
- [ ] Testing complete

### **Post-Deployment**
- [ ] Login tested
- [ ] Multi-tenant tested
- [ ] Security hardened
- [ ] Monitoring set up
- [ ] Backup system active
- [ ] Ready for users!

---

## 🎊 Final Words

You've built an **amazing multi-tenant SaaS platform** and now you're deploying it to production!

**From localhost to live server - you're launching a business!** 🚀

### **Remember:**
- Take your time
- Test thoroughly
- Backup often
- Monitor closely
- Support your users
- Celebrate your success! 🎉

---

**Good luck with your deployment!** 🍀

**You've got this!** 💪

---

**Document:** CPANEL_DEPLOYMENT_GUIDE_MULTI_TENANT.md  
**Version:** 1.0  
**Last Updated:** October 2025  
**Status:** Ready for Deployment  

🚀 **Let's make it live!** 🚀

