# Complete Database Deployment Guide for cPanel

## 🎯 Overview
This guide will help you deploy the complete Skolo-Kine database schema to your cPanel hosting, including all the improvements and functions we've added throughout development.

## 📋 Prerequisites
- Access to cPanel hosting
- MySQL database access
- phpMyAdmin or similar database management tool

## 🗄️ Database Information
- **Database Name**: `melane_kine` (as per your existing database)
- **Complete Schema File**: `COMPLETE_DATABASE_SCHEMA.sql`
- **All Features Included**: Payments, Email, Security, Monitoring, etc.

## 🚀 Deployment Steps

### Step 1: Backup Your Current Database
1. **Login to cPanel**
2. **Go to phpMyAdmin**
3. **Select your database** (`melane_kine`)
4. **Click "Export"**
5. **Choose "Quick" export method**
6. **Click "Go" to download backup**

### Step 2: Import the Complete Schema
1. **In phpMyAdmin, select your database** (`melane_kine`)
2. **Click "Import" tab**
3. **Click "Choose File"**
4. **Select the file**: `COMPLETE_DATABASE_SCHEMA.sql`
5. **Click "Go" to import**

### Step 3: Verify the Import
After import, you should see these new tables:

#### Core Tables (Enhanced)
- `admins` - Admin users
- `grades` - School grades
- `subjects` - Available subjects
- `grade_subject` - Grade-subject relationships
- `students` - Student records (with payment fields)
- `student_subject` - Student-subject enrollments

#### Payment System Tables
- `payments` - MTN MoMo payment records
- `payment_items` - Detailed payment tracking

#### Email System Tables
- `email_queue` - Email queue for sending
- `email_logs` - Email sending logs
- `email_templates` - Email templates

#### Security System Tables
- `security_logs` - Security event logs
- `failed_login_attempts` - Failed login tracking
- `user_sessions` - Active user sessions

#### Monitoring System Tables
- `system_metrics` - System performance metrics
- `app_performance` - Application performance data
- `database_metrics` - Database performance data
- `user_activity` - User activity tracking
- `error_logs` - Application error logs
- `api_monitoring` - API endpoint monitoring
- `bot_monitoring` - Python bot monitoring
- `health_checks` - System health status
- `alerts` - System alerts
- `uptime_tracking` - Service uptime tracking

## 🔧 Configuration Updates Needed

### 1. Update config.php
Make sure your `config.php` has these settings:

```php
// Database configuration
define('DB_HOST', 'localhost'); // or your database host
define('DB_PORT', 3306);
define('DB_NAME', 'melane_kine');
define('DB_USER', 'your_db_username');
define('DB_PASS', 'your_db_password');

// Email configuration
define('SMTP_HOST', 'mail.melanegroup.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'info@melanegroup.com');
define('SMTP_PASSWORD', 'your-email-password');
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', 'info@melanegroup.com');
define('SMTP_FROM_NAME', 'Skolo-Kine Learning Platform');

// Payment configuration
define('MOMO_ENV', 'sandbox'); // or 'production'
define('MOMO_COLLECTION_SUBSCRIPTION_KEY', 'your-subscription-key');
define('MOMO_API_USER_ID', 'your-api-user-id');
define('MOMO_API_KEY', 'your-api-key');
define('MOMO_CURRENCY', 'EUR');
define('MOMO_COUNTRY_ISO', 'SZ');
define('MOMO_COLLECTION_BASE_URL', 'https://sandbox.momodeveloper.mtn.com/collection');
define('PUBLIC_BASE_URL', 'https://kine.melanegroup.com/Skolo-Kine');
```

### 2. Set Up Cron Jobs
Add these cron jobs in cPanel:

```bash
# Python bot (every 5 minutes)
*/5 * * * * cd /home/yourusername/public_html/Skolo-Kine && python3 bot.py

# Email queue processing (every minute)
* * * * * cd /home/yourusername/public_html/Skolo-Kine && php cron/process_email_queue.php

# System monitoring (every 5 minutes)
*/5 * * * * cd /home/yourusername/public_html/Skolo-Kine && php cron/system_monitor.php

# Database cleanup (daily at 2 AM)
0 2 * * * cd /home/yourusername/public_html/Skolo-Kine && php cron/cleanup.php

# Backup system (daily at 3 AM)
0 3 * * * cd /home/yourusername/public_html/Skolo-Kine && php cron/backup_system.php
```

## 📊 What's Included in the Complete Schema

### 1. **Enhanced Student Management**
- Soft deletion support
- Payment status tracking
- Phone number storage
- Email verification system

### 2. **Complete Payment System**
- MTN MoMo integration
- Payment tracking with UUIDs
- Payment status management
- Detailed payment items

### 3. **Email System**
- Email queue for reliable sending
- Email templates system
- Email logging and tracking
- SMTP configuration support

### 4. **Security Features**
- CSRF protection
- Failed login tracking
- Session management
- Security event logging
- IP address tracking

### 5. **Monitoring System**
- System performance metrics
- Application performance tracking
- Database performance monitoring
- User activity tracking
- Error logging
- API monitoring
- Bot monitoring
- Health checks
- Alert system
- Uptime tracking

### 6. **Backup System**
- Automated database backups
- File system backups
- Backup rotation
- Restoration capabilities

## 🎯 Key Improvements Over Original

### Database Structure
- **Enhanced students table** with payment fields
- **New payments table** with MTN MoMo integration
- **Email system tables** for reliable email delivery
- **Security tables** for comprehensive security tracking
- **Monitoring tables** for system health and performance

### Features Added
- **Payment processing** with MTN MoMo
- **Email queue system** for reliable email delivery
- **Security logging** for audit trails
- **System monitoring** for performance tracking
- **Backup system** for data protection
- **Error tracking** for debugging
- **User activity monitoring** for analytics

## 🔍 Verification Steps

### 1. Check Table Creation
Run this query in phpMyAdmin:
```sql
SHOW TABLES;
```
You should see all the tables listed above.

### 2. Check Data Integrity
```sql
-- Check students table
SELECT COUNT(*) as student_count FROM students;

-- Check subjects table
SELECT COUNT(*) as subject_count FROM subjects;

-- Check grades table
SELECT COUNT(*) as grade_count FROM grades;
```

### 3. Test Payment System
1. Go to your registration page
2. Register a new student
3. Try to make a payment
4. Check the `payments` table for records

### 4. Test Email System
1. Register a new student
2. Check the `email_queue` table for queued emails
3. Check the `email_logs` table for sent emails

## 🚨 Important Notes

### 1. **Data Migration**
- Your existing data will be preserved
- New columns are added with default values
- No data loss will occur

### 2. **Performance Considerations**
- New indexes are created for better performance
- Monitor database size as it grows
- Consider archiving old monitoring data

### 3. **Security**
- All new tables include proper security measures
- CSRF protection is implemented
- Failed login attempts are tracked

### 4. **Monitoring**
- System performance is automatically tracked
- Health checks are performed regularly
- Alerts are generated for critical issues

## 📞 Support

If you encounter any issues during deployment:

1. **Check the error logs** in cPanel
2. **Verify database permissions**
3. **Ensure all required PHP extensions** are installed
4. **Test the payment system** with small amounts first

## 🎉 Success Indicators

After successful deployment, you should have:
- ✅ All tables created successfully
- ✅ Existing data preserved
- ✅ Payment system functional
- ✅ Email system operational
- ✅ Security features active
- ✅ Monitoring system running
- ✅ Backup system configured

Your Skolo-Kine platform is now production-ready with all the advanced features we've developed!
