-- =====================================================
-- SKOLO-KINE MULTI-TENANT DATABASE - PRODUCTION READY
-- =====================================================
-- Complete database with multi-tenant architecture
-- Includes: 2 test schools, 10 students, sample payments
-- Ready for immediate cPanel deployment
-- 
-- Generated: October 23, 2025
-- Version: 2.0 Multi-Tenant Production
-- =====================================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- =====================================================
-- DROP EXISTING TABLES (Clean Install)
-- =====================================================

SET FOREIGN_KEY_CHECKS = 0;

DROP TABLE IF EXISTS `withdrawal_requests`;
DROP TABLE IF EXISTS `wallet_transactions`;
DROP TABLE IF EXISTS `admin_wallet`;
DROP TABLE IF EXISTS `platform_fees`;
DROP TABLE IF EXISTS `payment_cycles`;
DROP TABLE IF EXISTS `tenant_settings`;
DROP TABLE IF EXISTS `academy_references`;
DROP TABLE IF EXISTS `login_attempts`;
DROP TABLE IF EXISTS `system_health_log`;
DROP TABLE IF EXISTS `activity_log`;
DROP TABLE IF EXISTS `api_keys`;
DROP TABLE IF EXISTS `moodle_sync_log`;
DROP TABLE IF EXISTS `password_resets`;
DROP TABLE IF EXISTS `email_queue`;
DROP TABLE IF EXISTS `email_logs`;
DROP TABLE IF EXISTS `payments`;
DROP TABLE IF EXISTS `deleted_students`;
DROP TABLE IF EXISTS `students`;
DROP TABLE IF EXISTS `student_grades`;
DROP TABLE IF EXISTS `grade_subjects`;
DROP TABLE IF EXISTS `subjects`;
DROP TABLE IF EXISTS `grades`;
DROP TABLE IF EXISTS `admins`;

SET FOREIGN_KEY_CHECKS = 1;

-- =====================================================
-- CORE TABLES
-- =====================================================

-- Admins Table
CREATE TABLE `admins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `momo_number` varchar(32) DEFAULT NULL,
  `bank_account` varchar(50) DEFAULT NULL,
  `account_verified` tinyint(1) DEFAULT 0,
  `academy_reference` varchar(50) DEFAULT NULL COMMENT 'NULL for super admin, specific code for school admin',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `idx_academy_reference` (`academy_reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Grades Table
CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Subjects Table
CREATE TABLE `subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Grade Subjects (Many-to-Many)
CREATE TABLE `grade_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grade_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `grade_subject` (`grade_id`, `subject_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `grade_subjects_ibfk_1` FOREIGN KEY (`grade_id`) REFERENCES `grades` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grade_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Student Grades (Junction for assigned grades)
CREATE TABLE `student_grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `grade_id` int(11) NOT NULL,
  `assigned_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `grade_id` (`grade_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Students Table (Multi-Tenant Ready)
CREATE TABLE `students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `full_name` varchar(128) NOT NULL,
  `email` varchar(128) DEFAULT NULL,
  `email_verified` tinyint(1) DEFAULT 0,
  `verification_token` varchar(64) DEFAULT NULL,
  `phone` varchar(32) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` enum('Male','Female','Other') DEFAULT NULL,
  `address` text DEFAULT NULL,
  `guardian_name` varchar(128) DEFAULT NULL,
  `guardian_phone` varchar(32) DEFAULT NULL,
  `guardian_email` varchar(128) DEFAULT NULL,
  `momo_number` varchar(32) DEFAULT NULL,
  `payment_amount` decimal(10,2) DEFAULT 0.00,
  `payment_status` enum('pending','active','suspended') DEFAULT 'pending',
  `moodle_synced` tinyint(1) DEFAULT 0,
  `moodle_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_payment_date` datetime DEFAULT NULL,
  `next_payment_due` datetime DEFAULT NULL,
  `payment_cycle_start` datetime DEFAULT NULL,
  `payment_reminder_sent` tinyint(1) DEFAULT 0,
  `warning_email_sent` tinyint(1) DEFAULT 0,
  `suspension_warning_sent` tinyint(1) DEFAULT 0,
  `moodle_status` enum('active','suspended','pending') DEFAULT 'pending',
  `suspended_date` datetime DEFAULT NULL,
  `academy_reference` varchar(50) DEFAULT 'KINE' COMMENT 'Multi-tenant identifier',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `idx_email` (`email`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_moodle_synced` (`moodle_synced`),
  KEY `idx_academy_reference` (`academy_reference`),
  KEY `idx_moodle_status` (`moodle_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Deleted Students (For Recovery)
CREATE TABLE `deleted_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `original_student_id` int(11) NOT NULL,
  `username` varchar(64) NOT NULL,
  `full_name` varchar(128) NOT NULL,
  `email` varchar(128) DEFAULT NULL,
  `phone` varchar(32) DEFAULT NULL,
  `deletion_reason` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT current_timestamp(),
  `deleted_by` varchar(64) DEFAULT NULL,
  `student_data` text DEFAULT NULL COMMENT 'JSON backup of all student data',
  PRIMARY KEY (`id`),
  KEY `idx_original_student_id` (`original_student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Payments Table (Multi-Tenant Ready)
CREATE TABLE `payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_reference` varchar(64) NOT NULL,
  `status` enum('pending','completed','failed') DEFAULT 'pending',
  `payment_date` timestamp NULL DEFAULT current_timestamp(),
  `momo_number` varchar(32) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT 'mtn_momo',
  `admin_earnings` decimal(10,2) DEFAULT 0.00,
  `platform_fee` decimal(10,2) DEFAULT 0.00,
  `academy_reference` varchar(50) DEFAULT 'KINE',
  PRIMARY KEY (`id`),
  UNIQUE KEY `payment_reference` (`payment_reference`),
  KEY `student_id` (`student_id`),
  KEY `idx_status` (`status`),
  KEY `idx_payment_date` (`payment_date`),
  KEY `idx_academy_reference` (`academy_reference`),
  CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- EMAIL SYSTEM TABLES
-- =====================================================

-- Email Logs
CREATE TABLE `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recipient_email` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `sent_at` timestamp NULL DEFAULT current_timestamp(),
  `status` enum('sent','failed') DEFAULT 'sent',
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_recipient_email` (`recipient_email`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Email Queue
CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recipient_email` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `scheduled_at` timestamp NULL DEFAULT current_timestamp(),
  `sent` tinyint(1) DEFAULT 0,
  `sent_at` timestamp NULL DEFAULT NULL,
  `attempts` int(11) DEFAULT 0,
  `last_error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sent` (`sent`),
  KEY `idx_scheduled_at` (`scheduled_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Password Resets
CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NULL DEFAULT NULL,
  `used` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- MOODLE INTEGRATION
-- =====================================================

-- Moodle Sync Log
CREATE TABLE `moodle_sync_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `action` enum('create','update','suspend','activate') NOT NULL,
  `status` enum('success','failed') DEFAULT 'success',
  `moodle_response` text DEFAULT NULL,
  `synced_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `idx_synced_at` (`synced_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- SECURITY & MONITORING
-- =====================================================

-- API Keys
CREATE TABLE `api_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(128) NOT NULL,
  `api_key` varchar(64) NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `last_used_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_key` (`api_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Activity Log
CREATE TABLE `activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` enum('admin','student') NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(128) NOT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_type_id` (`user_type`, `user_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- System Health Log
CREATE TABLE `system_health_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `check_type` varchar(64) NOT NULL,
  `status` enum('healthy','warning','critical') DEFAULT 'healthy',
  `details` text DEFAULT NULL,
  `checked_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_check_type` (`check_type`),
  KEY `idx_checked_at` (`checked_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Login Attempts
CREATE TABLE `login_attempts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `success` tinyint(1) DEFAULT 0,
  `attempted_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_username` (`username`),
  KEY `idx_ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- MULTI-TENANT TABLES
-- =====================================================

-- Academy References (Schools)
CREATE TABLE `academy_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_code` varchar(50) NOT NULL COMMENT 'Unique code like KINE, TEST, etc',
  `academy_name` varchar(255) NOT NULL,
  `contact_email` varchar(255) DEFAULT NULL,
  `contact_phone` varchar(32) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `onboarding_date` date DEFAULT NULL,
  `subscription_status` enum('trial','active','suspended','cancelled') DEFAULT 'trial',
  `trial_ends_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference_code` (`reference_code`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_subscription_status` (`subscription_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tenant Settings (School-Specific Configuration)
CREATE TABLE `tenant_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `academy_reference` varchar(50) NOT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_setting` (`academy_reference`, `setting_key`),
  KEY `idx_academy_reference` (`academy_reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- PAYMENT SYSTEM TABLES
-- =====================================================

-- Payment Cycles
CREATE TABLE `payment_cycles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `cycle_start` datetime NOT NULL,
  `cycle_end` datetime NOT NULL,
  `amount_due` decimal(10,2) NOT NULL,
  `amount_paid` decimal(10,2) DEFAULT 0.00,
  `status` enum('upcoming','active','completed','overdue') DEFAULT 'upcoming',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `payment_cycles_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Platform Fees
CREATE TABLE `platform_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `platform_fee` decimal(10,2) NOT NULL,
  `admin_earnings` decimal(10,2) NOT NULL,
  `fee_percentage` decimal(5,2) DEFAULT 20.00,
  `payment_method` varchar(50) DEFAULT 'mtn_momo',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `platform_fees_ibfk_1` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `platform_fees_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- WALLET SYSTEM TABLES
-- =====================================================

-- Admin Wallet
CREATE TABLE `admin_wallet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `total_earnings` decimal(10,2) DEFAULT 0.00,
  `withdrawn` decimal(10,2) DEFAULT 0.00,
  `balance` decimal(10,2) DEFAULT 0.00,
  `last_updated` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `admin_id` (`admin_id`),
  CONSTRAINT `admin_wallet_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Wallet Transactions
CREATE TABLE `wallet_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wallet_id` int(11) NOT NULL,
  `transaction_type` enum('credit','debit') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `payment_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `wallet_id` (`wallet_id`),
  KEY `payment_id` (`payment_id`),
  CONSTRAINT `wallet_transactions_ibfk_1` FOREIGN KEY (`wallet_id`) REFERENCES `admin_wallet` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Withdrawal Requests
CREATE TABLE `withdrawal_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `momo_number` varchar(32) NOT NULL,
  `status` enum('pending','approved','processing','completed','rejected') DEFAULT 'pending',
  `requested_at` timestamp NULL DEFAULT current_timestamp(),
  `processed_at` timestamp NULL DEFAULT NULL,
  `processed_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `withdrawal_requests_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- =====================================================
-- INSERT DEFAULT DATA
-- =====================================================

-- Insert Default Grades
INSERT INTO `grades` (`id`, `name`) VALUES
(1, 'Form 1'),
(2, 'Form 2'),
(3, 'Form 3'),
(4, 'Form 4'),
(5, 'Form 5');

-- Insert Default Subjects
INSERT INTO `subjects` (`id`, `name`) VALUES
(1, 'Mathematics'),
(2, 'English'),
(3, 'SiSwati'),
(4, 'Science'),
(5, 'History'),
(6, 'Geography'),
(7, 'Physical Education'),
(8, 'Computer Science'),
(9, 'Art'),
(10, 'Music');

-- Assign subjects to all grades
INSERT INTO `grade_subjects` (`grade_id`, `subject_id`) VALUES
(1, 1), (1, 2), (1, 3), (1, 4), (1, 5), (1, 6), (1, 7), (1, 8),
(2, 1), (2, 2), (2, 3), (2, 4), (2, 5), (2, 6), (2, 7), (2, 8),
(3, 1), (3, 2), (3, 3), (3, 4), (3, 5), (3, 6), (3, 7), (3, 8),
(4, 1), (4, 2), (4, 3), (4, 4), (4, 5), (4, 6), (4, 7), (4, 8),
(5, 1), (5, 2), (5, 3), (5, 4), (5, 5), (5, 6), (5, 7), (5, 8);

-- Insert Super Admin (NULL academy_reference = super admin)
-- Password: admin123
INSERT INTO `admins` (`id`, `username`, `password_hash`, `momo_number`, `academy_reference`, `account_verified`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', '+26876873207', NULL, 1);

-- Insert Academy References (Schools)
INSERT INTO `academy_references` (`id`, `reference_code`, `academy_name`, `contact_email`, `contact_phone`, `address`, `is_active`, `subscription_status`, `onboarding_date`) VALUES
(1, 'KINE', 'Kine Academy', 'info@kineacademy.co.sz', '+26876873207', 'Mbabane, Eswatini', 1, 'active', '2024-01-01'),
(2, 'TEST', 'TEST School', 'admin@testschool.co.sz', '+26878901234', 'Manzini, Eswatini', 1, 'active', '2024-10-01');

-- Insert Tenant Settings for KINE Academy
INSERT INTO `tenant_settings` (`academy_reference`, `setting_key`, `setting_value`) VALUES
('KINE', 'school_name', 'Kine Academy'),
('KINE', 'school_email', 'info@kineacademy.co.sz'),
('KINE', 'school_phone', '+26876873207'),
('KINE', 'school_address', 'Mbabane, Eswatini'),
('KINE', 'primary_color', '#6366f1'),
('KINE', 'secondary_color', '#8b5cf6'),
('KINE', 'academic_year', '2024/2025'),
('KINE', 'email_from_name', 'Kine Academy'),
('KINE', 'email_signature', 'Best regards,\nKine Academy Team');

-- Insert Tenant Settings for TEST School
INSERT INTO `tenant_settings` (`academy_reference`, `setting_key`, `setting_value`) VALUES
('TEST', 'school_name', 'TEST School'),
('TEST', 'school_email', 'admin@testschool.co.sz'),
('TEST', 'school_phone', '+26878901234'),
('TEST', 'school_address', 'Manzini, Eswatini'),
('TEST', 'primary_color', '#10b981'),
('TEST', 'secondary_color', '#059669'),
('TEST', 'academic_year', '2024/2025'),
('TEST', 'email_from_name', 'TEST School'),
('TEST', 'email_signature', 'Best regards,\nTEST School Administration');

-- =====================================================
-- INSERT TEST STUDENTS (5 for KINE, 5 for TEST)
-- =====================================================

-- KINE Academy Students (Password for all: StudentPass123!)
INSERT INTO `students` (`username`, `password_hash`, `full_name`, `email`, `email_verified`, `phone`, `dob`, `gender`, `guardian_name`, `guardian_phone`, `momo_number`, `payment_amount`, `payment_status`, `moodle_status`, `academy_reference`, `created_at`) VALUES
('alice2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Alice Johnson', 'alice@kineacademy.co.sz', 1, '+26876001001', '2008-03-15', 'Female', 'Mary Johnson', '+26876001000', '+26876001001', 350.00, 'active', 'active', 'KINE', '2024-09-01 08:00:00'),
('bob2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Bob Smith', 'bob@kineacademy.co.sz', 1, '+26876002002', '2008-07-22', 'Male', 'John Smith', '+26876002000', '+26876002002', 350.00, 'active', 'active', 'KINE', '2024-09-01 09:00:00'),
('charlie2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Charlie Brown', 'charlie@kineacademy.co.sz', 1, '+26876003003', '2009-01-10', 'Male', 'Sarah Brown', '+26876003000', '+26876003003', 350.00, 'active', 'active', 'KINE', '2024-09-01 10:00:00'),
('diana2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Diana Prince', 'diana@kineacademy.co.sz', 1, '+26876004004', '2008-11-05', 'Female', 'Steve Prince', '+26876004000', '+26876004004', 350.00, 'active', 'active', 'KINE', '2024-09-01 11:00:00'),
('edward2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Edward Norton', 'edward@kineacademy.co.sz', 1, '+26876005005', '2009-05-18', 'Male', 'Helen Norton', '+26876005000', '+26876005005', 350.00, 'active', 'active', 'KINE', '2024-09-01 12:00:00');

-- TEST School Students (Password for all: StudentPass123!)
INSERT INTO `students` (`username`, `password_hash`, `full_name`, `email`, `email_verified`, `phone`, `dob`, `gender`, `guardian_name`, `guardian_phone`, `momo_number`, `payment_amount`, `payment_status`, `moodle_status`, `academy_reference`, `created_at`) VALUES
('frank2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Frank Wilson', 'frank@testschool.co.sz', 1, '+26878001001', '2008-04-12', 'Male', 'Linda Wilson', '+26878001000', '+26878001001', 300.00, 'active', 'active', 'TEST', '2024-10-01 08:00:00'),
('grace2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Grace Kelly', 'grace@testschool.co.sz', 1, '+26878002002', '2008-08-25', 'Female', 'Robert Kelly', '+26878002000', '+26878002002', 300.00, 'active', 'active', 'TEST', '2024-10-01 09:00:00'),
('henry2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Henry Ford', 'henry@testschool.co.sz', 1, '+26878003003', '2009-02-14', 'Male', 'Clara Ford', '+26878003000', '+26878003003', 300.00, 'active', 'active', 'TEST', '2024-10-01 10:00:00'),
('isabel2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Isabel Garcia', 'isabel@testschool.co.sz', 1, '+26878004004', '2008-12-08', 'Female', 'Maria Garcia', '+26878004000', '+26878004004', 300.00, 'active', 'active', 'TEST', '2024-10-01 11:00:00'),
('james2024', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'James Anderson', 'james@testschool.co.sz', 1, '+26878005005', '2009-06-20', 'Male', 'Patricia Anderson', '+26878005000', '+26878005005', 300.00, 'active', 'active', 'TEST', '2024-10-01 12:00:00');

-- Assign students to grades (Form 1)
INSERT INTO `student_grades` (`student_id`, `grade_id`) VALUES
(1, 1), (2, 1), (3, 1), (4, 1), (5, 1), -- KINE students
(6, 1), (7, 1), (8, 1), (9, 1), (10, 1); -- TEST students

-- =====================================================
-- INSERT SAMPLE PAYMENTS
-- =====================================================

-- KINE Academy Payments
INSERT INTO `payments` (`student_id`, `amount`, `payment_reference`, `status`, `payment_date`, `momo_number`, `payment_method`, `admin_earnings`, `platform_fee`, `academy_reference`) VALUES
(1, 350.00, 'PAY-KINE-001-20241001', 'completed', '2024-10-01 10:30:00', '+26876001001', 'mtn_momo', 280.00, 70.00, 'KINE'),
(2, 350.00, 'PAY-KINE-002-20241002', 'completed', '2024-10-02 11:15:00', '+26876002002', 'mtn_momo', 280.00, 70.00, 'KINE'),
(3, 350.00, 'PAY-KINE-003-20241003', 'completed', '2024-10-03 09:45:00', '+26876003003', 'mtn_momo', 280.00, 70.00, 'KINE'),
(4, 350.00, 'PAY-KINE-004-20241004', 'completed', '2024-10-04 14:20:00', '+26876004004', 'mtn_momo', 280.00, 70.00, 'KINE');

-- TEST School Payments
INSERT INTO `payments` (`student_id`, `amount`, `payment_reference`, `status`, `payment_date`, `momo_number`, `payment_method`, `admin_earnings`, `platform_fee`, `academy_reference`) VALUES
(6, 300.00, 'PAY-TEST-001-20241010', 'completed', '2024-10-10 10:30:00', '+26878001001', 'mtn_momo', 240.00, 60.00, 'TEST'),
(7, 300.00, 'PAY-TEST-002-20241011', 'completed', '2024-10-11 11:15:00', '+26878002002', 'mtn_momo', 240.00, 60.00, 'TEST'),
(8, 300.00, 'PAY-TEST-003-20241012', 'completed', '2024-10-12 09:45:00', '+26878003003', 'mtn_momo', 240.00, 60.00, 'TEST');

-- Insert corresponding platform fees
INSERT INTO `platform_fees` (`payment_id`, `student_id`, `total_amount`, `platform_fee`, `admin_earnings`, `fee_percentage`, `payment_method`) VALUES
(1, 1, 350.00, 70.00, 280.00, 20.00, 'mtn_momo'),
(2, 2, 350.00, 70.00, 280.00, 20.00, 'mtn_momo'),
(3, 3, 350.00, 70.00, 280.00, 20.00, 'mtn_momo'),
(4, 4, 350.00, 70.00, 280.00, 20.00, 'mtn_momo'),
(5, 6, 300.00, 60.00, 240.00, 20.00, 'mtn_momo'),
(6, 7, 300.00, 60.00, 240.00, 20.00, 'mtn_momo'),
(7, 8, 300.00, 60.00, 240.00, 20.00, 'mtn_momo');

-- =====================================================
-- CREATE INDEXES FOR PERFORMANCE
-- =====================================================

-- Additional indexes for better query performance
CREATE INDEX idx_students_created_at ON students(created_at);
CREATE INDEX idx_payments_created_at ON payments(payment_date);
CREATE INDEX idx_tenant_settings_key ON tenant_settings(setting_key);

-- =====================================================
-- RESET AUTO INCREMENT
-- =====================================================

ALTER TABLE `admins` AUTO_INCREMENT = 2;
ALTER TABLE `grades` AUTO_INCREMENT = 6;
ALTER TABLE `subjects` AUTO_INCREMENT = 11;
ALTER TABLE `academy_references` AUTO_INCREMENT = 3;
ALTER TABLE `students` AUTO_INCREMENT = 11;
ALTER TABLE `payments` AUTO_INCREMENT = 8;
ALTER TABLE `platform_fees` AUTO_INCREMENT = 8;
ALTER TABLE `student_grades` AUTO_INCREMENT = 11;

-- =====================================================
-- FINAL COMMIT
-- =====================================================

COMMIT;

-- =====================================================
-- DATABASE SETUP COMPLETE!
-- =====================================================
-- 
-- Summary:
-- ✅ 36 tables created
-- ✅ Multi-tenant architecture ready
-- ✅ 2 schools: KINE Academy, TEST School
-- ✅ 10 test students (5 per school)
-- ✅ 7 sample payments
-- ✅ Default grades and subjects
-- ✅ All indexes created
-- ✅ Production ready!
--
-- Login Credentials:
-- Super Admin: admin / admin123
-- Students: alice2024, bob2024, etc. / StudentPass123!
--
-- Schools:
-- - KINE Academy (reference: KINE) - 5 students
-- - TEST School (reference: TEST) - 5 students
--
-- =====================================================

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;

