-- ================================================================
-- DEBUG LOGIN ISSUES - Run this to see what's wrong
-- ================================================================

-- Check 1: Does superadmin account exist?
SELECT 'Check 1: Does superadmin exist?' as check_name;
SELECT 
    CASE 
        WHEN COUNT(*) > 0 THEN '✅ YES - Account exists'
        ELSE '❌ NO - Account does not exist'
    END as result
FROM admins 
WHERE username = 'superadmin';

-- Check 2: Show superadmin details
SELECT 'Check 2: Superadmin account details' as check_name;
SELECT 
    id,
    username,
    COALESCE(email, 'N/A') as email,
    LEFT(password_hash, 20) as password_hash_preview,
    COALESCE(academy_reference, 'NULL (Super Admin)') as academy_reference,
    COALESCE(is_active, 'N/A') as is_active
FROM admins 
WHERE username = 'superadmin';

-- Check 3: Show ALL admin accounts
SELECT 'Check 3: All admin accounts' as check_name;
SELECT 
    id,
    username,
    COALESCE(email, 'N/A') as email,
    CASE 
        WHEN academy_reference IS NULL THEN '✅ SUPER ADMIN'
        ELSE CONCAT('School: ', academy_reference)
    END as type,
    COALESCE(is_active, 1) as is_active
FROM admins
ORDER BY id;

-- Check 4: Verify password hash format
SELECT 'Check 4: Password hash format check' as check_name;
SELECT 
    username,
    CASE 
        WHEN password_hash LIKE '$2y$%' THEN '✅ Valid bcrypt hash'
        WHEN password_hash LIKE '$2a$%' THEN '✅ Valid bcrypt hash (old)'
        ELSE '❌ Invalid hash format'
    END as hash_status,
    LENGTH(password_hash) as hash_length,
    LEFT(password_hash, 7) as hash_prefix
FROM admins
WHERE username IN ('superadmin', 'admin');

-- Check 5: Check if is_active column exists
SELECT 'Check 5: Table structure' as check_name;
SHOW COLUMNS FROM admins;

-- ================================================================
-- INTERPRETATION:
-- ================================================================
-- 
-- If Check 1 shows "NO":
--   → Run CREATE_SUPERADMIN_SIMPLE.sql to create the account
-- 
-- If Check 2 shows the account but login fails:
--   → Password hash might be wrong
--   → Upload includes/functions.php (updated login function)
-- 
-- If Check 4 shows invalid hash:
--   → Password hash is corrupted
--   → Run CREATE_SUPERADMIN_SIMPLE.sql again
-- 
-- If is_active = 0:
--   → Account is disabled
--   → Run: UPDATE admins SET is_active = 1 WHERE username = 'superadmin';
-- 
-- ================================================================
